<?php
namespace Modules\StockRecalculation\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\DB;
use App\Utils\ProductUtil;
use Modules\StockRecalculation\Utils\Concerns\StockIntegrity;

class RecalculateStock extends Command
{
    use StockIntegrity;

    protected $signature = 'stock:recalculate {--business_id=} {--location_id=} {--variation_id=}';
    protected $description = 'Recalculate variation_location_details.qty_available from authoritative transactions.';

    public function handle(): int
    {
        $businessId = $this->option('business_id') ? (int)$this->option('business_id') : null;
        $locationId = $this->option('location_id') ? (int)$this->option('location_id') : null;
        $variationId = $this->option('variation_id') ? (int)$this->option('variation_id') : null;

        $q = DB::table('variation_location_details as vld')
            ->join('business_locations as bl', 'bl.id', '=', 'vld.location_id')
            ->select('bl.business_id', 'vld.location_id', 'vld.variation_id')
            ->when($businessId !== null, function($qq) use ($businessId){ return $qq->where('bl.business_id', $businessId); })
            ->when($locationId !== null, function($qq) use ($locationId){ return $qq->where('vld.location_id', $locationId); })
            ->when($variationId !== null, function($qq) use ($variationId){ return $qq->where('vld.variation_id', $variationId); })
            ->orderBy('vld.location_id')->orderBy('vld.variation_id');

        $rows = $q->get();
        if($rows->isEmpty()){ $this->info('No rows matched filters.'); return 0; }

        $count = 0;
        $pu = app(ProductUtil::class);

        foreach($rows as $r){
            try{
                if(method_exists($pu,'syncVariationLocationQty')){
                    $pu->syncVariationLocationQty((int)$r->business_id,(int)$r->variation_id,(int)$r->location_id);
                } else {
                    $qty = $this->computeVldQty((int)$r->business_id,(int)$r->variation_id,(int)$r->location_id);
                    DB::table('variation_location_details as vld')
                        ->where('vld.variation_id',(int)$r->variation_id)
                        ->where('vld.location_id',(int)$r->location_id)
                        ->update(['qty_available'=>$qty]);
                }
                $count++;
            } catch(\Throwable $e){
                $this->error('Failed for variation_id='.(int)$r->variation_id.' location_id='.(int)$r->location_id.' : '.$e->getMessage());
            }
        }

        $this->info('Recalculated rows: '.$count);
        return 0;
    }
}