<?php

return [
    'name' => 'StockRecalculation',
    'module_version' => '1.2.0',
    'description' => 'Professional Stock Recalculation Module for Ultimate POS',

    // Module settings
    'settings' => [
        'enable_backup_before_recalc' => true,
        'verification_threshold' => 0.0001,
        'max_records_per_batch' => 1000,
        'enable_detailed_logging' => true,
    ],

    // Security settings
    'permissions' => [
        'view' => 'StockRecalculation.view',
        'manage' => 'StockRecalculation.manage',
        'backup' => 'StockRecalculation.backup',
        'recalculate' => 'StockRecalculation.recalculate',
    ],

    // Database settings
    'tables' => [
        'backup_prefix' => 'variation_location_details_backup_',
        'audit_table' => 'stock_recalculation_audits',
    ],
];