<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['web', 'authh', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'], 'prefix' => 'reports', 'namespace' => '\Modules\DailyStockHistory\Http\Controllers'], function () {
	// Date-wise Stock History Report Routes
	Route::get('/date-wise-stock-history', 'DailyStockHistoryController@index')
		->name('reports.date-wise-stock-history');

	Route::get('/date-wise-stock-history/data', 'DailyStockHistoryController@getDateWiseStockHistoryData')
		->name('reports.date-wise-stock-history.data');

	Route::get('/date-wise-stock-history/products', 'DailyStockHistoryController@getProducts')
		->name('reports.date-wise-stock-history.products');

	Route::get('/export-date-wise-stock-history', 'DailyStockHistoryController@exportDateWiseStockHistory')
		->name('reports.export-date-wise-stock-history');
});

// Install routes (separate group with minimal middleware - like Exchange module)
// Note: These routes must be accessible before module is installed, so minimal middleware
Route::middleware(['web', 'auth'])->group(function () {
    Route::prefix('dailystockhistory')->group(function () {
        // Installation routes - minimal middleware to avoid table access issues
        Route::get('/install', 'InstallController@index');
        Route::get('/install/update', 'InstallController@update');
        Route::get('/install/uninstall', 'InstallController@uninstall');
    });
});

