@extends('layouts.app')
@section('title', __('report.date_wise_stock_history'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('report.date_wise_stock_history')}}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row no-print">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => route('reports.date-wise-stock-history'), 'method' => 'get', 'id' => 'date_wise_stock_history_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range_filter', __('report.date_range') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('date_range_filter', null, ['class' => 'form-control', 'readonly', 'placeholder' => __('lang_v1.select_a_date_range'), 'id' => 'date_range_filter']); !!}
                        </div>
                        {!! Form::hidden('start_date', !empty(request()->start_date) ? request()->start_date : \Carbon\Carbon::now()->startOfMonth()->format('Y-m-d'), ['id' => 'start_date']); !!}
                        {!! Form::hidden('end_date', !empty(request()->end_date) ? request()->end_date : \Carbon\Carbon::now()->format('Y-m-d'), ['id' => 'end_date']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $business_locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all')]); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', [], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('variation_id', __('product.variation') . ':') !!}
                        {!! Form::select('variation_id', [], null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('messages.all'), 'id' => 'variation_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('sub_category_id', __('product.sub_category') . ':') !!}
                        {!! Form::select('sub_category_id', [], null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%', 'id' => 'sub_category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_id', __('contact.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, null, ['placeholder' => __('messages.all'), 'class' => 'form-control select2', 'style' => 'width:100%']); !!}
                    </div>
                </div>
                <div class="col-md-12">
                    <button type="submit" class="btn btn-primary pull-right" style="margin-top: 25px;">{{ __('report.apply_filters') }}</button>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-solid'])
                <!-- Tally Style Header -->
                <div class="print_section" style="text-align: center; margin-bottom: 20px;">
                    <h2 style="font-size: 18px; font-weight: bold; margin-bottom: 5px;">{{ $business->name }}</h2>
                    <div id="report_period" style="font-size: 14px; margin-bottom: 15px;"></div>
                </div>

                <div class="row no-print" style="margin-bottom: 10px;">
                    <div class="col-md-12">
                        <div class="btn-group pull-right" role="group">
                            <button type="button" class="btn btn-success btn-sm" id="export_excel">
                                <i class="fa fa-file-excel-o"></i> @lang('messages.export_to_excel')
                            </button>
                            <button type="button" class="btn btn-danger btn-sm" id="export_pdf">
                                <i class="fa fa-file-pdf-o"></i> @lang('messages.export_to_pdf')
                            </button>
                            <button type="button" class="btn btn-info btn-sm" onclick="window.print();">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </button>
                        </div>
                    </div>
                </div>

                <div class="table-responsive" style="background-color: #ffffff;">
                    <table class="table table-bordered" id="date_wise_stock_history_table" style="width: 100%; margin-bottom: 0; border-collapse: collapse; border: 1px solid #d0d0d0;">
                        <thead>
                            <tr style="background-color: #4472C4; color: white;">
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: left; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('lang_v1.date')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: center; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('lang_v1.transaction_type')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: center; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('lang_v1.reference_no')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: left; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('product.product')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: center; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('purchase.business_location')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: right; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('report.opening_balance')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: right; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('report.quantity_in')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: right; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('report.quantity_out')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: right; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('report.running_stock_balance')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: right; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('lang_v1.unit_cost')</th>
                                <th style="padding: 12px 10px; border: 1px solid #1f4e79; font-weight: bold; text-align: left; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif; white-space: nowrap;">@lang('contact.contact')</th>
                            </tr>
                        </thead>
                        <tbody style="background-color: #ffffff;">
                            <!-- Data will be loaded here by DataTables -->
                        </tbody>
                        <tfoot>
                            <tr style="background-color: #D9E1F2; font-weight: bold; border-top: 2px solid #4472C4;">
                                <th colspan="5" style="text-align: right; padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;">@lang('report.grand_total')</th>
                                <th class="text-right" id="total_opening_stock" style="padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;"></th>
                                <th class="text-right" id="total_qty_in" style="padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;"></th>
                                <th class="text-right" id="total_qty_out" style="padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;"></th>
                                <th class="text-right" id="total_running_stock" style="padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;"></th>
                                <th colspan="2" style="padding: 12px 10px; border: 1px solid #d0d0d0; font-size: 14px; font-family: 'Calibri', 'Segoe UI', sans-serif;"></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

<style>
    /* Microsoft Excel Style Table */
    #date_wise_stock_history_table {
        font-family: 'Calibri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        border: 1px solid #d0d0d0;
        border-collapse: collapse;
        background-color: #ffffff;
    }

    /* Excel Style Header */
    #date_wise_stock_history_table thead tr {
        background-color: #4472C4 !important;
        color: #ffffff !important;
        height: 40px;
    }

    #date_wise_stock_history_table thead th {
        border: 1px solid #1f4e79;
        padding: 12px 10px;
        font-weight: bold;
        font-size: 14px;
        font-family: 'Calibri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        text-align: center;
        vertical-align: middle;
        white-space: nowrap;
    }

    /* Excel Style Body - Alternating Rows */
    #date_wise_stock_history_table tbody {
        background-color: #ffffff;
    }

    #date_wise_stock_history_table tbody tr {
        background-color: #ffffff;
        border: 1px solid #d0d0d0;
    }

    #date_wise_stock_history_table tbody tr:nth-child(even) {
        background-color: #F2F2F2;
    }

    #date_wise_stock_history_table tbody tr:hover {
        background-color: #E7F3FF !important;
        cursor: pointer;
    }

    /* Excel Style Cells */
    #date_wise_stock_history_table tbody td {
        padding: 10px;
        border: 1px solid #d0d0d0;
        font-size: 13px;
        color: #000000;
        vertical-align: middle;
        background-color: inherit;
        font-family: 'Calibri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    /* Right align for numeric columns */
    #date_wise_stock_history_table tbody td:nth-child(6),
    #date_wise_stock_history_table tbody td:nth-child(7),
    #date_wise_stock_history_table tbody td:nth-child(8),
    #date_wise_stock_history_table tbody td:nth-child(9),
    #date_wise_stock_history_table tbody td:nth-child(10) {
        text-align: right;
        font-family: 'Calibri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        font-size: 13px;
    }

    /* Excel Style Footer */
    #date_wise_stock_history_table tfoot tr {
        background-color: #D9E1F2 !important;
        border-top: 2px solid #4472C4;
        font-weight: bold;
    }

    #date_wise_stock_history_table tfoot th {
        border: 1px solid #d0d0d0;
        padding: 12px 10px;
        font-size: 14px;
        font-family: 'Calibri', 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        color: #000000;
    }

    /* Print Styles */
    @media print {
        .no-print {
            display: none !important;
        }
        .print_section {
            display: block !important;
        }
        #date_wise_stock_history_table {
            background-color: #ffffff !important;
            border: 1px solid #000000 !important;
        }
        #date_wise_stock_history_table thead tr {
            background-color: #4472C4 !important;
            color: white !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        #date_wise_stock_history_table tbody tr {
            background-color: #ffffff !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        #date_wise_stock_history_table tbody tr:nth-child(even) {
            background-color: #F2F2F2 !important;
        }
        #date_wise_stock_history_table tfoot tr {
            background-color: #D9E1F2 !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
        body {
            background: white !important;
        }
    }

    /* DataTables Wrapper Styling */
    .dataTables_wrapper {
        background-color: #ffffff;
        padding: 10px;
    }

    .dataTables_filter input {
        border: 1px solid #d0d0d0;
        padding: 5px 8px;
        border-radius: 3px;
    }

    .dataTables_length select {
        border: 1px solid #d0d0d0;
        padding: 5px 8px;
        border-radius: 3px;
    }
</style>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        if (typeof dateRangeSettings !== 'undefined' && $('#date_range_filter').length) {
            var start = moment().startOf('month');
            var end = moment().endOf('month');
            var startDateValue = '{{ !empty(request()->start_date) ? request()->start_date : \Carbon\Carbon::now()->startOfMonth()->format("Y-m-d") }}';
            var endDateValue = '{{ !empty(request()->end_date) ? request()->end_date : \Carbon\Carbon::now()->format("Y-m-d") }}';
            
            if (startDateValue && endDateValue) {
                start = moment(startDateValue);
                end = moment(endDateValue);
            }
            
            // Update report period display
            function updateReportPeriod() {
                var start_date = '';
                var end_date = '';
                
                if ($('#date_range_filter').data('daterangepicker')) {
                    start_date = $('#date_range_filter').data('daterangepicker').startDate;
                    end_date = $('#date_range_filter').data('daterangepicker').endDate;
                } else {
                    start_date = moment(startDateValue);
                    end_date = moment(endDateValue);
                }
                
                $('#report_period').text('Period: ' + start_date.format('DD-MMM-YYYY') + ' to ' + end_date.format('DD-MMM-YYYY'));
            }
            
            $('#date_range_filter').daterangepicker(
                {
                    ...dateRangeSettings,
                    startDate: start,
                    endDate: end,
                    autoUpdateInput: true
                },
                function(start, end) {
                    var startFormatted = start.format('YYYY-MM-DD');
                    var endFormatted = end.format('YYYY-MM-DD');
                    $('#date_range_filter').val(
                        start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                    );
                    $('#start_date').val(startFormatted);
                    $('#end_date').val(endFormatted);
                    updateReportPeriod();
                    if (typeof dateWiseStockHistoryTable !== 'undefined' && dateWiseStockHistoryTable) {
                        dateWiseStockHistoryTable.ajax.reload();
                    }
                }
            );
            
            $('#date_range_filter').val(
                start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
            );
            $('#start_date').val(start.format('YYYY-MM-DD'));
            $('#end_date').val(end.format('YYYY-MM-DD'));
            updateReportPeriod();
            
            $('#date_range_filter').on('cancel.daterangepicker', function(ev, picker) {
                $('#date_range_filter').val('');
                $('#start_date').val('');
                $('#end_date').val('');
                if (typeof dateWiseStockHistoryTable !== 'undefined' && dateWiseStockHistoryTable) {
                    dateWiseStockHistoryTable.ajax.reload();
                }
            });
        }

        // Initialize select2
        $('#location_id, #category_id, #sub_category_id, #supplier_id').select2();

        // Initialize Product dropdown with AJAX (Dynamic) - Using module's optimized endpoint
        $('#product_id').select2({
            placeholder: '@lang("messages.all")',
            allowClear: true,
            ajax: {
                url: "{{ route('reports.date-wise-stock-history.products') }}",
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        term: params.term || '',
                        location_id: $('#location_id').val() || '',
                        check_qty: false
                    };
                },
                processResults: function(data) {
                    var products = [];
                    if (data && data.length > 0) {
                        $.each(data, function(index, item) {
                            products.push({
                                id: item.variation_id || item.product_id,
                                text: item.text || item.name,
                                product_id: item.product_id,
                                variation_id: item.variation_id,
                                name: item.name,
                                sku: item.sku
                            });
                        });
                    }
                    return {
                        results: products
                    };
                },
                cache: true,
                error: function(xhr, status, error) {
                    console.error('Product load error:', error);
                }
            },
            minimumInputLength: 0
        });

        // Handle product change to load variations dynamically
        $('#product_id').on('select2:select', function(e) {
            var data = e.params.data;
            if (data && data.variation_id) {
                // If variation is selected, populate variation dropdown
                var variationOptions = '<option value="' + data.variation_id + '" selected>' + data.text + '</option>';
                $('#variation_id').html(variationOptions).select2();
            } else {
                // Load all variations for selected product
                loadVariationsForProduct(data.product_id || data.id);
            }
        });

        $('#product_id').on('select2:clear', function() {
            $('#variation_id').html('<option value="">@lang("messages.all")</option>').select2();
        });

        // Function to load variations for a product
        function loadVariationsForProduct(productId) {
            if (!productId) {
                $('#variation_id').html('<option value="">@lang("messages.all")</option>').select2();
                return;
            }

            $.ajax({
                url: "{{ route('reports.date-wise-stock-history.products') }}",
                data: {
                    term: '',
                    location_id: $('#location_id').val() || '',
                    product_id: productId,
                    check_qty: false
                },
                dataType: 'json',
                success: function(data) {
                    var variationOptions = '<option value="">@lang("messages.all")</option>';
                    if (data && data.length > 0) {
                        $.each(data, function(index, item) {
                            if (item.product_id == productId) {
                                var variationText = item.text || (item.name + (item.sub_sku ? ' (' + item.sub_sku + ')' : ''));
                                variationOptions += '<option value="' + (item.variation_id || item.id) + '">' + variationText + '</option>';
                            }
                        });
                    }
                    $('#variation_id').html(variationOptions).select2();
                },
                error: function(xhr, status, error) {
                    console.error('Variation load error:', error);
                    $('#variation_id').html('<option value="">@lang("messages.all")</option>').select2();
                }
            });
        }

        // Handle category change to load sub-categories
        $('#category_id').on('change', function() {
            var categoryId = $(this).val();
            if (!categoryId) {
                $('#sub_category_id').html('<option value="">@lang("messages.all")</option>').select2();
                return;
            }
            $.ajax({
                url: "{{ action([\App\Http\Controllers\ProductController::class, 'getSubCategories']) }}",
                method: 'POST',
                data: { cat_id: categoryId },
                dataType: 'html',
                success: function(html) {
                    $('#sub_category_id').html(html).select2();
                },
                error: function(xhr, status, error) {
                    console.error('Sub-category load error:', error);
                    $('#sub_category_id').html('<option value="">@lang("messages.all")</option>').select2();
                }
            });
        });

        // DataTable initialization
        var dateWiseStockHistoryTable = $('#date_wise_stock_history_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: "{{ route('reports.date-wise-stock-history.data') }}",
                type: 'GET',
                data: function(d) {
                    // Get dates from daterangepicker if available, else from hidden inputs
                    var start_date = '';
                    var end_date = '';
                    
                    if ($('#date_range_filter').length && $('#date_range_filter').data('daterangepicker')) {
                        start_date = $('#date_range_filter').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        end_date = $('#date_range_filter').data('daterangepicker').endDate.format('YYYY-MM-DD');
                    } else {
                        start_date = $('#start_date').val() || '';
                        end_date = $('#end_date').val() || '';
                    }
                    
                    d.start_date = start_date;
                    d.end_date = end_date;
                    d.location_id = $('#location_id').val() || '';
                    d.product_id = $('#product_id').val() || '';
                    d.variation_id = $('#variation_id').val() || '';
                    d.category_id = $('#category_id').val() || '';
                    d.sub_category_id = $('#sub_category_id').val() || '';
                    d.supplier_id = $('#supplier_id').val() || '';
                },
                error: function(xhr, error, thrown) {
                    console.error('DataTables Ajax Error:', error);
                    console.error('Status:', xhr.status);
                    console.error('Response:', xhr.responseText);
                    
                    var errorMsg = 'Error loading stock history data. ';
                    if (xhr.responseJSON) {
                        if (xhr.responseJSON.error) {
                            errorMsg += xhr.responseJSON.error;
                        } else if (xhr.responseJSON.message) {
                            errorMsg += xhr.responseJSON.message;
                        }
                    } else if (xhr.responseText) {
                        try {
                            var response = JSON.parse(xhr.responseText);
                            errorMsg += response.error || response.message || 'Unknown error';
                        } catch(e) {
                            errorMsg += 'Please check the console for more details.';
                        }
                    }
                    
                    alert(errorMsg);
                }
            },
            columns: [
                { 
                    data: 'date', 
                    name: 'date',
                    render: function(data, type, row) {
                        if (type === 'display' && data) {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-size: 13px;">' + data + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'transaction_type', 
                    name: 'transaction_type',
                    render: function(data, type, row) {
                        return data || '-';
                    }
                },
                { 
                    data: 'ref_no', 
                    name: 'ref_no',
                    render: function(data, type, row) {
                        return data || '-';
                    }
                },
                { 
                    data: 'product_display', 
                    name: 'product_display',
                    render: function(data, type, row) {
                        return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-size: 13px;">' + (data || '-') + '</span>';
                    }
                },
                { 
                    data: 'location_name', 
                    name: 'location_name',
                    render: function(data, type, row) {
                        return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-size: 13px;">' + (data || '-') + '</span>';
                    }
                },
                { 
                    data: 'opening_stock_qty', 
                    name: 'opening_stock_qty', 
                    className: 'text-right',
                    render: function(data, type, row) {
                        if (type === 'display') {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-size: 13px;">' + (data || '-') + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'qty_in', 
                    name: 'qty_in', 
                    className: 'text-right',
                    render: function(data, type, row) {
                        if (type === 'display') {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-size: 13px;">' + (data || '-') + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'qty_out', 
                    name: 'qty_out', 
                    className: 'text-right',
                    render: function(data, type, row) {
                        if (type === 'display') {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-size: 13px;">' + (data || '0.00') + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'running_balance', 
                    name: 'running_balance', 
                    className: 'text-right',
                    render: function(data, type, row) {
                        if (type === 'display') {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-weight: 500; font-size: 13px;">' + (data || '0.00') + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'unit_cost', 
                    name: 'unit_cost', 
                    className: 'text-right',
                    render: function(data, type, row) {
                        if (type === 'display') {
                            return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; color: #000000; font-size: 13px;">' + (data || '0.00') + '</span>';
                        }
                        return data;
                    }
                },
                { 
                    data: 'contact_name', 
                    name: 'contact_name',
                    render: function(data, type, row) {
                        return '<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-size: 13px;">' + (data || '-') + '</span>';
                    }
                }
            ],
            footerCallback: function(row, data, start, end, display) {
                var api = this.api();
                var json = api.ajax.json();
                
                if (json) {
                    $('#total_opening_stock').html('<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-weight: bold; color: #000000; font-size: 14px;">' + (json.total_opening_stock || '0.00') + '</span>');
                    $('#total_qty_in').html('<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-weight: bold; color: #000000; font-size: 14px;">' + (json.total_qty_in || '0.00') + '</span>');
                    $('#total_qty_out').html('<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-weight: bold; color: #000000; font-size: 14px;">' + (json.total_qty_out || '0.00') + '</span>');
                    $('#total_running_stock').html('<span style="font-family: \'Calibri\', \'Segoe UI\', sans-serif; font-weight: bold; color: #C00000; font-size: 14px;">' + (json.total_running_stock || '0.00') + '</span>');
                }
            },
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#date_wise_stock_history_table'));
            },
            order: [[0, 'asc'], [1, 'asc']],
            pageLength: 50,
            lengthMenu: [[10, 25, 50, 100, 500, 1000, -1], [10, 25, 50, 100, 500, 1000, "All"]],
            dom: '<"top"lf>rt<"bottom"ip><"clear">',
            language: {
                emptyTable: "No stock history data available",
                zeroRecords: "No matching records found"
            }
        });

        // Handle form submit
        $('#date_wise_stock_history_filter_form').on('submit', function(e) {
            e.preventDefault();
            dateWiseStockHistoryTable.draw();
        });

        // Export to Excel
        $('#export_excel').on('click', function() {
            var start_date = '';
            var end_date = '';
            if ($('#date_range_filter').length && $('#date_range_filter').data('daterangepicker')) {
                start_date = $('#date_range_filter').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#date_range_filter').data('daterangepicker').endDate.format('YYYY-MM-DD');
            } else {
                start_date = $('#start_date').val() || '';
                end_date = $('#end_date').val() || '';
            }
            
            var url = "{{ route('reports.export-date-wise-stock-history') }}?" + 
                      'start_date=' + encodeURIComponent(start_date) + 
                      '&end_date=' + encodeURIComponent(end_date) +
                      '&location_id=' + encodeURIComponent($('#location_id').val() || '') +
                      '&product_id=' + encodeURIComponent($('#product_id').val() || '') +
                      '&variation_id=' + encodeURIComponent($('#variation_id').val() || '') +
                      '&category_id=' + encodeURIComponent($('#category_id').val() || '') +
                      '&sub_category_id=' + encodeURIComponent($('#sub_category_id').val() || '') +
                      '&supplier_id=' + encodeURIComponent($('#supplier_id').val() || '') +
                      '&format=excel';
            window.location.href = url;
        });

        // Export to PDF
        $('#export_pdf').on('click', function() {
            var start_date = '';
            var end_date = '';
            if ($('#date_range_filter').length && $('#date_range_filter').data('daterangepicker')) {
                start_date = $('#date_range_filter').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#date_range_filter').data('daterangepicker').endDate.format('YYYY-MM-DD');
            } else {
                start_date = $('#start_date').val() || '';
                end_date = $('#end_date').val() || '';
            }
            
            var url = "{{ route('reports.export-date-wise-stock-history') }}?" + 
                      'start_date=' + encodeURIComponent(start_date) + 
                      '&end_date=' + encodeURIComponent(end_date) +
                      '&location_id=' + encodeURIComponent($('#location_id').val() || '') +
                      '&product_id=' + encodeURIComponent($('#product_id').val() || '') +
                      '&variation_id=' + encodeURIComponent($('#variation_id').val() || '') +
                      '&category_id=' + encodeURIComponent($('#category_id').val() || '') +
                      '&sub_category_id=' + encodeURIComponent($('#sub_category_id').val() || '') +
                      '&supplier_id=' + encodeURIComponent($('#supplier_id').val() || '') +
                      '&format=pdf';
            window.open(url, '_blank');
        });
    });
</script>
@endsection
