<?php

namespace Modules\DailyStockHistory\Http\Controllers;

use Illuminate\Routing\Controller;
use App\Utils\ModuleUtil;
use Menu;

class DataController extends Controller
{
    /**
     * Defines module as a superadmin package.
     * @return Array
     */
    public function superadmin_package()
    {
        return [
            [
                'name' => 'DailyStockHistory',
                'label' => __('Date-wise Stock History Report Module'),
                'default' => false
            ]
        ];
    }

    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            [
                'value' => 'dailystockhistory.view',
                'label' => __('View Date-wise Stock History Report'),
                'default' => false
            ],
            [
                'value' => 'dailystockhistory.access',
                'label' => __('Access Date-wise Stock History Module'),
                'default' => false
            ],
        ];
    }

    /**
     * Add menu items to admin sidebar
     */
    public function modifyAdminMenu()
    {
        try {
            // Check if module is installed
            $is_installed = \App\System::getProperty('dailystockhistory_version');
            
            if (empty($is_installed)) {
                return; // Module not installed, don't show menu
            }

            // Add menu item under Reports -> Stock section
            $menu = Menu::instance('admin-sidebar-menu');

            // Find the Reports -> Stock dropdown and add the menu item
            // We need to add it to the existing Stock reports section
            // This will be added to the Reports dropdown -> Stock submenu
            // Use translation from module's language file or fallback to report.php
            $menu_label = trans('dailystockhistory::lang.date_wise_stock_history');
            // If translation returns the key itself, use report.php translation
            if ($menu_label == 'dailystockhistory::lang.date_wise_stock_history') {
                $menu_label = trans('report.date_wise_stock_history');
            }
            
            $menu->url(
                route('reports.date-wise-stock-history'),
                $menu_label,
                [
                    'icon' => '',
                    'active' => request()->segment(2) == 'date-wise-stock-history',
                ]
            )->order(50);
        } catch (\Exception $e) {
            // Silently ignore errors to avoid breaking the whole sidebar
            \Log::error('DailyStockHistory menu error: ' . $e->getMessage());
        }
    }
}

