# Camera Barcode Scanner Module - Changelog

## Version 1.1.0 (2025-01-11)

### Added
- **Multi-page support**: Camera scanner now automatically works on all product search pages:
  - `/sale-pos/create` - POS Create page
  - `/purchases/create` - Purchase Create page
  - `/purchases/edit` - Purchase Edit page
  - `/sells/create` - Sell Create page
  - `/sells/edit` - Sell Edit page
  - `/stock-transfers/create` - Stock Transfer Create page
  - `/stock-adjustments/create` - Stock Adjustment Create page

### Enhanced
- **Universal injection**: Module now injects automatically on all pages via `get_additional_script()` method
- **Automatic page detection**: JavaScript automatically detects current page/route and configures accordingly
- **Smart input field detection**: Automatically finds and injects buttons next to product search fields
- **Dynamic content support**: Periodically checks for dynamically added search inputs (AJAX-loaded content)
- **Improved targeting**: Better detection of which input field to populate after scanning

### Technical
- Added `get_additional_script()` method in `DataController` for universal page injection
- Enhanced JavaScript with route detection and page configuration system
- Improved input field selector matching with fallback options

## Version 1.0.0 (2025-01-11)

### Initial Release
- Camera barcode scanner functionality
- Support for multiple barcode formats (EAN-13, EAN-8, UPC-A, UPC-E, CODE-128, CODE-39, QR codes, etc.)
- Integration with POS Create page (`/sale-pos/create`)
- Install/Uninstall functionality
- Real-time camera scanning with html5-qrcode library
- Auto-fill product search fields after scanning





