<?php

use Illuminate\Http\Request;
use Modules\BusinessManagement\Http\Controllers\Api\LicenseValidationController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Public license validation endpoint (no authentication required)
Route::post('/license/validate', [LicenseValidationController::class, 'validate'])
    ->name('api.license.validate');

// Protected routes (require authentication)
Route::middleware('auth:api')->get('/businessmanagement', function (Request $request) {
    return $request->user();
});

