@extends('layouts.app')
@section('title', 'Product wise Net Profit')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">Product wise Net Profit</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseNetProfit']), 'method' => 'get', 'id' => 'product_wise_net_profit_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        @php
                            $date_range_value = '';
                            if (!empty($start_date) && !empty($end_date)) {
                                $date_range_value = \Carbon\Carbon::parse($start_date)->format('d/m/Y') . ' ~ ' . \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                            } elseif (!empty(request()->date_range)) {
                                $date_range_value = request()->date_range;
                            }
                        @endphp
                        {!! Form::text('date_range', $date_range_value , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'product_wise_net_profit_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('category_filter', __('category.category') . ':') !!}
                        {!! Form::select('category_filter', ['all' => __('lang_v1.all_categories'), 'single' => __('lang_v1.single_category')], !empty($category_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'category_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="category_select_wrapper" style="display: {{ !empty($category_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('category_id', __('category.category') . ':') !!}
                        {!! Form::select('category_id', $categories, $category_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_category'), 'id' => 'category_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('product_filter', __('product.product') . ':') !!}
                        {!! Form::select('product_filter', ['all' => __('lang_v1.all_products'), 'single' => __('lang_v1.single_product')], !empty($product_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'product_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="product_select_wrapper" style="display: {{ !empty($product_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('product_id', __('product.product') . ':') !!}
                        {!! Form::select('product_id', $products, $product_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_product'), 'id' => 'product_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> @lang('lang_v1.apply_filters')
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'productWiseNetProfit']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> @lang('lang_v1.reset')
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printProductWiseNetProfit'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id ?? '', 'category_id' => $category_id ?? '', 'product_id' => $product_id ?? '']) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> @lang('messages.print')
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($categories_data) > 0)
                        @foreach($categories_data as $category_id_key => $category_data)
                            <h4 style="margin-top: 20px; margin-bottom: 15px; font-weight: bold; color: #2c3e50;">{{ $category_data['category_name'] }}</h4>
                            @foreach($category_data['brands'] as $brand_id => $brand_data)
                                <h5 style="margin-top: 15px; margin-bottom: 10px; font-weight: 600; color: #34495e; padding-left: 10px;">{{ $brand_data['brand_name'] }}</h5>
                                <table class="table table-bordered table-striped" style="font-size: 12px;">
                                    <thead>
                                        <tr>
                                            <th>Product Description</th>
                                            <th style="text-align: right;">Sale Qty</th>
                                            <th style="text-align: right;">Net Unit Price</th>
                                            <th style="text-align: right;">Net Sales Amount</th>
                                            <th style="text-align: right;">Total Cost</th>
                                            <th style="text-align: right;">TotalProfit</th>
                                            <th style="text-align: right;">Return Qty</th>
                                            <th style="text-align: right;">Return Price</th>
                                            <th style="text-align: right;">Return Amount</th>
                                            <th style="text-align: right;">Return Cost</th>
                                            <th style="text-align: right;">Net Total Profit</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($brand_data['products'] as $product)
                                            <tr>
                                                <td>{{ $product['product_description'] }}</td>
                                                <td style="text-align: right;">{{ number_format($product['sale_qty'], 2) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['net_unit_price'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['net_sales_amount'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['total_cost'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['total_profit'], true) }}</td>
                                                <td style="text-align: right;">{{ number_format($product['return_qty'], 2) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['return_price'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['return_amount'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['return_cost'], true) }}</td>
                                                <td style="text-align: right;">{{ $util->num_f($product['net_total_profit'], true) }}</td>
                                            </tr>
                                        @endforeach
                                        <tr style="background-color: #f5f5f5; font-weight: bold;">
                                            <td><strong>Brand Wise Sub Total:</strong></td>
                                            <td style="text-align: right;">{{ number_format($brand_data['brand_total_sale_qty'], 2) }}</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_net_sales_amount'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_cost'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_profit'], true) }}</td>
                                            <td style="text-align: right;">{{ number_format($brand_data['brand_total_return_qty'], 2) }}</td>
                                            <td style="text-align: right;">-</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_return_amount'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_return_cost'], true) }}</td>
                                            <td style="text-align: right;">{{ $util->num_f($brand_data['brand_total_net_profit'], true) }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            @endforeach
                            <table class="table table-bordered" style="font-size: 12px; margin-top: 10px;">
                                <thead>
                                    <tr>
                                        <th>Product Description</th>
                                        <th style="text-align: right;">Sale Qty</th>
                                        <th style="text-align: right;">Net Unit Price</th>
                                        <th style="text-align: right;">Net Sales Amount</th>
                                        <th style="text-align: right;">Total Cost</th>
                                        <th style="text-align: right;">TotalProfit</th>
                                        <th style="text-align: right;">Return Qty</th>
                                        <th style="text-align: right;">Return Price</th>
                                        <th style="text-align: right;">Return Amount</th>
                                        <th style="text-align: right;">Return Cost</th>
                                        <th style="text-align: right;">Net Total Profit</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr style="background-color: #e8e8e8; font-weight: bold;">
                                        <td><strong>Group Wise Sub Total:</strong></td>
                                        <td style="text-align: right;">{{ number_format($category_data['group_total_sale_qty'], 2) }}</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_net_sales_amount'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_cost'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_profit'], true) }}</td>
                                        <td style="text-align: right;">{{ number_format($category_data['group_total_return_qty'], 2) }}</td>
                                        <td style="text-align: right;">-</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_return_amount'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_return_cost'], true) }}</td>
                                        <td style="text-align: right;">{{ $util->num_f($category_data['group_total_net_profit'], true) }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        @endforeach
                        <table class="table table-bordered" style="font-size: 12px; margin-top: 20px;">
                            <thead>
                                <tr>
                                    <th>Product Description</th>
                                    <th style="text-align: right;">Sale Qty</th>
                                    <th style="text-align: right;">Net Unit Price</th>
                                    <th style="text-align: right;">Net Sales Amount</th>
                                    <th style="text-align: right;">Total Cost</th>
                                    <th style="text-align: right;">TotalProfit</th>
                                    <th style="text-align: right;">Return Qty</th>
                                    <th style="text-align: right;">Return Price</th>
                                    <th style="text-align: right;">Return Amount</th>
                                    <th style="text-align: right;">Return Cost</th>
                                    <th style="text-align: right;">Net Total Profit</th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr style="background-color: #d4d4d4; font-weight: bold; font-size: 13px;">
                                    <td><strong>Grand Total:</strong></td>
                                    <td style="text-align: right;">{{ number_format($grand_total_sale_qty, 2) }}</td>
                                    <td style="text-align: right;">-</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_net_sales_amount, true) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_cost, true) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_profit, true) }}</td>
                                    <td style="text-align: right;">{{ number_format($grand_total_return_qty, 2) }}</td>
                                    <td style="text-align: right;">-</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_return_amount, true) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_return_cost, true) }}</td>
                                    <td style="text-align: right;">{{ $util->num_f($grand_total_net_profit, true) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> @lang('lang_v1.no_data_found')
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        var date_range_val = $('#product_wise_net_profit_date_range').val();
        
        if (date_range_val) {
            // Date range already set from PHP
        } else if (start_date && end_date) {
            $('#product_wise_net_profit_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
            $('input[name="start_date"]').val(start_date);
            $('input[name="end_date"]').val(end_date);
        } else if (end_date) {
            $('#product_wise_net_profit_date_range').val(
                moment(end_date).format(moment_date_format)
            );
        }
        
        $('#product_wise_net_profit_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#product_wise_net_profit_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#product_wise_net_profit_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Category filter toggle
        $('#category_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#category_select_wrapper').show();
            } else {
                $('#category_select_wrapper').hide();
                $('#category_id').val(null).trigger('change');
            }
        });

        // Product filter toggle
        $('#product_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#product_select_wrapper').show();
            } else {
                $('#product_select_wrapper').hide();
                $('#product_id').val(null).trigger('change');
            }
        });

        // Reload when date range changes
        $('#product_wise_net_profit_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });

        // Ensure hidden fields are set before form submission
        $('#product_wise_net_profit_filter_form').on('submit', function(e) {
            var date_range_val = $('#product_wise_net_profit_date_range').val();
            if (date_range_val && date_range_val.indexOf(' ~ ') > -1) {
                var dates = date_range_val.split(' ~ ');
                if (dates.length == 2) {
                    var start = moment(dates[0].trim(), moment_date_format);
                    var end = moment(dates[1].trim(), moment_date_format);
                    if (start.isValid() && end.isValid()) {
                        $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                        $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
                    }
                }
            } else {
                // If no date range, clear the hidden fields
                $('input[name="start_date"]').val('');
                $('input[name="end_date"]').val('');
            }
        });
    });
</script>
@endsection

