<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product wise Net Profit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Category Section */
        .category-section {
            margin-bottom: 15px;
            page-break-inside: avoid;
        }
        
        .category-header {
            font-size: 11pt;
            font-weight: 600;
            margin-bottom: 8px;
            color: #1a1a1a;
            padding: 4px;
        }
        
        .brand-header {
            font-size: 10pt;
            font-weight: 600;
            margin-bottom: 6px;
            margin-top: 10px;
            color: #2c3e50;
            padding-left: 10px;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 9pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 6px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            font-size: 9pt;
            text-align: left;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
            font-size: 9pt;
        }
        
        .brand-subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .brand-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .group-subtotal-row {
            background-color: #e8e8e8 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .group-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .grand-total-row {
            background-color: #d4d4d4 !important;
            font-weight: 700;
            font-size: 10pt;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 7px 5px;
        }
        
        /* Footer */
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #6a6a6a;
            text-align: center;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .category-section {
                page-break-inside: avoid;
            }
            
            table {
                page-break-inside: auto;
            }
            
            tr {
                page-break-inside: avoid;
                page-break-after: auto;
            }
            
            thead {
                display: table-header-group;
            }
            
            tfoot {
                display: table-footer-group;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->phone))
                    <div class="company-contact">{{ $business->phone }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Product wise Net Profit</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Report Content -->
        @if(count($categories_data) > 0)
            @foreach($categories_data as $category_id_key => $category_data)
                <div class="category-section">
                    <div class="category-header">{{ $category_data['category_name'] }}</div>
                    
                    @foreach($category_data['brands'] as $brand_id => $brand_data)
                        <div class="brand-header">{{ $brand_data['brand_name'] }}</div>
                        
                        <table class="table-container">
                            <thead>
                                <tr>
                                    <th>Product Description</th>
                                    <th style="text-align: right;">Sale Qty</th>
                                    <th style="text-align: right;">Net Unit Price</th>
                                    <th style="text-align: right;">Net Sales Amount</th>
                                    <th style="text-align: right;">Total Cost</th>
                                    <th style="text-align: right;">TotalProfit</th>
                                    <th style="text-align: right;">Return Qty</th>
                                    <th style="text-align: right;">Return Price</th>
                                    <th style="text-align: right;">Return Amount</th>
                                    <th style="text-align: right;">Return Cost</th>
                                    <th style="text-align: right;">Net Total Profit</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($brand_data['products'] as $product)
                                    <tr>
                                        <td>{{ $product['product_description'] }}</td>
                                        <td class="text-right">{{ number_format($product['sale_qty'], 2) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['net_unit_price'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['net_sales_amount'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['total_cost'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['total_profit'], true) }}</td>
                                        <td class="text-right">{{ number_format($product['return_qty'], 2) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['return_price'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['return_amount'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['return_cost'], true) }}</td>
                                        <td class="text-right">{{ $util->num_f($product['net_total_profit'], true) }}</td>
                                    </tr>
                                @endforeach
                                <tr class="brand-subtotal-row">
                                    <td><strong>Brand Wise Sub Total:</strong></td>
                                    <td class="text-right">{{ number_format($brand_data['brand_total_sale_qty'], 2) }}</td>
                                    <td class="text-right">-</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_net_sales_amount'], true) }}</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_cost'], true) }}</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_profit'], true) }}</td>
                                    <td class="text-right">{{ number_format($brand_data['brand_total_return_qty'], 2) }}</td>
                                    <td class="text-right">-</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_return_amount'], true) }}</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_return_cost'], true) }}</td>
                                    <td class="text-right">{{ $util->num_f($brand_data['brand_total_net_profit'], true) }}</td>
                                </tr>
                            </tbody>
                        </table>
                    @endforeach
                    
                    <table style="margin-top: 10px;">
                        <thead>
                            <tr>
                                <th>Product Description</th>
                                <th style="text-align: right;">Sale Qty</th>
                                <th style="text-align: right;">Net Unit Price</th>
                                <th style="text-align: right;">Net Sales Amount</th>
                                <th style="text-align: right;">Total Cost</th>
                                <th style="text-align: right;">TotalProfit</th>
                                <th style="text-align: right;">Return Qty</th>
                                <th style="text-align: right;">Return Price</th>
                                <th style="text-align: right;">Return Amount</th>
                                <th style="text-align: right;">Return Cost</th>
                                <th style="text-align: right;">Net Total Profit</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr class="group-subtotal-row">
                                <td><strong>Group Wise Sub Total:</strong></td>
                                <td class="text-right">{{ number_format($category_data['group_total_sale_qty'], 2) }}</td>
                                <td class="text-right">-</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_net_sales_amount'], true) }}</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_cost'], true) }}</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_profit'], true) }}</td>
                                <td class="text-right">{{ number_format($category_data['group_total_return_qty'], 2) }}</td>
                                <td class="text-right">-</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_return_amount'], true) }}</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_return_cost'], true) }}</td>
                                <td class="text-right">{{ $util->num_f($category_data['group_total_net_profit'], true) }}</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            @endforeach
            
            <table style="margin-top: 20px;">
                <thead>
                    <tr>
                        <th>Product Description</th>
                        <th style="text-align: right;">Sale Qty</th>
                        <th style="text-align: right;">Net Unit Price</th>
                        <th style="text-align: right;">Net Sales Amount</th>
                        <th style="text-align: right;">Total Cost</th>
                        <th style="text-align: right;">TotalProfit</th>
                        <th style="text-align: right;">Return Qty</th>
                        <th style="text-align: right;">Return Price</th>
                        <th style="text-align: right;">Return Amount</th>
                        <th style="text-align: right;">Return Cost</th>
                        <th style="text-align: right;">Net Total Profit</th>
                    </tr>
                </thead>
                <tbody>
                    <tr class="grand-total-row">
                        <td><strong>Grand Total:</strong></td>
                        <td class="text-right">{{ number_format($grand_total_sale_qty, 2) }}</td>
                        <td class="text-right">-</td>
                        <td class="text-right">{{ $util->num_f($grand_total_net_sales_amount, true) }}</td>
                        <td class="text-right">{{ $util->num_f($grand_total_cost, true) }}</td>
                        <td class="text-right">{{ $util->num_f($grand_total_profit, true) }}</td>
                        <td class="text-right">{{ number_format($grand_total_return_qty, 2) }}</td>
                        <td class="text-right">-</td>
                        <td class="text-right">{{ $util->num_f($grand_total_return_amount, true) }}</td>
                        <td class="text-right">{{ $util->num_f($grand_total_return_cost, true) }}</td>
                        <td class="text-right">{{ $util->num_f($grand_total_net_profit, true) }}</td>
                    </tr>
                </tbody>
            </table>
        @endif

        <!-- Footer -->
        <div class="footer">
            <div>{{ date('m/d/Y h:i:sA') }}</div>
        </div>
    </div>
</body>
</html>

