<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Product Group wise Net Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 10pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Brand Section */
        .brand-section {
            margin-bottom: 15px;
            page-break-inside: avoid;
        }
        
        .brand-header {
            font-size: 11pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            padding: 4px;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 9pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 6px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 9pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 5px 4px;
            font-size: 9pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 9pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .grand-total-row {
            background-color: #e8e8e8 !important;
            font-weight: 700;
            font-size: 10pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 7px 4px;
        }
        
        .footer {
            margin-top: 20px;
            padding-top: 10px;
            border-top: 1px solid #ddd;
            font-size: 8pt;
            color: #6a6a6a;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            vertical-align: top;
            width: 70%;
        }
        
        .footer-right {
            display: table-cell;
            vertical-align: top;
            width: 30%;
            text-align: right;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .brand-header {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
                @if(!empty($business->website))
                    <div class="company-contact">{{ $business->website }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Product Group wise Net Sales</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Brand Sections -->
        @if(count($brands_data) > 0)
            @foreach($brands_data as $brand_id => $brand_data)
                <div class="brand-section">
                    <!-- Brand Header -->
                    <div class="brand-header">
                        Product Brand/ Group: {{ $brand_data['brand_name'] }}
                    </div>

                    <!-- Product Table -->
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Item</th>
                                    <th>Sale Qty</th>
                                    <th>Unit Price</th>
                                    <th>Sales Amount</th>
                                    <th>Return Qty</th>
                                    <th>Return Amount</th>
                                    <th>Net Qty</th>
                                    <th>Net Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($brand_data['products'] as $product)
                                    <tr>
                                        <td>{{ $product['product_name'] }}</td>
                                        <td class="text-right">{{ number_format($product['sale_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['unit_price'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['sales_amount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['return_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['return_amount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['net_qty'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['net_amount'], 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                            <tfoot>
                                <tr class="subtotal-row">
                                    <td class="text-right"><strong>Sub Total:</strong></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_sale_qty'], 2) }}</strong></td>
                                    <td class="text-right"></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_sales_amount'], 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_return_qty'], 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_return_amount'], 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_net_qty'], 2) }}</strong></td>
                                    <td class="text-right"><strong>{{ number_format($brand_data['total_net_amount'], 2) }}</strong></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            @endforeach
            
            <!-- Grand Total -->
            <div class="table-container" style="margin-top: 15px;">
                <table>
                    <tfoot>
                        <tr class="grand-total-row">
                            <td class="text-right"><strong>Grand Total:</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sale_qty, 2) }}</strong></td>
                            <td class="text-right"></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_sales_amount, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_return_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_return_amount, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_net_qty, 2) }}</strong></td>
                            <td class="text-right"><strong>{{ number_format($grand_total_net_amount, 2) }}</strong></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No sales data found for the selected filters.</p>
            </div>
        @endif
        
        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
            </div>
            <div class="footer-right">
                Print Date & Time: {{ date('m/d/Y h:i:s A') }}<br>
                Page 1 of 1
            </div>
        </div>
    </div>
</body>
</html>

