<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer wise Sales</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 80%;
            text-align: center;
        }
        
        .company-logo {
            max-width: 80px;
            max-height: 80px;
        }
        
        .company-name {
            font-size: 20pt;
            font-weight: 600;
            margin-bottom: 6px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 10pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 10pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 16pt;
            font-weight: 600;
            margin: 18px 0 12px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 10pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 10pt;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 8px 6px;
            text-align: center;
            font-weight: 600;
            font-size: 10pt;
            vertical-align: middle;
            letter-spacing: 0.3px;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 7px 6px;
            font-size: 10pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        /* Column alignments */
        table thead th:nth-child(1),
        table thead th:nth-child(2) {
            text-align: left;
        }
        
        table thead th:nth-child(3),
        table thead th:nth-child(4),
        table thead th:nth-child(5),
        table thead th:nth-child(6),
        table thead th:nth-child(7) {
            text-align: right;
        }
        
        table tbody td:nth-child(1),
        table tbody td:nth-child(2) {
            text-align: left;
        }
        
        table tbody td:nth-child(3),
        table tbody td:nth-child(4),
        table tbody td:nth-child(5),
        table tbody td:nth-child(6),
        table tbody td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .customer-header-row {
            background-color: #f5f7fa !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .customer-header-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
            text-align: left;
        }
        
        .invoice-subtotal-row {
            background-color: #f9fafb !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .invoice-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .invoice-subtotal-row td:first-child {
            text-align: left;
        }
        
        .invoice-subtotal-row td:nth-child(3),
        .invoice-subtotal-row td:nth-child(4),
        .invoice-subtotal-row td:nth-child(5),
        .invoice-subtotal-row td:nth-child(6),
        .invoice-subtotal-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .date-subtotal-row {
            background-color: #f0f2f5 !important;
            font-weight: 600;
            font-size: 10pt;
        }
        
        .date-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .date-subtotal-row td:first-child {
            text-align: left;
        }
        
        .date-subtotal-row td:nth-child(3),
        .date-subtotal-row td:nth-child(4),
        .date-subtotal-row td:nth-child(5),
        .date-subtotal-row td:nth-child(6),
        .date-subtotal-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .customer-subtotal-row {
            background-color: #e8ecf1 !important;
            font-weight: 600;
            font-size: 10pt;
            border-top: 1px solid #2c3e50;
        }
        
        .customer-subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 8px 6px;
        }
        
        .customer-subtotal-row td:first-child {
            text-align: left;
        }
        
        .customer-subtotal-row td:nth-child(3),
        .customer-subtotal-row td:nth-child(4),
        .customer-subtotal-row td:nth-child(5),
        .customer-subtotal-row td:nth-child(6),
        .customer-subtotal-row td:nth-child(7) {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        @media print {
            .customer-section {
                page-break-inside: avoid;
            }
            
            .date-section {
                page-break-inside: avoid;
            }
            
            .invoice-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ __('lang_v1.mobile') }}: {{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ __('lang_v1.alternate_number') }}: {{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ __('business.email') }}: {{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Customer wise Sales</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if($start_date && $end_date)
                @php
                    $start_formatted = \Carbon\Carbon::parse($start_date)->format('d/m/Y');
                    $end_formatted = \Carbon\Carbon::parse($end_date)->format('d/m/Y');
                @endphp
                {{ $start_formatted }} To {{ $end_formatted }}
            @endif
        </div>

        <!-- Table Container -->
        <div class="table-container">
            <table>
                <thead>
                    <tr>
                        <th>Invoice No</th>
                        <th>Product Description</th>
                        <th>Qty</th>
                        <th>Unit Price</th>
                        <th>Discount</th>
                        <th>Net Unit Price</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($customers_data as $customer_id => $customer_data)
                        @foreach($customer_data['dates'] as $date => $date_data)
                            <!-- Customer Header with Date -->
                            <tr class="customer-header-row">
                                <td colspan="7"><strong>{{ $customer_data['customer_name'] }} - Date: {{ $date }}</strong></td>
                            </tr>
                            
                            @foreach($date_data['invoices'] as $invoice_no => $invoice_data)
                                @foreach($invoice_data['lines'] as $line)
                                    @php
                                        $discount = 0;
                                        if (!empty($line->line_discount_type) && !empty($line->line_discount_amount)) {
                                            if ($line->line_discount_type == 'fixed') {
                                                $discount = $line->line_discount_amount;
                                            } elseif ($line->line_discount_type == 'percentage') {
                                                $discount = ($line->unit_price_before_discount * $line->line_discount_amount) / 100;
                                            }
                                        }
                                    @endphp
                                    
                                    <tr>
                                        <td>{{ $line->invoice_no ?? '' }}</td>
                                        <td>{{ $line->product_description ?? '' }}</td>
                                        <td>{{ $util->num_f($line->quantity, true) }}</td>
                                        <td>{{ $util->num_f($line->unit_price_before_discount, true) }}</td>
                                        <td>{{ $util->num_f($discount, true) }}</td>
                                        <td>{{ $util->num_f($line->unit_price_inc_tax, true) }}</td>
                                        <td>{{ $util->num_f($line->line_total, true) }}</td>
                                    </tr>
                                @endforeach
                                
                                <!-- Invoice wise Total -->
                                <tr class="invoice-subtotal-row">
                                    <td colspan="2"><strong>Invoice wise Total:</strong></td>
                                    <td><strong>{{ $util->num_f($invoice_data['total_qty'], true) }}</strong></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong>{{ $util->num_f($invoice_data['total_amount'], true) }}</strong></td>
                                </tr>
                            @endforeach
                            
                            <!-- Date wise Total -->
                            <tr class="date-subtotal-row">
                                <td colspan="2"><strong>Date wise Total:</strong></td>
                                <td><strong>{{ $util->num_f($date_data['total_qty'], true) }}</strong></td>
                                <td></td>
                                <td></td>
                                <td></td>
                                <td><strong>{{ $util->num_f($date_data['total_amount'], true) }}</strong></td>
                            </tr>
                        @endforeach
                        
                        <!-- Customer wise Total -->
                        <tr class="customer-subtotal-row">
                            <td colspan="2"><strong>Customer wise Total:</strong></td>
                            <td><strong>{{ $util->num_f($customer_data['total_qty'], true) }}</strong></td>
                            <td></td>
                            <td></td>
                            <td></td>
                            <td><strong>{{ $util->num_f($customer_data['total_amount'], true) }}</strong></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>


