<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer wise Invoice Status</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.4;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 600;
            margin-bottom: 4px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 3px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 14pt;
            font-weight: 600;
            margin: 15px 0 10px 0;
            text-align: center;
            text-transform: uppercase;
            color: #1a1a1a;
            letter-spacing: 1px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 9pt;
            margin-bottom: 15px;
            text-align: center;
            font-weight: 500;
            color: #4a4a4a;
        }
        
        /* Table Styles */
        .table-container {
            width: 100%;
            overflow: visible;
            margin-bottom: 10px;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin: 0;
            font-size: 8pt;
            page-break-inside: auto;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 5px 4px;
            text-align: center;
            font-weight: 600;
            font-size: 8pt;
            vertical-align: middle;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 4px 3px;
            font-size: 8pt;
            text-align: left;
            vertical-align: middle;
            color: #2c3e50;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Courier New', monospace;
        }
        
        .customer-total-row {
            background-color: #f5f5f5 !important;
            font-weight: 600;
            font-size: 8pt;
        }
        
        .customer-total-row td {
            border: 1px solid #2c3e50;
            padding: 5px 4px;
        }
        
        .subtotal-row {
            background-color: #e8e8e8 !important;
            font-weight: 600;
            font-size: 9pt;
            border-top: 2px solid #2c3e50;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 6px 4px;
        }
        
        .grand-total-row {
            background-color: #d3d3d3 !important;
            font-weight: 700;
            font-size: 9pt;
            border-top: 2px solid #2c3e50;
        }
        
        .grand-total-row td {
            border: 1px solid #2c3e50;
            padding: 7px 4px;
        }
        
        .grand-total-row td:last-child,
        .subtotal-row td:last-child {
            border-bottom: 2px solid #000;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .report-title {
                page-break-after: avoid;
            }
            
            .customer-total-row {
                page-break-inside: avoid;
            }
            
            .subtotal-row {
                page-break-inside: avoid;
            }
            
            .grand-total-row {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Customer wise Invoice Status with Ageing (FIFO)</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @elseif(!empty($end_date))
                {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Table -->
        @if(count($invoices_data) > 0)
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Invoice No/Caption</th>
                            <th>Ref. No.</th>
                            <th>Trader Name</th>
                            <th>Mobile No.</th>
                            <th>Amount</th>
                            <th>Received Amount</th>
                            <th>Outstanding</th>
                            <th>Age (Days)</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($grouped_data as $contact_id => $customer_invoices)
                            @foreach($customer_invoices as $index => $invoice)
                                <tr>
                                    <td>{{ $util->format_date($invoice['transaction_date'], false) }}</td>
                                    <td>{{ $invoice['invoice_no'] }}</td>
                                    <td>{{ $invoice['ref_no'] }}</td>
                                    <td>{{ $invoice['customer_name'] }}</td>
                                    <td>{{ $invoice['mobile_no'] }}</td>
                                    <td class="text-right">{{ number_format($invoice['amount'], 2) }}</td>
                                    <td class="text-right">{{ number_format($invoice['received_amount'], 2) }}</td>
                                    <td class="text-right">{{ number_format($invoice['outstanding'], 2) }}</td>
                                    <td class="text-right">{{ $invoice['age_days'] }}</td>
                                </tr>
                            @endforeach
                            
                            <!-- Customer Wise Total -->
                            @if(isset($customers_totals[$contact_id]))
                                <tr class="customer-total-row">
                                    <td colspan="5" class="text-right">Customer wise Total:</td>
                                    <td class="text-right">{{ number_format($customers_totals[$contact_id]['total_amount'], 2) }}</td>
                                    <td class="text-right">{{ number_format($customers_totals[$contact_id]['total_received'], 2) }}</td>
                                    <td class="text-right">{{ number_format($customers_totals[$contact_id]['total_outstanding'], 2) }}</td>
                                    <td></td>
                                </tr>
                            @endif
                        @endforeach
                    </tbody>
                    <tfoot>
                        <!-- Sub Total -->
                        <tr class="subtotal-row">
                            <td colspan="5" class="text-right">Sub Total:</td>
                            <td class="text-right">{{ number_format($sub_total_amount, 2) }}</td>
                            <td class="text-right">{{ number_format($sub_total_received, 2) }}</td>
                            <td class="text-right">{{ number_format($sub_total_outstanding, 2) }}</td>
                            <td></td>
                        </tr>
                        <!-- Grand Total -->
                        <tr class="grand-total-row">
                            <td colspan="5" class="text-right">Grand Total:</td>
                            <td class="text-right">{{ number_format($grand_total_amount, 2) }}</td>
                            <td class="text-right">{{ number_format($grand_total_received, 2) }}</td>
                            <td class="text-right">{{ number_format($grand_total_outstanding, 2) }}</td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        @else
            <div style="text-align: center; padding: 40px; color: #6c757d;">
                <p>No outstanding invoices found for the selected filters.</p>
            </div>
        @endif
    </div>
</body>
</html>

