<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Customer wise Gross Profit</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4 landscape;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Arial', 'Helvetica', sans-serif;
            font-size: 11pt;
            line-height: 1.5;
            color: #2c3e50;
            background: #fff;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            text-align: center;
        }
        
        .header-contact {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            text-align: right;
            font-size: 9pt;
        }
        
        .company-logo {
            max-width: 70px;
            max-height: 70px;
        }
        
        .company-name {
            font-size: 22pt;
            font-weight: 700;
            margin-bottom: 5px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 1px;
        }
        
        .company-address {
            font-size: 11pt;
            margin-bottom: 4px;
            color: #4a4a4a;
        }
        
        .company-contact {
            font-size: 11pt;
            margin-bottom: 3px;
            color: #6a6a6a;
        }
        
        /* Report Title */
        .report-title {
            font-size: 18pt;
            font-weight: 700;
            margin: 20px 0 12px 0;
            text-align: center;
            color: #1a1a1a;
            letter-spacing: 1.5px;
        }
        
        /* Report Info */
        .report-info {
            font-size: 12pt;
            margin-bottom: 18px;
            text-align: center;
            font-weight: 600;
            color: #4a4a4a;
        }
        
        /* Summary Section */
        .summary-section {
            margin-bottom: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
            page-break-inside: avoid;
        }
        
        .summary-title {
            font-size: 15pt;
            font-weight: 700;
            margin-bottom: 12px;
            color: #2c3e50;
        }
        
        .summary-row {
            display: table;
            width: 100%;
            margin-top: 12px;
        }
        
        .summary-item {
            display: table-cell;
            text-align: center;
            padding: 8px;
        }
        
        .summary-label {
            font-size: 10pt;
            color: #6c757d;
            margin-bottom: 5px;
            font-weight: 500;
        }
        
        .summary-value {
            font-size: 14pt;
            font-weight: 700;
            color: #2c3e50;
        }
        
        .summary-profit {
            color: #28a745;
        }
        
        .summary-loss {
            color: #dc3545;
        }
        
        /* Customer Section */
        .customer-section {
            margin-bottom: 25px;
            page-break-inside: avoid;
        }
        
        .customer-name {
            font-size: 14pt;
            font-weight: 700;
            margin-bottom: 12px;
            color: #2c3e50;
        }
        
        .invoice-header {
            font-size: 11pt;
            margin-bottom: 10px;
            color: #4a4a4a;
            font-weight: 500;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 12px;
            font-size: 12pt;
        }
        
        table thead th {
            background-color: #ffffff !important;
            color: #1a1a1a !important;
            border: 1px solid #2c3e50;
            border-bottom: 2px solid #2c3e50;
            padding: 10px 8px;
            text-align: center;
            font-weight: 700;
            font-size: 12pt;
            font-family: 'Arial', 'Helvetica', sans-serif;
        }
        
        table tbody td {
            border: 1px solid #ddd;
            padding: 8px 6px;
            font-size: 12pt;
            text-align: left;
            font-family: 'Arial', 'Helvetica', sans-serif;
        }
        
        table tbody td.text-right {
            text-align: right;
            font-family: 'Arial', 'Helvetica', sans-serif;
            font-size: 12pt;
            font-weight: 500;
        }
        
        .subtotal-row {
            background-color: #f5f5f5 !important;
            font-weight: 700;
            font-size: 13pt;
        }
        
        .subtotal-row td {
            border: 1px solid #2c3e50;
            padding: 9px 7px;
            font-family: 'Arial', 'Helvetica', sans-serif;
        }
        
        .profit-positive {
            color: #28a745;
        }
        
        .profit-negative {
            color: #dc3545;
        }
        
        @media print {
            .header {
                page-break-inside: avoid;
            }
            
            .summary-section {
                page-break-inside: avoid;
            }
            
            .customer-section {
                page-break-inside: avoid;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Company Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ $logo }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-right">
                <div class="company-name">{{ $business->name }}</div>
                @if(!empty($business->landmark))
                    <div class="company-address">{{ $business->landmark }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        @if(!empty($business->city)){{ $business->city }}, @endif
                        @if(!empty($business->state)){{ $business->state }}, @endif
                        @if(!empty($business->country)){{ $business->country }}@endif
                    </div>
                @endif
            </div>
            <div class="header-contact">
                @if(!empty($business->mobile))
                    <div class="company-contact">{{ $business->mobile }}</div>
                @endif
                @if(!empty($business->alternate_number))
                    <div class="company-contact">{{ $business->alternate_number }}</div>
                @endif
                @if(!empty($business->phone))
                    <div class="company-contact">{{ $business->phone }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">{{ $business->email }}</div>
                @endif
            </div>
        </div>

        <!-- Report Title -->
        <div class="report-title">Customer wise Gross Profit</div>
        
        <!-- Report Info -->
        <div class="report-info">
            @if(!empty($start_date) && !empty($end_date))
                {{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}
            @elseif(!empty($end_date))
                {{ $util->format_date($end_date, false) }}
            @endif
        </div>

        <!-- Overall Summary -->
        <div class="summary-section">
            <div class="summary-title">Customer wise Gross Profit</div>
            @if(!empty($start_date) && !empty($end_date))
                <div style="font-size: 12pt; margin-bottom: 12px; font-weight: 500;">{{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}</div>
            @endif
            <div class="summary-row">
                <div class="summary-item">
                    <div class="summary-label">Total Sales Amount</div>
                    <div class="summary-value">{{ number_format($overall_total_sales, 2) }}</div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Total Cost</div>
                    <div class="summary-value">{{ number_format($overall_total_cost, 2) }}</div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Total Gross Profit</div>
                    <div class="summary-value {{ $overall_total_profit >= 0 ? 'summary-profit' : 'summary-loss' }}">{{ number_format($overall_total_profit, 2) }}</div>
                </div>
                <div class="summary-item">
                    <div class="summary-label">Profit(%)</div>
                    <div class="summary-value {{ $overall_profit_percent >= 0 ? 'summary-profit' : 'summary-loss' }}">{{ number_format($overall_profit_percent, 2) }}</div>
                </div>
            </div>
        </div>

        <!-- Customer Details -->
        @foreach($customers_data as $contact_id => $customer_data)
            <div class="customer-section">
                <div class="customer-name">{{ $customer_data['customer_name'] }}</div>
                
                @foreach($customer_data['transactions'] as $transaction)
                    <div style="margin-bottom: 15px;">
                        <div class="invoice-header">
                            <strong>Invoice No.:</strong> {{ $transaction['invoice_no'] }} | 
                            <strong>Date:</strong> {{ $util->format_date($transaction['transaction_date'], false) }}
                        </div>
                        
                        <table>
                            <thead>
                                <tr>
                                    <th>Product Description</th>
                                    <th>Qty</th>
                                    <th>Total Sales Amount</th>
                                    <th>Total Cost</th>
                                    <th>Gross Profit</th>
                                    <th>Profit (%)</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($transaction['products'] as $product)
                                    <tr>
                                        <td>{{ $product['product_name'] }}</td>
                                        <td class="text-right">{{ number_format($product['quantity'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['sales_amount'], 2) }}</td>
                                        <td class="text-right">{{ number_format($product['cost_amount'], 2) }}</td>
                                        <td class="text-right {{ $product['gross_profit'] >= 0 ? 'profit-positive' : 'profit-negative' }}">
                                            {{ number_format($product['gross_profit'], 2) }}
                                        </td>
                                        <td class="text-right {{ $product['profit_percent'] >= 0 ? 'profit-positive' : 'profit-negative' }}">
                                            {{ number_format($product['profit_percent'], 2) }}
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                @endforeach

                <!-- Customer Sub Total -->
                <table>
                    <tbody>
                        <tr class="subtotal-row">
                            <td style="text-align: right;">Sub Totals for {{ $customer_data['customer_name'] }}:</td>
                            <td class="text-right">{{ number_format($customer_data['total_qty'], 2) }}</td>
                            <td class="text-right">{{ number_format($customer_data['total_sales'], 2) }}</td>
                            <td class="text-right">{{ number_format($customer_data['total_cost'], 2) }}</td>
                            <td class="text-right {{ $customer_data['total_profit'] >= 0 ? 'profit-positive' : 'profit-negative' }}">
                                {{ number_format($customer_data['total_profit'], 2) }}
                            </td>
                            <td class="text-right {{ $customer_data['profit_percent'] >= 0 ? 'profit-positive' : 'profit-negative' }}">
                                {{ number_format($customer_data['profit_percent'], 2) }}
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        @endforeach
    </div>
</body>
</html>

