@extends('layouts.app')
@section('title', __('businessmanagement::lang.customer_wise_gross_profit'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.customer_wise_gross_profit') }}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseGrossProfit']), 'method' => 'get', 'id' => 'customer_wise_gross_profit_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'customer_wise_gross_profit_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id', __('business.location') . ':') !!}
                        {!! Form::select('location_id', $locations, $location_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('customer_filter', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_filter', ['all' => __('lang_v1.all_customers'), 'single' => __('lang_v1.single_customer')], !empty($customer_id) ? 'single' : 'all', ['class' => 'form-control', 'id' => 'customer_filter']); !!}
                    </div>
                </div>
                <div class="col-md-3" id="customer_select_wrapper" style="display: {{ !empty($customer_id) ? 'block' : 'none' }};">
                    <div class="form-group">
                        {!! Form::label('customer_id', __('contact.customer') . ':') !!}
                        {!! Form::select('customer_id', $customers, $customer_id ?? null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.select_customer'), 'id' => 'customer_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="submit" class="btn btn-primary">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'customerWiseGrossProfit']) }}" class="btn btn-default">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </a>
                            @if(!empty($start_date) && !empty($end_date))
                            <a href="{{ action([\Modules\BusinessManagement\Http\Controllers\SalesRegisterController::class, 'printCustomerWiseGrossProfit'], ['start_date' => $start_date, 'end_date' => $end_date, 'location_id' => $location_id, 'customer_id' => $customer_id]) }}" 
                               target="_blank" 
                               class="btn btn-success">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </a>
                            @endif
                        </div>
                    </div>
                </div>
                {!! Form::hidden('start_date', $start_date ?? '') !!}
                {!! Form::hidden('end_date', $end_date ?? '') !!}
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive" style="overflow-x: auto;">
                    @if(count($customers_data) > 0)
                        <!-- Overall Summary -->
                        <div style="margin-bottom: 30px; padding: 15px; background: #f8f9fa; border-radius: 5px;">
                            <h3 style="margin-bottom: 15px; color: #2c3e50;">Customer wise Gross Profit</h3>
                            @if(!empty($start_date) && !empty($end_date))
                                <p style="margin-bottom: 15px; font-weight: 500;">{{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}</p>
                            @endif
                            <div style="display: flex; justify-content: space-around; flex-wrap: wrap;">
                                <div style="text-align: center; margin: 10px;">
                                    <div style="font-size: 12px; color: #6c757d; margin-bottom: 5px;">Total Sales Amount</div>
                                    <div style="font-size: 18px; font-weight: 600; color: #2c3e50;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $overall_total_sales }}</span>
                                    </div>
                                </div>
                                <div style="text-align: center; margin: 10px;">
                                    <div style="font-size: 12px; color: #6c757d; margin-bottom: 5px;">Total Cost</div>
                                    <div style="font-size: 18px; font-weight: 600; color: #2c3e50;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $overall_total_cost }}</span>
                                    </div>
                                </div>
                                <div style="text-align: center; margin: 10px;">
                                    <div style="font-size: 12px; color: #6c757d; margin-bottom: 5px;">Total Gross Profit</div>
                                    <div style="font-size: 18px; font-weight: 600; color: #28a745;">
                                        <span class="display_currency" data-currency_symbol="true">{{ $overall_total_profit }}</span>
                                    </div>
                                </div>
                                <div style="text-align: center; margin: 10px;">
                                    <div style="font-size: 12px; color: #6c757d; margin-bottom: 5px;">Profit(%)</div>
                                    <div style="font-size: 18px; font-weight: 600; color: {{ $overall_profit_percent >= 0 ? '#28a745' : '#dc3545' }};">
                                        {{ number_format($overall_profit_percent, 2) }}
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Customer Details -->
                        @foreach($customers_data as $contact_id => $customer_data)
                            <div style="margin-bottom: 30px; border: 1px solid #ddd; padding: 15px; background: #fff;">
                                <h4 style="margin-bottom: 15px; color: #2c3e50; font-weight: 600;">{{ $customer_data['customer_name'] }}</h4>
                                
                                @foreach($customer_data['transactions'] as $transaction)
                                    <div style="margin-bottom: 20px;">
                                        <div style="margin-bottom: 10px;">
                                            <strong>Invoice No.:</strong> {{ $transaction['invoice_no'] }} | 
                                            <strong>Date:</strong> {{ $util->format_date($transaction['transaction_date'], false) }}
                                        </div>
                                        
                                        <table class="table table-bordered table-striped" style="font-size: 12px; margin-bottom: 15px;">
                                            <thead>
                                                <tr>
                                                    <th>Product Description</th>
                                                    <th style="text-align: right;">Qty</th>
                                                    <th style="text-align: right;">Total Sales Amount</th>
                                                    <th style="text-align: right;">Total Cost</th>
                                                    <th style="text-align: right;">Gross Profit</th>
                                                    <th style="text-align: right;">Profit (%)</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($transaction['products'] as $product)
                                                    <tr>
                                                        <td>{{ $product['product_name'] }}</td>
                                                        <td style="text-align: right;">{{ number_format($product['quantity'], 2) }}</td>
                                                        <td style="text-align: right;">
                                                            <span class="display_currency" data-currency_symbol="true">{{ $product['sales_amount'] }}</span>
                                                        </td>
                                                        <td style="text-align: right;">
                                                            <span class="display_currency" data-currency_symbol="true">{{ $product['cost_amount'] }}</span>
                                                        </td>
                                                        <td style="text-align: right; color: {{ $product['gross_profit'] >= 0 ? '#28a745' : '#dc3545' }};">
                                                            <span class="display_currency" data-currency_symbol="true">{{ $product['gross_profit'] }}</span>
                                                        </td>
                                                        <td style="text-align: right; color: {{ $product['profit_percent'] >= 0 ? '#28a745' : '#dc3545' }};">
                                                            {{ number_format($product['profit_percent'], 2) }}
                                                        </td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                @endforeach

                                <!-- Customer Sub Total -->
                                <div style="background-color: #f5f5f5; padding: 10px; border-radius: 5px; margin-top: 15px;">
                                    <table class="table table-bordered" style="font-size: 12px; margin-bottom: 0;">
                                        <tbody>
                                            <tr style="font-weight: 600;">
                                                <td style="text-align: right; width: 60%;">Sub Totals for {{ $customer_data['customer_name'] }}:</td>
                                                <td style="text-align: right;">{{ number_format($customer_data['total_qty'], 2) }}</td>
                                                <td style="text-align: right;">
                                                    <span class="display_currency" data-currency_symbol="true">{{ $customer_data['total_sales'] }}</span>
                                                </td>
                                                <td style="text-align: right;">
                                                    <span class="display_currency" data-currency_symbol="true">{{ $customer_data['total_cost'] }}</span>
                                                </td>
                                                <td style="text-align: right; color: {{ $customer_data['total_profit'] >= 0 ? '#28a745' : '#dc3545' }};">
                                                    <span class="display_currency" data-currency_symbol="true">{{ $customer_data['total_profit'] }}</span>
                                                </td>
                                                <td style="text-align: right; color: {{ $customer_data['profit_percent'] >= 0 ? '#28a745' : '#dc3545' }};">
                                                    {{ number_format($customer_data['profit_percent'], 2) }}
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        @endforeach
                    @else
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle"></i> No data found for the selected filters.
                        </div>
                    @endif
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        var start_date = '{{ $start_date ?? "" }}';
        var end_date = '{{ $end_date ?? "" }}';
        
        if (start_date && end_date) {
            $('#customer_wise_gross_profit_date_range').val(
                moment(start_date).format(moment_date_format) + ' ~ ' + moment(end_date).format(moment_date_format)
            );
        } else if (end_date) {
            $('#customer_wise_gross_profit_date_range').val(
                moment(end_date).format(moment_date_format)
            );
        }
        
        $('#customer_wise_gross_profit_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#customer_wise_gross_profit_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
                $('input[name="start_date"]').val(start.format('YYYY-MM-DD'));
                $('input[name="end_date"]').val(end.format('YYYY-MM-DD'));
            }
        );

        $('#customer_wise_gross_profit_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
            $('input[name="start_date"]').val('');
            $('input[name="end_date"]').val('');
        });

        // Customer filter toggle
        $('#customer_filter').on('change', function() {
            if ($(this).val() == 'single') {
                $('#customer_select_wrapper').show();
            } else {
                $('#customer_select_wrapper').hide();
                $('#customer_id').val('').trigger('change');
            }
        });

        // Reload when date range changes
        $('#customer_wise_gross_profit_date_range').on('apply.daterangepicker', function(ev, picker) {
            $('input[name="start_date"]').val(picker.startDate.format('YYYY-MM-DD'));
            $('input[name="end_date"]').val(picker.endDate.format('YYYY-MM-DD'));
        });
    });
</script>
@endsection

