@extends('layouts.app')
@section('title', __('businessmanagement::lang.date_wise_purchase'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1 class="tw-text-xl md:tw-text-3xl tw-font-bold tw-text-black">{{ __('businessmanagement::lang.date_wise_purchase')}}</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
              {!! Form::open(['url' => action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, 'dateWisePurchase']), 'method' => 'get', 'id' => 'date_wise_purchase_filter_form' ]) !!}
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('supplier_id',  __('purchase.supplier') . ':') !!}
                        {!! Form::select('supplier_id', $suppliers, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_suppliers'), 'id' => 'supplier_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('location_id',  __('sale.location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all_locations'), 'id' => 'location_id']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        {!! Form::label('date_range', __('report.date_range') . ':') !!}
                        {!! Form::text('date_range', null , ['placeholder' => __('lang_v1.select_a_date_range'), 'class' => 'form-control', 'id' => 'date_wise_purchase_date_range', 'readonly']); !!}
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group">
                        <label>&nbsp;</label>
                        <div>
                            <button type="button" class="btn btn-primary" id="apply_filters">
                                <i class="fa fa-filter"></i> {{ __('businessmanagement::lang.apply_filters') }}
                            </button>
                            <button type="button" class="btn btn-default" id="reset_filters">
                                <i class="fa fa-refresh"></i> {{ __('businessmanagement::lang.reset') }}
                            </button>
                            <button type="button" class="btn btn-success" id="print_report" style="display: none;">
                                <i class="fa fa-print"></i> {{ __('businessmanagement::lang.print') }}
                            </button>
                        </div>
                    </div>
                </div>
                {!! Form::close() !!}
            @endcomponent
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            @component('components.widget', ['class' => 'box-primary'])
                <div class="table-responsive">
                    <table class="table table-bordered table-striped" id="date_wise_purchase_table">
                        <thead>
                            <tr>
                                <th>@lang('sale.date')</th>
                                <th>@lang('purchase.ref_no')</th>
                                <th>@lang('purchase.supplier')</th>
                                <th>@lang('lang_v1.entered_by')</th>
                                <th>@lang('lang_v1.bill_type')</th>
                                <th>@lang('sale.discount')</th>
                                <th>@lang('lang_v1.extra_charges')</th>
                                <th>@lang('sale.tax')</th>
                                <th>@lang('sale.total')</th>
                                <th>@lang('lang_v1.link')</th>
                            </tr>
                        </thead>
                        <tfoot>
                            <tr class="bg-gray font-17 text-center footer-total">
                                <td colspan="5"><strong>@lang('sale.total'):</strong></td>
                                <td class="footer_discount"></td>
                                <td class="footer_extra_charges"></td>
                                <td class="footer_tax"></td>
                                <td class="footer_total"></td>
                                <td></td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            @endcomponent
        </div>
    </div>
</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#date_wise_purchase_date_range').daterangepicker(
            dateRangeSettings,
            function(start, end) {
                $('#date_wise_purchase_date_range').val(
                    start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format)
                );
            }
        );

        $('#date_wise_purchase_date_range').on('cancel.daterangepicker', function(ev, picker) {
            $(this).val('');
        });

        var date_wise_purchase_table = $('#date_wise_purchase_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "dateWisePurchase"]) }}',
                data: function(d) {
                    d.supplier_id = $('#supplier_id').val();
                    d.location_id = $('#location_id').val();
                    if ($('#date_wise_purchase_date_range').val()) {
                        var start = $('#date_wise_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                        var end = $('#date_wise_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
                        d.start_date = start;
                        d.end_date = end;
                    }
                    d = __datatable_ajax_callback(d);
                }
            },
            columns: [
                { data: 'transaction_date', name: 'transaction_date' },
                { data: 'ref_no', name: 'ref_no' },
                { data: 'supplier', name: 'supplier_name' },
                { data: 'entered_by', name: 'entered_by' },
                { data: 'bill_type', name: 'bill_type' },
                { data: 'discount_amount', name: 'discount_amount' },
                { data: 'extra_charges', name: 'extra_charges' },
                { data: 'tax_amount', name: 'tax_amount' },
                { data: 'final_total', name: 'final_total' },
                { data: 'link', name: 'link', orderable: false, searchable: false },
            ],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    return typeof i === 'string' ?
                        i.replace(/[\$,]/g, '') * 1 :
                        typeof i === 'number' ?
                        i : 0;
                };

                // Total over all pages
                var discount = api
                    .column(5)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var extra_charges = api
                    .column(6)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var tax = api
                    .column(7)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                var total = api
                    .column(8)
                    .data()
                    .reduce(function (a, b) {
                        return intVal(a) + intVal(b);
                    }, 0);

                // Update footer
                $(api.column(5).footer()).html(__currency_trans_from_en(discount, true));
                $(api.column(6).footer()).html(__currency_trans_from_en(extra_charges, true));
                $(api.column(7).footer()).html(__currency_trans_from_en(tax, true));
                $(api.column(8).footer()).html(__currency_trans_from_en(total, true));
            },
            fnDrawCallback: function(oSettings) {
                __currency_convert_recursively($('#date_wise_purchase_table'));
            },
        });

        // Apply filters button
        $('#apply_filters').on('click', function() {
            date_wise_purchase_table.ajax.reload();
        });

        // Reset filters button
        $('#reset_filters').on('click', function() {
            $('#supplier_id').val('').trigger('change');
            $('#location_id').val('').trigger('change');
            $('#date_wise_purchase_date_range').val('');
            date_wise_purchase_table.ajax.reload();
        });

        // Auto-reload on filter change
        $('#supplier_id, #location_id').on('change', function() {
            date_wise_purchase_table.ajax.reload(null, false);
        });

        // Reload when date range changes
        $('#date_wise_purchase_date_range').on('apply.daterangepicker', function(ev, picker) {
            date_wise_purchase_table.ajax.reload(null, false);
            checkPrintButton();
        });

        // Check if print button should be shown
        function checkPrintButton() {
            var hasDateRange = $('#date_wise_purchase_date_range').val() != '';
            if (hasDateRange) {
                $('#print_report').show();
            } else {
                $('#print_report').hide();
            }
        }

        // Print button click
        $('#print_report').on('click', function() {
            var supplier_id = $('#supplier_id').val() || '';
            var location_id = $('#location_id').val() || '';
            var start_date = '';
            var end_date = '';
            
            if ($('#date_wise_purchase_date_range').val()) {
                start_date = $('#date_wise_purchase_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#date_wise_purchase_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var url = '{{ action([\Modules\BusinessManagement\Http\Controllers\PurchaseRegisterController::class, "printDateWisePurchase"]) }}';
            url += '?supplier_id=' + supplier_id;
            url += '&location_id=' + location_id;
            url += '&start_date=' + start_date;
            url += '&end_date=' + end_date;
            
            window.open(url, '_blank');
        });

        // Initial check
        checkPrintButton();
        
        // Check on filter changes
        $('#apply_filters').on('click', function() {
            setTimeout(checkPrintButton, 500);
        });
    });
</script>
@endsection

