@extends('layouts.app')
@section('title', __('businessmanagement::lang.profit_loss_tally_style'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('businessmanagement::lang.profit_loss_tally_style')
        <small class="text-muted">@lang('businessmanagement::lang.tally_style')</small>
    </h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="print_section">
        <h2 class="text-center">{{ session()->get('business.name') }} - @lang('businessmanagement::lang.profit_loss_tally_style')</h2>
        <p class="text-center text-muted" id="pl_period"></p>
    </div>

    <div class="row no-print">
        <div class="col-md-4 col-xs-12">
            <div class="input-group">
                <span class="input-group-addon bg-light-blue"><i class="fa fa-map-marker"></i></span>
                <select class="form-control select2" id="profit_loss_location_filter" style="width:100%">
                    <option value="">@lang('messages.all')</option>
                    @foreach ($locations as $key => $value)
                        <option value="{{ $key }}">{{ $value }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    
        <div class="col-md-4 col-xs-12">
            <div class="form-group">
                <div class="input-group">
                    <span class="input-group-addon"><i class="fa fa-calendar"></i></span>
                    <input type="text" class="form-control" id="profit_loss_date_range" readonly placeholder="@lang('report.date_range')">
                </div>
            </div>
        </div>
        
        <div class="col-md-4 col-xs-12">
            <button type="button" class="btn btn-primary btn-block" id="generate_pl_btn">
                <i class="fa fa-refresh"></i> @lang('businessmanagement::lang.generate')
            </button>
        </div>
    </div>

    <div class="row no-print">
        <div class="col-sm-12 tw-mb-2">
            <button class="btn btn-primary pull-right" aria-label="Print" onclick="window.print();">
                <i class="fa fa-print"></i> @lang('messages.print')
            </button>
        </div>
    </div>

    <div class="row">
        <div id="pl_data_div" class="col-md-12">
            <div class="alert alert-info text-center">
                <i class="fa fa-info-circle"></i> @lang('businessmanagement::lang.select_date_range')
            </div>
        </div>
    </div>

</section>
<!-- /.content -->

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date range picker
        $('#profit_loss_date_range').daterangepicker(
            dateRangeSettings,
            function (start, end) {
                $('#profit_loss_date_range').val(start.format(moment_date_format) + ' ~ ' + end.format(moment_date_format));
            }
        );

        // Load P&L on button click or location change
        $('#generate_pl_btn, #profit_loss_location_filter').on('click change', function() {
            loadProfitLoss();
        });

        function loadProfitLoss() {
            var start_date = '';
            var end_date = '';
            
            if ($('#profit_loss_date_range').val() != '' && $('#profit_loss_date_range').data('daterangepicker')) {
                start_date = $('#profit_loss_date_range').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_date = $('#profit_loss_date_range').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }
            
            var location_id = $('#profit_loss_location_filter').val() || '';
            
            if (!start_date || !end_date) {
                $('#pl_data_div').html('<div class="alert alert-warning"><i class="fa fa-exclamation-triangle"></i> @lang("businessmanagement::lang.please_select_date_range")</div>');
                return;
            }

            $('#pl_data_div').html('<div class="text-center"><i class="fa fa-spinner fa-spin fa-3x"></i><br>Loading...</div>');

            $.ajax({
                url: '{{ route("businessmanagement.accounts_register.profit_loss_tally_style.get_data") }}',
                method: 'GET',
                data: {
                    start_date: start_date,
                    end_date: end_date,
                    location_id: location_id
                },
            success: function(response) {
                if (response) {
                    if (response.success === false && response.error) {
                        $('#pl_data_div').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + response.error + '</div>');
                    } else {
                        renderTallyPL(response);
                    }
                } else {
                    $('#pl_data_div').html('<div class="alert alert-danger">Error loading data - Empty response</div>');
                }
            },
            error: function(xhr, status, error) {
                console.error('Error:', xhr.responseText);
                var errorMsg = 'Error: Internal Server Error';
                try {
                    if (xhr.responseJSON && xhr.responseJSON.error) {
                        errorMsg = xhr.responseJSON.error;
                    } else if (xhr.responseText) {
                        var response = JSON.parse(xhr.responseText);
                        if (response.error) {
                            errorMsg = response.error;
                        }
                    }
                } catch(e) {
                    errorMsg = 'Error: ' + error + ' (Status: ' + xhr.status + ')';
                }
                $('#pl_data_div').html('<div class="alert alert-danger"><i class="fa fa-exclamation-triangle"></i> ' + errorMsg + '</div>');
            }
            });
        }

        function renderTallyPL(data) {
            var html = '';
            var businessName = '{{ session()->get("business.name") }}';
            var period = data.start_date + ' to ' + data.end_date;
            
            // Update period display
            $('#pl_period').text(period);
            
            // Tally-style P&L with two columns
            html += '<div class="row">';
            
            // LEFT COLUMN (DEBIT/EXPENSES)
            html += '<div class="col-md-6">';
            html += '<div class="tally-pl-container">';
            html += '<div class="tally-pl-header">' + businessName + ' ' + period + '</div>';
            html += '<table class="table table-bordered tally-pl-table">';
            html += '<thead><tr><th>Particulars</th><th class="text-right">Amount</th></tr></thead>';
            html += '<tbody>';
            
            // Left side items
            if (data.left_side && data.left_side.length > 0) {
                data.left_side.forEach(function(section) {
                    // Main section header
                    html += '<tr class="section-header"><td colspan="2"><strong>' + section.label + '</strong></td></tr>';
                    
                    // Sub-items
                    if (section.items && section.items.length > 0) {
                        section.items.forEach(function(item) {
                            // Check if this is a grouped item (expense category with sub-items)
                            if (item.is_group && item.sub_items && item.sub_items.length > 0) {
                                // Group header
                                html += '<tr class="group-header"><td class="pl-20-td"><strong>' + item.label + '</strong></td>';
                                html += '<td class="text-right"><strong>' + __currency_trans_from_en(item.value || 0, true) + '</strong></td>';
                                html += '</tr>';
                                
                                // Sub-items within group
                                item.sub_items.forEach(function(subItem) {
                                    html += '<tr class="item-row">';
                                    html += '<td class="pl-40-td">' + subItem.label + '</td>';
                                    var subValue = parseFloat(subItem.value) || 0;
                                    html += '<td class="text-right">' + __currency_trans_from_en(subValue, true) + '</td>';
                                    html += '</tr>';
                                });
                            } else {
                                // Regular item
                                html += '<tr class="item-row">';
                                html += '<td class="pl-30-td">' + item.label + '</td>';
                                var value = parseFloat(item.value) || 0;
                                var displayValue = value;
                                var cssClass = value >= 0 ? '' : 'text-danger';
                                if (value < 0) {
                                    displayValue = '(-)' + __currency_trans_from_en(Math.abs(value), true);
                                } else {
                                    displayValue = __currency_trans_from_en(value, true);
                                }
                                html += '<td class="text-right ' + cssClass + '">' + displayValue + '</td>';
                                html += '</tr>';
                            }
                        });
                    }
                    
                    // Section total
                    var sectionTotal = parseFloat(section.value) || 0;
                    if (section.items && section.items.length > 0) {
                        html += '<tr class="section-total">';
                        html += '<td><strong>Total</strong></td>';
                        html += '<td class="text-right"><strong>' + __currency_trans_from_en(sectionTotal, true) + '</strong></td>';
                        html += '</tr>';
                    } else if (sectionTotal !== 0 || section.label.indexOf('Gross Profit') !== -1 || section.label.indexOf('Gross Loss') !== -1 || section.label.indexOf('Nett Profit') !== -1 || section.label.indexOf('Nett Loss') !== -1) {
                        html += '<tr class="section-value-row">';
                        html += '<td><strong>' + section.label + '</strong></td>';
                        html += '<td class="text-right"><strong>' + __currency_trans_from_en(sectionTotal, true) + '</strong></td>';
                        html += '</tr>';
                    }
                });
            }
            
            // Final Total
            if (data.final_total_left) {
                html += '<tr class="final-total-row">';
                html += '<td><strong>Total</strong></td>';
                html += '<td class="text-right underline-double"><strong>' + __currency_trans_from_en(data.final_total_left, true) + '</strong></td>';
                html += '</tr>';
            }
            
            html += '</tbody>';
            html += '</table>';
            html += '</div>';
            html += '</div>';
            
            // RIGHT COLUMN (CREDIT/INCOME)
            html += '<div class="col-md-6">';
            html += '<div class="tally-pl-container">';
            html += '<div class="tally-pl-header">' + businessName + ' ' + period + '</div>';
            html += '<table class="table table-bordered tally-pl-table">';
            html += '<thead><tr><th>Particulars</th><th class="text-right">Amount</th></tr></thead>';
            html += '<tbody>';
            
            // Right side items
            if (data.right_side && data.right_side.length > 0) {
                data.right_side.forEach(function(section) {
                    // Main section header
                    html += '<tr class="section-header"><td colspan="2"><strong>' + section.label + '</strong></td></tr>';
                    
                    // Sub-items
                    if (section.items && section.items.length > 0) {
                        section.items.forEach(function(item) {
                            html += '<tr class="item-row">';
                            html += '<td class="pl-30-td">' + item.label + '</td>';
                            var value = parseFloat(item.value) || 0;
                            var displayValue = value;
                            var cssClass = value >= 0 ? '' : 'text-danger';
                            if (value < 0) {
                                displayValue = '(-)' + __currency_trans_from_en(Math.abs(value), true);
                            } else {
                                displayValue = __currency_trans_from_en(value, true);
                            }
                            html += '<td class="text-right ' + cssClass + '">' + displayValue + '</td>';
                            html += '</tr>';
                        });
                    }
                    
                    // Section total
                    var sectionTotal = parseFloat(section.value) || 0;
                    if (section.items && section.items.length > 0) {
                        html += '<tr class="section-total">';
                        html += '<td><strong>Total</strong></td>';
                        html += '<td class="text-right"><strong>' + __currency_trans_from_en(sectionTotal, true) + '</strong></td>';
                        html += '</tr>';
                    } else if (sectionTotal !== 0 || section.label.indexOf('Gross Profit') !== -1 || section.label.indexOf('Gross Loss') !== -1) {
                        html += '<tr class="section-value-row">';
                        html += '<td>' + section.label + '</td>';
                        html += '<td class="text-right"><strong>' + __currency_trans_from_en(sectionTotal, true) + '</strong></td>';
                        html += '</tr>';
                    }
                });
            }
            
            // Final Total
            if (data.final_total_right) {
                html += '<tr class="final-total-row">';
                html += '<td><strong>Total</strong></td>';
                html += '<td class="text-right underline-double"><strong>' + __currency_trans_from_en(data.final_total_right, true) + '</strong></td>';
                html += '</tr>';
            }
            
            html += '</tbody>';
            html += '</table>';
            html += '</div>';
            html += '</div>';
            
            html += '</div>'; // End row
            
            $('#pl_data_div').html(html);
            
            // Apply currency conversion
            __currency_convert_recursively($('#pl_data_div'));
        }

        // Load on date range change
        $('#profit_loss_date_range').on('apply.daterangepicker', function(ev, picker) {
            loadProfitLoss();
        });
    });
</script>
<style>
    .tally-pl-container {
        background-color: #fff5f5;
        padding: 15px;
        margin-bottom: 20px;
    }
    .tally-pl-header {
        font-weight: bold;
        text-align: center;
        margin-bottom: 10px;
        font-size: 16px;
    }
    .tally-pl-table {
        font-size: 13px;
        margin-bottom: 0;
        background-color: white;
    }
    .tally-pl-table th {
        background-color: #f8f9fa;
        font-weight: bold;
        border: 1px solid #dee2e6;
    }
    .tally-pl-table td {
        border: 1px solid #dee2e6;
        padding: 8px;
    }
    .tally-pl-table .pl-20-td {
        padding-left: 20px !important;
    }
    .tally-pl-table .pl-30-td {
        padding-left: 30px !important;
    }
    .tally-pl-table .pl-40-td {
        padding-left: 40px !important;
    }
    .group-header {
        background-color: #f0f0f0 !important;
    }
    .section-header {
        background-color: #e9ecef !important;
        font-weight: bold;
    }
    .section-header td {
        font-weight: bold;
        padding: 10px 8px;
    }
    .item-row td {
        padding-left: 30px;
    }
    .section-total {
        background-color: #f8f9fa !important;
    }
    .section-total td {
        font-weight: bold;
    }
    .final-total-row td {
        font-weight: bold;
        padding-top: 15px;
        padding-bottom: 15px;
        font-size: 15px;
    }
    .underline-double {
        border-bottom: 4px double #333 !important;
    }
    .text-danger {
        color: #dc3545;
    }
    @media print {
        .no-print { display: none !important; }
        .print_section { display: block !important; }
        .tally-pl-container {
            background-color: #fff5f5 !important;
            -webkit-print-color-adjust: exact;
            print-color-adjust: exact;
        }
    }
</style>
@endsection




