<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Day Book</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 8pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: left;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 12px;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            page-break-inside: auto;
            font-size: 8pt;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody {
            display: table-row-group;
        }
        
        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: transparent;
        }
        
        th:nth-child(1) { text-align: center; }
        th:nth-child(2), th:nth-child(3), th:nth-child(4) { text-align: left; }
        th:nth-child(5), th:nth-child(6) { text-align: right; }
        
        td {
            border: 1px solid #000;
            padding: 4px 3px;
            font-size: 8pt;
        }
        
        td:nth-child(1) { text-align: center; }
        td:nth-child(2), td:nth-child(3), td:nth-child(4) { text-align: left; }
        td:nth-child(5), td:nth-child(6) { text-align: right; }
        
        .section-header {
            background-color: #f0f0f0;
            font-weight: 700;
        }
        
        .subsection-header {
            font-weight: 700;
            padding-left: 20px !important;
        }
        
        .underline {
            border-top: 1px solid #000;
        }
        
        .double-underline {
            border-top: 2px double #000;
        }
        
        .bold {
            font-weight: 700;
        }
        
        .footer {
            margin-top: 15px;
            font-size: 8pt;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            text-align: left;
            color: #666;
        }
        
        .footer-right {
            display: table-cell;
            text-align: right;
            color: #666;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                <!-- Logo area - can be customized -->
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? '' }}</div>
                @php
                    $address_parts = [];
                    if (!empty($business->address_line_1)) {
                        $address_parts[] = $business->address_line_1;
                    }
                    if (!empty($business->address_line_2)) {
                        $address_parts[] = $business->address_line_2;
                    }
                    if (!empty($business->city)) {
                        $address_parts[] = $business->city;
                    }
                    if (!empty($business->state)) {
                        $address_parts[] = $business->state;
                    }
                    if (!empty($business->country)) {
                        $address_parts[] = $business->country;
                    }
                    $full_address = implode(', ', $address_parts);
                @endphp
                @if(!empty($full_address))
                    <div class="company-address">{{ $full_address }}</div>
                @endif
                @if(!empty($business->mobile))
                    <div class="company-contact">Phone: {{ $business->mobile }}{{ !empty($business->alternate_number) ? ', ' . $business->alternate_number : '' }}</div>
                @endif
                @if(!empty($business->email))
                    <div class="company-contact">Email: {{ $business->email }}</div>
                @endif
            </div>
            <div class="header-right">
                <!-- Right side - can be customized -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Day Book</div>
        
        <!-- Report Date -->
        <div class="report-date">
            @php
                $start_date_formatted = !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y');
                $end_date_formatted = !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y');
            @endphp
            {{ $start_date_formatted }} To {{ $end_date_formatted }}
        </div>
        
        <!-- Day Book Table -->
        <table>
            <thead>
                <tr>
                    <th>InvoiceNO</th>
                    <th>TraderName</th>
                    <th>Ref No</th>
                    <th>Narration</th>
                    <th>Debit</th>
                    <th>Credit</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $grand_total_debit = 0;
                    $grand_total_credit = 0;
                @endphp
                
                <!-- Credit Voucher Section -->
                @if(count($credit_vouchers) > 0)
                    <tr class="section-header">
                        <td colspan="6">Credit voucher</td>
                    </tr>
                    <tr class="subsection-header">
                        <td colspan="6">Receipt</td>
                    </tr>
                    @php $credit_total = 0; @endphp
                    @foreach($credit_vouchers as $voucher)
                        <tr>
                            <td>{{ $voucher->voucher_id }}</td>
                            <td>{{ $voucher->trader_name }}</td>
                            <td>{{ $voucher->ref_no }}</td>
                            <td>{{ $voucher->narration }}</td>
                            <td>{{ $util->num_f($voucher->debit, true, null) }}</td>
                            <td>{{ $util->num_f($voucher->credit, true, null) }}</td>
                        </tr>
                        @php
                            $credit_total += (float) $voucher->credit;
                            $grand_total_credit += (float) $voucher->credit;
                        @endphp
                    @endforeach
                    <tr class="underline">
                        <td colspan="4" class="bold">Sub Total:</td>
                        <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        <td class="bold">{{ $util->num_f($credit_total, true, null) }}</td>
                    </tr>
                @endif
                
                <!-- Debit Voucher Section -->
                @if(count($payment_vouchers) > 0 || count($general_payment_vouchers) > 0)
                    <tr class="section-header">
                        <td colspan="6">Debit voucher</td>
                    </tr>
                    
                    @if(count($payment_vouchers) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Payment</td>
                        </tr>
                        @php $payment_total = 0; @endphp
                        @foreach($payment_vouchers as $voucher)
                            <tr>
                                <td>{{ $voucher->voucher_id }}</td>
                                <td>{{ $voucher->trader_name }}</td>
                                <td>{{ $voucher->ref_no }}</td>
                                <td>{{ $voucher->narration }}</td>
                                <td>{{ $util->num_f($voucher->debit, true, null) }}</td>
                                <td>{{ $util->num_f($voucher->credit, true, null) }}</td>
                            </tr>
                            @php
                                $payment_total += (float) $voucher->debit;
                                $grand_total_debit += (float) $voucher->debit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f($payment_total, true, null) }}</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        </tr>
                    @endif
                    
                    @if(count($general_payment_vouchers) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">General Payment</td>
                        </tr>
                        @php $general_payment_total = 0; @endphp
                        @foreach($general_payment_vouchers as $voucher)
                            <tr>
                                <td>{{ $voucher->voucher_id }}</td>
                                <td>{{ $voucher->trader_name }}</td>
                                <td>{{ $voucher->ref_no }}</td>
                                <td>{{ $voucher->narration }}</td>
                                <td>{{ $util->num_f($voucher->debit, true, null) }}</td>
                                <td>{{ $util->num_f($voucher->credit, true, null) }}</td>
                            </tr>
                            @php
                                $general_payment_total += (float) $voucher->debit;
                                $grand_total_debit += (float) $voucher->debit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f($general_payment_total, true, null) }}</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        </tr>
                    @endif
                    
                    @php
                        $debit_voucher_total = ($payment_total ?? 0) + ($general_payment_total ?? 0);
                    @endphp
                    <tr class="underline">
                        <td colspan="4" class="bold">Sub Total:</td>
                        <td class="bold">{{ $util->num_f($debit_voucher_total, true, null) }}</td>
                        <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                    </tr>
                @endif
                
                <!-- Purchase Section -->
                @if(count($cash_purchases) > 0 || count($credit_purchases) > 0)
                    <tr class="section-header">
                        <td colspan="6">Purchase</td>
                    </tr>
                    
                    @if(count($cash_purchases) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Cash</td>
                        </tr>
                        @php $cash_purchase_total = 0; @endphp
                        @foreach($cash_purchases as $purchase)
                            <tr>
                                <td>{{ $purchase->voucher_id }}</td>
                                <td>{{ $purchase->trader_name }}</td>
                                <td>{{ $purchase->ref_no }}</td>
                                <td>{{ $purchase->narration }}</td>
                                <td>{{ $util->num_f($purchase->debit, true, null) }}</td>
                                <td>{{ $util->num_f($purchase->credit, true, null) }}</td>
                            </tr>
                            @php
                                $cash_purchase_total += (float) $purchase->debit;
                                $grand_total_debit += (float) $purchase->debit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f($cash_purchase_total, true, null) }}</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        </tr>
                    @endif
                    
                    @if(count($credit_purchases) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Credit</td>
                        </tr>
                        @php $credit_purchase_total = 0; @endphp
                        @foreach($credit_purchases as $purchase)
                            <tr>
                                <td>{{ $purchase->voucher_id }}</td>
                                <td>{{ $purchase->trader_name }}</td>
                                <td>{{ $purchase->ref_no }}</td>
                                <td>{{ $purchase->narration }}</td>
                                <td>{{ $util->num_f($purchase->debit, true, null) }}</td>
                                <td>{{ $util->num_f($purchase->credit, true, null) }}</td>
                            </tr>
                            @php
                                $credit_purchase_total += (float) $purchase->debit;
                                $grand_total_debit += (float) $purchase->debit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f($credit_purchase_total, true, null) }}</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        </tr>
                    @endif
                    
                    @php
                        $purchase_total = ($cash_purchase_total ?? 0) + ($credit_purchase_total ?? 0);
                    @endphp
                    <tr class="underline">
                        <td colspan="4" class="bold">Sub Total:</td>
                        <td class="bold">{{ $util->num_f($purchase_total, true, null) }}</td>
                        <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                    </tr>
                @endif
                
                <!-- Sales Section -->
                @if(count($cash_sales) > 0 || count($credit_sales) > 0)
                    <tr class="section-header">
                        <td colspan="6">Sales</td>
                    </tr>
                    
                    @if(count($cash_sales) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Cash</td>
                        </tr>
                        @php $cash_sales_total = 0; @endphp
                        @foreach($cash_sales as $sale)
                            <tr>
                                <td>{{ $sale->voucher_id }}</td>
                                <td>{{ $sale->trader_name }}</td>
                                <td>{{ $sale->ref_no }}</td>
                                <td>{{ $sale->narration }}</td>
                                <td>{{ $util->num_f($sale->debit, true, null) }}</td>
                                <td>{{ $util->num_f($sale->credit, true, null) }}</td>
                            </tr>
                            @php
                                $cash_sales_total += (float) $sale->credit;
                                $grand_total_credit += (float) $sale->credit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                            <td class="bold">{{ $util->num_f($cash_sales_total, true, null) }}</td>
                        </tr>
                    @endif
                    
                    @if(count($credit_sales) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Credit</td>
                        </tr>
                        @php $credit_sales_total = 0; @endphp
                        @foreach($credit_sales as $sale)
                            <tr>
                                <td>{{ $sale->voucher_id }}</td>
                                <td>{{ $sale->trader_name }}</td>
                                <td>{{ $sale->ref_no }}</td>
                                <td>{{ $sale->narration }}</td>
                                <td>{{ $util->num_f($sale->debit, true, null) }}</td>
                                <td>{{ $util->num_f($sale->credit, true, null) }}</td>
                            </tr>
                            @php
                                $credit_sales_total += (float) $sale->credit;
                                $grand_total_credit += (float) $sale->credit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                            <td class="bold">{{ $util->num_f($credit_sales_total, true, null) }}</td>
                        </tr>
                    @endif
                @endif
                
                <!-- Sales Return Section -->
                @if(count($cash_sales_returns) > 0 || count($credit_sales_returns) > 0)
                    <tr class="section-header">
                        <td colspan="6">Sales Return</td>
                    </tr>
                    
                    @if(count($cash_sales_returns) > 0)
                        <tr class="subsection-header">
                            <td colspan="6">Cash</td>
                        </tr>
                        @php $cash_sales_return_total = 0; @endphp
                        @foreach($cash_sales_returns as $return)
                            <tr>
                                <td>{{ $return->voucher_id }}</td>
                                <td>{{ $return->trader_name }}</td>
                                <td>{{ $return->ref_no }}</td>
                                <td>{{ $return->narration }}</td>
                                <td>{{ $util->num_f($return->debit, true, null) }}</td>
                                <td>{{ $util->num_f($return->credit, true, null) }}</td>
                            </tr>
                            @php
                                $cash_sales_return_total += (float) $return->debit;
                                $grand_total_debit += (float) $return->debit;
                            @endphp
                        @endforeach
                        <tr class="underline">
                            <td colspan="4" class="bold">Sub Total:</td>
                            <td class="bold">{{ $util->num_f($cash_sales_return_total, true, null) }}</td>
                            <td class="bold">{{ $util->num_f(0, true, null) }}</td>
                        </tr>
                    @endif
                @endif
                
                <!-- Grand Total -->
                <tr class="double-underline">
                    <td colspan="3"></td>
                    <td class="bold">Grand Total:</td>
                    <td class="bold" style="border-top: 2px double #000;">{{ $util->num_f($grand_total_debit, true, null) }}</td>
                    <td class="bold" style="border-top: 2px double #000;">{{ $util->num_f($grand_total_credit, true, null) }}</td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
                Print Date & Time: {{ date('d/m/Y h:i:s A') }}
            </div>
            <div class="footer-right">
                Page 1 of 1
            </div>
        </div>
    </div>
    
    <script>
        window.onload = function() {
            window.print();
        };
    </script>
</body>
</html>

