<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>{{ __('businessmanagement::lang.date_wise_sales_with_profit') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            padding-right: 10px;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: left;
            padding-left: 10px;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 20%;
            text-align: right;
            font-size: 8pt;
            padding-left: 10px;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #0066cc;
            text-decoration: underline;
        }
        
        .date-range {
            font-size: 10pt;
            text-align: center;
            margin-bottom: 10px;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody {
            display: table-row-group;
        }
        
        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 6px 8px;
            text-align: left;
            font-size: 9pt;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: 600;
            text-align: center;
        }
        
        td {
            text-align: left;
        }
        
        .text-right {
            text-align: right !important;
        }
        
        .text-center {
            text-align: center !important;
        }
        
        .grand-total {
            font-weight: bold;
            background-color: #f0f0f0;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ asset('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? '' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}</div>
                @if(!empty($business->address_line_2))
                    <div class="company-address">{{ $business->address_line_2 }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        {{ trim(($business->city ?? '') . ', ' . ($business->state ?? '') . ', ' . ($business->country ?? ''), ', ') }}
                    </div>
                @endif
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <div>{{ $business->mobile }}</div>
                    @endif
                    @if(!empty($business->alternate_number))
                        <div>{{ $business->alternate_number }}</div>
                    @endif
                    @if(!empty($business->email))
                        <div>{{ $business->email }}</div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">{{ __('businessmanagement::lang.date_wise_sales_with_profit') }}</div>
        
        <!-- Date Range -->
        <div class="date-range">
            @php
                $start_date_formatted = !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y');
                $end_date_formatted = !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y');
            @endphp
            {{ $start_date_formatted }} {{ __('businessmanagement::lang.to') }} {{ $end_date_formatted }}
        </div>
        
        <!-- Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 15%;">{{ __('businessmanagement::lang.date') }}</th>
                    <th style="width: 17%; text-align: right;">{{ __('businessmanagement::lang.sales_amount') }}</th>
                    <th style="width: 17%; text-align: right;">{{ __('businessmanagement::lang.cost_amount') }}</th>
                    <th style="width: 17%; text-align: right;">{{ __('businessmanagement::lang.expenses') }}</th>
                    <th style="width: 17%; text-align: right;">{{ __('businessmanagement::lang.income') }}</th>
                    <th style="width: 17%; text-align: right;">{{ __('businessmanagement::lang.profit') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($date_wise_data as $data)
                    <tr>
                        <td class="text-center">{{ \Carbon\Carbon::parse($data['date'])->format('d/m/Y') }}</td>
                        <td class="text-right">{{ $util->num_f($data['sales_amount'], true, null) }}</td>
                        <td class="text-right">{{ $util->num_f($data['cost_amount'], true, null) }}</td>
                        <td class="text-right">{{ $util->num_f($data['expenses'], true, null) }}</td>
                        <td class="text-right">{{ $util->num_f($data['income'], true, null) }}</td>
                        <td class="text-right">{{ $util->num_f($data['profit'], true, null) }}</td>
                    </tr>
                @endforeach
                <tr class="grand-total">
                    <td>{{ __('businessmanagement::lang.grand_total') }}:</td>
                    <td class="text-right">{{ $util->num_f($grand_total_sales, true, null) }}</td>
                    <td class="text-right">{{ $util->num_f($grand_total_cost, true, null) }}</td>
                    <td class="text-right">{{ $util->num_f($grand_total_expenses, true, null) }}</td>
                    <td class="text-right">{{ $util->num_f($grand_total_income, true, null) }}</td>
                    <td class="text-right">{{ $util->num_f($grand_total_profit, true, null) }}</td>
                </tr>
            </tbody>
        </table>
    </div>
</body>
</html>

