<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Date Wise Sales Received</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #2c3e50;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 600;
            margin-bottom: 3px;
            color: #1a1a1a;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #4a4a4a;
            text-align: left;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #4a4a4a;
            line-height: 1.4;
            text-align: left;
        }
        
        .company-contact strong {
            font-weight: 700;
        }
        
        .report-title {
            font-size: 13pt;
            font-weight: 700;
            text-align: center;
            margin: 10px 0 5px 0;
            text-transform: uppercase;
            color: #1a1a1a;
            text-decoration: underline;
        }
        
        .report-date {
            font-size: 9pt;
            text-align: center;
            margin-bottom: 8px;
            color: #1a1a1a;
            font-weight: 700;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: #f5f5f5;
        }
        
        table th:first-child {
            text-align: left;
        }
        
        table th:not(:first-child) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px;
            font-size: 8pt;
        }
        
        table td:first-child {
            text-align: left;
            font-weight: 700;
        }
        
        table td:not(:first-child) {
            text-align: right;
        }
        
        .grand-total-row {
            background-color: #e9ecef;
            font-weight: 700;
        }
        
        .grand-total-row td:not(:first-child) {
            border-top: 2px double #000;
        }
        
        /* Footer */
        .footer {
            margin-top: 15px;
            font-size: 8pt;
            color: #4a4a4a;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            text-align: left;
        }
        
        .footer-right {
            display: table-cell;
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ public_path('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}{{ !empty($business->address_line_1) && !empty($business->city) ? ', ' : '' }}{{ $business->city ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city)) && !empty($business->state) ? ', ' : '' }}{{ $business->state ?? '' }}{{ (!empty($business->address_line_1) || !empty($business->city) || !empty($business->state)) && !empty($business->country) ? ', ' : '' }}{{ $business->country ?? '' }}</div>
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <strong>Phone:</strong> {{ $business->mobile }}
                    @endif
                    @if(!empty($business->email))
                        <br><strong>Email:</strong> {{ $business->email }}
                    @endif
                    @if(!empty($business->fax))
                        <br><strong>Fax:</strong> {{ $business->fax }}
                    @endif
                    @if(!empty($business->website))
                        <br>{{ $business->website }}
                    @endif
                </div>
            </div>
            <div class="header-right">
                <!-- Empty for alignment -->
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">Date Wise Sales Received</div>
        <div class="report-date">{{ $util->format_date($start_date, false) }} To {{ $util->format_date($end_date, false) }}</div>
        
        <!-- Main Table -->
        <table>
            <thead>
                <tr>
                    <th>Name</th>
                    <th>Opening Due</th>
                    <th>Sales</th>
                    <th>Discount</th>
                    <th>Received</th>
                    <th>Sales Due</th>
                    <th>Current Due</th>
                </tr>
            </thead>
            <tbody>
                @foreach($categories as $name => $data)
                    <tr>
                        <td>{{ $name }}</td>
                        <td>{{ $util->num_f($data['opening_due'], true, null) }}</td>
                        <td>{{ $util->num_f($data['sales'], true, null) }}</td>
                        <td>{{ $util->num_f($data['discount'], true, null) }}</td>
                        <td>{{ $util->num_f($data['received'], true, null) }}</td>
                        <td>{{ $util->num_f($data['sales_due'], true, null) }}</td>
                        <td>{{ $util->num_f($data['current_due'], true, null) }}</td>
                    </tr>
                @endforeach
            </tbody>
            <tfoot>
                <tr class="grand-total-row">
                    <td>Grand Total</td>
                    <td>{{ $util->num_f($grand_totals['opening_due'], true, null) }}</td>
                    <td>{{ $util->num_f($grand_totals['sales'], true, null) }}</td>
                    <td>{{ $util->num_f($grand_totals['discount'], true, null) }}</td>
                    <td>{{ $util->num_f($grand_totals['received'], true, null) }}</td>
                    <td>{{ $util->num_f($grand_totals['sales_due'], true, null) }}</td>
                    <td>{{ $util->num_f($grand_totals['current_due'], true, null) }}</td>
                </tr>
            </tfoot>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
                Print Date & Time: {{ date('d/m/Y h:i:sA') }}
            </div>
            <div class="footer-right">
                Page <span class="page-number"></span>
            </div>
        </div>
    </div>
    
    <script type="text/php">
        if (isset($pdf)) {
            $text = "Page {PAGE_NUM} of {PAGE_COUNT}";
            $size = 8;
            $font = $fontMetrics->getFont("Arial");
            $width = $fontMetrics->get_text_width($text, $font, $size) / 2;
            $x = ($pdf->get_width() - $width) / 2;
            $y = $pdf->get_height() - 30;
            $pdf->page_text($x, $y, $text, $font, $size);
        }
    </script>
</body>
</html>

