<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>{{ __('businessmanagement::lang.date_wise_received') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            padding-right: 10px;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 70%;
            text-align: left;
            padding-left: 10px;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 15%;
            text-align: right;
            font-size: 8pt;
            padding-left: 10px;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 16pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .company-address {
            font-size: 9pt;
            margin-bottom: 2px;
            color: #000;
        }
        
        .company-contact {
            font-size: 8pt;
            color: #000;
            line-height: 1.4;
        }
        
        .report-title {
            font-size: 14pt;
            font-weight: 700;
            text-align: center;
            margin: 12px 0 5px 0;
            text-transform: uppercase;
            color: #000;
            text-decoration: underline;
        }
        
        .date-range {
            font-size: 10pt;
            text-align: center;
            margin-bottom: 10px;
            color: #000;
        }
        
        .section-heading {
            font-size: 10pt;
            font-weight: 600;
            margin: 10px 0 5px 0;
            color: #000;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
            page-break-inside: auto;
        }
        
        thead {
            display: table-header-group;
        }
        
        tbody {
            display: table-row-group;
        }
        
        tr {
            page-break-inside: avoid;
            page-break-after: auto;
        }
        
        th, td {
            border: 1px solid #000;
            padding: 4px 6px;
            text-align: left;
            font-size: 8pt;
        }
        
        th {
            background-color: #f0f0f0;
            font-weight: 600;
            text-align: center;
        }
        
        td {
            text-align: left;
        }
        
        .text-right {
            text-align: right !important;
        }
        
        .text-center {
            text-align: center !important;
        }
        
        /* Footer */
        .footer {
            margin-top: 15px;
            padding-top: 5px;
            border-top: 1px solid #ccc;
            font-size: 8pt;
            display: table;
            width: 100%;
        }
        
        .footer-left {
            display: table-cell;
            text-align: left;
            width: 50%;
        }
        
        .footer-right {
            display: table-cell;
            text-align: right;
            width: 50%;
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($business->logo))
                    <img src="{{ asset('uploads/business_logos/' . $business->logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? '' }}</div>
                <div class="company-address">{{ $business->address_line_1 ?? '' }}</div>
                @if(!empty($business->address_line_2))
                    <div class="company-address">{{ $business->address_line_2 }}</div>
                @endif
                @if(!empty($business->city) || !empty($business->state) || !empty($business->country))
                    <div class="company-address">
                        {{ trim(($business->city ?? '') . ', ' . ($business->state ?? '') . ', ' . ($business->country ?? ''), ', ') }}
                    </div>
                @endif
            </div>
            <div class="header-right">
                <div class="company-contact">
                    @if(!empty($business->mobile))
                        <div>{{ $business->mobile }}</div>
                    @endif
                    @if(!empty($business->alternate_number))
                        <div>{{ $business->alternate_number }}</div>
                    @endif
                    @if(!empty($business->email))
                        <div>{{ $business->email }}</div>
                    @endif
                </div>
            </div>
        </div>
        
        <!-- Report Title -->
        <div class="report-title">{{ __('businessmanagement::lang.date_wise_received') }}</div>
        
        <!-- Date Range -->
        <div class="date-range">
            @php
                $start_date_formatted = !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : date('d/m/Y');
                $end_date_formatted = !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : date('d/m/Y');
            @endphp
            {{ $start_date_formatted }} {{ __('businessmanagement::lang.to') }} {{ $end_date_formatted }}
        </div>
        
        <!-- Section Heading -->
        <div class="section-heading">{{ __('businessmanagement::lang.customer_supplier_receive') }}</div>
        <div class="section-heading" style="margin-top: 0;">{{ __('businessmanagement::lang.cash') }}</div>
        
        <!-- Table -->
        <table>
            <thead>
                <tr>
                    <th style="width: 4%;">{{ __('businessmanagement::lang.sl') }}</th>
                    <th style="width: 8%;">{{ __('businessmanagement::lang.date') }}</th>
                    <th style="width: 12%;">{{ __('businessmanagement::lang.receive_id') }}</th>
                    <th style="width: 15%;">{{ __('businessmanagement::lang.received_from') }}</th>
                    <th style="width: 12%;">{{ __('businessmanagement::lang.narration') }}</th>
                    <th style="width: 8%;">{{ __('businessmanagement::lang.ref_no') }}</th>
                    <th style="width: 10%;">{{ __('businessmanagement::lang.prepared_by') }}</th>
                    <th style="width: 8%;">{{ __('businessmanagement::lang.cheque_no') }}</th>
                    <th style="width: 8%;">{{ __('businessmanagement::lang.chq_date') }}</th>
                    <th style="width: 7%; text-align: right;">{{ __('businessmanagement::lang.amount') }}</th>
                </tr>
            </thead>
            <tbody>
                @php
                    $sl = 1;
                @endphp
                @foreach($all_receipts as $receipt)
                    <tr>
                        <td class="text-center">{{ $sl++ }}</td>
                        <td class="text-center">{{ !empty($receipt->date) ? \Carbon\Carbon::parse($receipt->date)->format('d/m/Y') : '' }}</td>
                        <td>{{ $receipt->receive_id ?? '' }}</td>
                        <td>{{ $receipt->received_from ?? '' }}</td>
                        <td>{{ $receipt->narration ?? '' }}</td>
                        <td>{{ $receipt->ref_no ?? '' }}</td>
                        <td>{{ $receipt->prepared_by ?? '' }}</td>
                        <td>{{ $receipt->cheque_no ?? '' }}</td>
                        <td>{{ !empty($receipt->cheque_date) ? \Carbon\Carbon::parse($receipt->cheque_date)->format('d/m/Y') : '' }}</td>
                        <td class="text-right">{{ $util->num_f($receipt->amount, true, null) }}</td>
                    </tr>
                @endforeach
                <tr style="font-weight: bold; background-color: #f0f0f0;">
                    <td colspan="9" style="text-align: right; padding-right: 10px;">{{ __('businessmanagement::lang.grand_total') }}:</td>
                    <td class="text-right" style="font-weight: bold;">{{ $util->num_f($total_amount, true, null) }}</td>
                </tr>
            </tbody>
        </table>
        
        <!-- Footer -->
        <div class="footer">
            <div class="footer-left">
                Print Date & Time : {{ date('d/m/Y h:i:sA') }}
            </div>
            <div class="footer-right">
                Page <span class="page-number"></span>
            </div>
        </div>
    </div>
    
    <script type="text/javascript">
        // Update page numbers
        window.onload = function() {
            var totalPages = Math.ceil(document.querySelectorAll('tbody tr').length / 25); // Approximate rows per page
            if (totalPages > 1) {
                var pageElements = document.querySelectorAll('.page-number');
                pageElements.forEach(function(el, index) {
                    el.textContent = (index + 1) + ' of ' + totalPages;
                });
            } else {
                document.querySelectorAll('.page-number').forEach(function(el) {
                    el.textContent = '1 of 1';
                });
            }
        };
    </script>
</body>
</html>

