<!DOCTYPE html>
<html>
<head>
    <title>{{ __('businessmanagement::lang.date_wise_net_profit') }}</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <style type="text/css">
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .header h2 {
            margin: 0;
            font-size: 20px;
            font-weight: bold;
        }
        .header p {
            margin: 5px 0;
            font-size: 14px;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        table th, table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        table th {
            background-color: #f5f5f5;
            font-weight: bold;
        }
        .text-right {
            text-align: right;
        }
        .text-center {
            text-align: center;
        }
        .font-bold {
            font-weight: bold;
        }
        .bg-light {
            background-color: #f5f5f5;
        }
        .bg-success {
            background-color: #e8f5e9;
        }
        .bg-warning {
            background-color: #fff3cd;
        }
        .border-top-bold {
            border-top: 3px solid #ffc107;
        }
        .info-box {
            margin-top: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-left: 4px solid #007bff;
        }
    </style>
</head>
<body>
    <div class="header">
        <h2>{{ $business->name ?? '' }}</h2>
        <p>{{ __('businessmanagement::lang.date_wise_net_profit') }}</p>
        <p>
            {{ __('businessmanagement::lang.from') }}: {{ !empty($start_date) ? \Carbon\Carbon::parse($start_date)->format('d/m/Y') : '' }} 
            {{ __('businessmanagement::lang.to') }}: {{ !empty($end_date) ? \Carbon\Carbon::parse($end_date)->format('d/m/Y') : '' }}
        </p>
        @if(!empty($location_id))
            <p>{{ __('purchase.business_location') }}: {{ \App\BusinessLocation::find($location_id)->name ?? '' }}</p>
        @endif
    </div>

    <div class="content">
        @if(isset($date_wise_data) && count($date_wise_data) > 0)
            <table>
                <thead>
                    <tr>
                        <th style="background-color: #f5f5f5; font-weight: bold;">{{ __('businessmanagement::lang.date') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.total_sell_amount') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.sell_discount') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.cogs') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.gross_profit') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.expense') }}</th>
                        <th style="background-color: #f5f5f5; font-weight: bold; text-align: right;">{{ __('businessmanagement::lang.net_profit') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($date_wise_data as $data)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($data['date'])->format('d-m-Y') }}</td>
                            <td style="text-align: right;">{{ $util->num_f($data['total_sales'], true, null) }}</td>
                            <td style="text-align: right;">{{ $util->num_f($data['sales_discount'], true, null) }}</td>
                            <td style="text-align: right;">{{ $util->num_f($data['cogs'], true, null) }}</td>
                            <td style="text-align: right;">{{ $util->num_f($data['gross_profit'], true, null) }}</td>
                            <td style="text-align: right;">{{ $util->num_f($data['expenses'], true, null) }}</td>
                            <td style="text-align: right; font-weight: bold;">{{ $util->num_f($data['net_profit'], true, null) }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr style="background-color: #f5f5f5; font-weight: bold; border-top: 2px solid #333;">
                        <td style="font-weight: bold;">{{ __('businessmanagement::lang.total') }}</td>
                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_sales, true, null) }}</td>
                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_discount, true, null) }}</td>
                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_cogs, true, null) }}</td>
                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_gross_profit, true, null) }}</td>
                        <td style="text-align: right; font-weight: bold;">{{ $util->num_f($grand_total_expenses, true, null) }}</td>
                        <td style="text-align: right; font-weight: bold; font-size: 16px;">{{ $util->num_f($grand_total_net_profit, true, null) }}</td>
                    </tr>
                </tfoot>
            </table>
        @else
            <p>{{ __('businessmanagement::lang.no_data_found') }}</p>
        @endif
    </div>

    <div style="margin-top: 30px; text-align: center; font-size: 10px; color: #666;">
        <p>{{ __('businessmanagement::lang.printed_at') }}: {{ \Carbon\Carbon::now()->format('d/m/Y H:i:s') }}</p>
    </div>
</body>
</html>

