<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">
<head>
    <title>Account Statement - Customer</title>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @page {
            size: A4;
            margin: 1cm 1.5cm;
        }
        
        body {
            font-family: 'Segoe UI', 'Roboto', 'Helvetica Neue', Arial, sans-serif;
            font-size: 9pt;
            line-height: 1.3;
            color: #000;
            background: #fff;
            width: 100%;
        }
        
        .container {
            width: 100%;
            max-width: 100%;
            margin: 0 auto;
        }
        
        /* Header Section */
        .header {
            margin-bottom: 15px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .header-left {
            display: table-cell;
            vertical-align: top;
            width: 15%;
        }
        
        .header-center {
            display: table-cell;
            vertical-align: top;
            width: 60%;
            text-align: center;
            padding-left: 10px;
        }
        
        .header-right {
            display: table-cell;
            vertical-align: top;
            width: 25%;
            text-align: right;
            font-size: 8pt;
        }
        
        .company-logo {
            max-width: 60px;
            max-height: 60px;
        }
        
        .company-name {
            font-size: 18pt;
            font-weight: 700;
            margin-bottom: 3px;
            color: #000;
            text-transform: uppercase;
            letter-spacing: 0.5px;
        }
        
        .document-title {
            font-size: 12pt;
            font-weight: 600;
            margin-top: 5px;
            color: #000;
        }
        
        .report-date {
            font-size: 8pt;
            text-align: right;
            color: #000;
        }
        
        /* Customer Info Section */
        .customer-info {
            margin-bottom: 12px;
            page-break-inside: avoid;
        }
        
        .customer-info table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8pt;
        }
        
        .customer-info td {
            padding: 3px 5px;
            border: none;
            text-align: left;
        }
        
        .customer-info td.label {
            font-weight: 600;
            width: 25%;
        }
        
        /* Balance Summary Section */
        .balance-summary {
            margin-bottom: 12px;
            page-break-inside: avoid;
            display: table;
            width: 100%;
        }
        
        .balance-summary-left {
            display: table-cell;
            vertical-align: top;
            width: 50%;
            padding-right: 10px;
        }
        
        .balance-summary-right {
            display: table-cell;
            vertical-align: top;
            width: 50%;
            padding-left: 10px;
        }
        
        .balance-summary table {
            width: 100%;
            border-collapse: collapse;
            font-size: 8pt;
        }
        
        .balance-summary td {
            padding: 4px 5px;
            border: 1px solid #000;
            text-align: left;
        }
        
        .balance-summary td.label {
            font-weight: 600;
            width: 60%;
        }
        
        .balance-summary td.value {
            text-align: right;
            width: 40%;
        }
        
        /* Table Styles */
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 8px;
            font-size: 8pt;
        }
        
        table thead {
            background-color: transparent;
        }
        
        table th {
            border: 1px solid #000;
            padding: 4px 3px;
            text-align: center;
            font-weight: 700;
            font-size: 8pt;
            background-color: transparent;
        }
        
        table th:nth-child(1),
        table th:nth-child(2),
        table th:nth-child(3),
        table th:nth-child(4) {
            text-align: left;
        }
        
        table th:nth-child(5),
        table th:nth-child(6),
        table th:nth-child(7),
        table th:nth-child(8) {
            text-align: right;
        }
        
        table td {
            border: 1px solid #000;
            padding: 3px 3px;
            text-align: left;
            font-size: 8pt;
        }
        
        table td:nth-child(5),
        table td:nth-child(6),
        table td:nth-child(7),
        table td:nth-child(8) {
            text-align: right;
        }
        
        table tbody tr:nth-child(even) {
            background-color: transparent;
        }
        
        table tfoot {
            font-weight: 700;
        }
        
        table tfoot td {
            background-color: transparent;
            border-top: 2px solid #000;
        }
        
        .text-right {
            text-align: right;
        }
        
        .text-center {
            text-align: center;
        }
        
        .negative {
            color: #000;
        }
        
        .negative::before {
            content: "(";
        }
        
        .negative::after {
            content: ")";
        }
        
        @media print {
            body {
                -webkit-print-color-adjust: exact;
                print-color-adjust: exact;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header -->
        <div class="header">
            <div class="header-left">
                @if(!empty($logo))
                    <img src="{{ asset('uploads/business_logos/' . $logo) }}" alt="Logo" class="company-logo">
                @endif
            </div>
            <div class="header-center">
                <div class="company-name">{{ $business->name ?? 'Business Name' }}</div>
                <div class="document-title">Account Statement - Customer</div>
            </div>
            <div class="header-right">
                <div class="report-date">{{ \Carbon\Carbon::now()->format('d.m.Y H:i:s') }}</div>
            </div>
        </div>
        
        @if(!empty($customer))
            <!-- Customer Information -->
            <div class="customer-info">
                <table>
                    <tr>
                        <td class="label">Customer ID:</td>
                        <td>{{ $customer->contact_id ?? $customer->id }}</td>
                        <td class="label">Company Code:</td>
                        <td>{{ $business->code ?? '-' }}</td>
                    </tr>
                    <tr>
                        <td class="label">Customer Name:</td>
                        <td>{{ $customer->supplier_business_name ?? $customer->name }}</td>
                        <td class="label">Date & Time:</td>
                        <td>{{ \Carbon\Carbon::now()->format('d.m.Y H:i:s') }}</td>
                    </tr>
                    <tr>
                        <td class="label">Contact No:</td>
                        <td>{{ $customer->mobile ?? '-' }}</td>
                        <td class="label">Statement From:</td>
                        <td>{{ $util->format_date($start_date, false) }}</td>
                    </tr>
                    <tr>
                        <td class="label">Address:</td>
                        <td colspan="3">{{ trim(($customer->address_line_1 ?? '') . ' ' . ($customer->address_line_2 ?? '') . ' ' . ($customer->city ?? '') . ' ' . ($customer->state ?? '') . ' ' . ($customer->country ?? '')) }}</td>
                    </tr>
                    <tr>
                        <td class="label">Statement To:</td>
                        <td>{{ $util->format_date($end_date, false) }}</td>
                        <td></td>
                        <td></td>
                    </tr>
                </table>
            </div>
            
            <!-- Balance Summary -->
            <div class="balance-summary">
                <div class="balance-summary-right">
                    <table>
                        <tr>
                            <td class="label">Currency:</td>
                            <td class="value">{{ $business->currency_symbol ?? '' }}</td>
                        </tr>
                        <tr>
                            <td class="label">Previous Balance:</td>
                            <td class="value">{{ $util->num_f($previous_balance, true, null) }}</td>
                        </tr>
                        <tr>
                            <td class="label">Debit / Sales Order:</td>
                            <td class="value">{{ $util->num_f($total_debit, true, null) }}</td>
                        </tr>
                        <tr>
                            <td class="label">Credit / Payment:</td>
                            <td class="value">
                                @if($total_credit > 0)
                                    ({{ $util->num_f($total_credit, true, null) }})
                                @else
                                    {{ $util->num_f($total_credit, true, null) }}
                                @endif
                            </td>
                        </tr>
                        <tr style="background-color: #f0f0f0;">
                            <td class="label"><strong>Total Balance Due:</strong></td>
                            <td class="value">
                                <strong>
                                    @if($running_balance < 0)
                                        ({{ $util->num_f(abs($running_balance), true, null) }})
                                    @else
                                        {{ $util->num_f($running_balance, true, null) }}
                                    @endif
                                </strong>
                            </td>
                        </tr>
                    </table>
                </div>
            </div>
            
            <!-- Transaction Table -->
            @if(count($statement_data) > 0)
                <table>
                    <thead>
                        <tr>
                            <th>Date</th>
                            <th>Transaction Type</th>
                            <th>Reference</th>
                            <th>Description</th>
                            <th>Quantity</th>
                            <th>Rate</th>
                            <th>Debit/Credit</th>
                            <th>Balance</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($statement_data as $item)
                            <tr>
                                <td>{{ $util->format_date($item->date, false) }}</td>
                                <td>{{ $item->transaction_type }}</td>
                                <td>{{ $item->reference }}</td>
                                <td>{{ $item->description }}</td>
                                <td class="text-right">{{ $util->num_f($item->quantity, false, null, true) }}</td>
                                <td class="text-right">{{ $util->num_f($item->rate, true, null) }}</td>
                                <td class="text-right">
                                    @if($item->debit > 0)
                                        {{ $util->num_f($item->debit, true, null) }}
                                    @elseif($item->credit > 0)
                                        {{ $util->num_f($item->credit, true, null) }}-
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="text-right">
                                    @if($item->balance < 0)
                                        ({{ $util->num_f(abs($item->balance), true, null) }})
                                    @else
                                        {{ $util->num_f($item->balance, true, null) }}
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                    <tfoot>
                        <tr>
                            <td colspan="6" class="text-right"><strong>Total Amount:</strong></td>
                            <td class="text-right">
                                <strong>{{ $util->num_f($total_debit, true, null) }} / {{ $util->num_f($total_credit, true, null) }}-</strong>
                            </td>
                            <td></td>
                        </tr>
                    </tfoot>
                </table>
            @else
                <p style="text-align: center; margin-top: 20px;">No transactions found for the selected period.</p>
            @endif
        @else
            <p style="text-align: center; margin-top: 20px;">No customer selected.</p>
        @endif
    </div>
</body>
</html>

