<?php

namespace Modules\AgeingReport\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response;
use Illuminate\Routing\Controller;
use App\Utils\ModuleUtil;
use Menu;
use Nwidart\Menus\MenuBuilder;
use Illuminate\Contracts\Config\Repository;



class DataController extends Controller
{    
    public function superadmin_package()
    {
        return [
            [
                'name' => 'ageingreport_module',
                'label' => __('ageingeeport::app.ageingreport'),
                'default' => false
            ]
        ];
    }

    /**
      * Defines user permissions for the module.
      * @return array
      */
    public function user_permissions()
    {
        return [
            [
                'value' => 'ageingreport.view',
                'label' => __('ageingreport::app.view'),
                'default' => false
            ],
      
        ];
    }

    /**
    * Function to add module taxonomies
    * @return array
    */
    
    public function addTaxonomies()
    {
        $business_id = request()->session()->get('user.business_id');

        $module_util = new ModuleUtil();
        if (!(auth()->user()->can('superadmin') || $module_util->hasThePermissionInSubscription($business_id, 'ageingreport_module'))) {
            return ['wallet' => []];
        }
        
        return [
            'wallet' => [
                  ]
        ];
    }

    /**
     * Adds Report menus
     * @return null
     */

 public function modifyAdminMenu()
    {
        $business_id = session()->get('user.business_id');
        $module_util = new ModuleUtil();
        $is_ageingreport_enabled = (boolean)$module_util->hasThePermissionInSubscription($business_id, 'ageingreport_module');

        if ($is_ageingreport_enabled && (auth()->user()->can('superadmin') || auth()->user()->can('ageingreport.view'))) {
            Menu::modify(
                'admin-sidebar-menu',
                function ($menu) {
                    $menu->url(action([\Modules\AgeingReport\Http\Controllers\AgeingReportController::class, 'getSuppliersAgeing']), __('ageingreport::app.ageingreport'), 
                    ['icon' => '<svg aria-hidden="true" class="tw-size-5 tw-shrink-0" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none" stroke-linecap="round" stroke-linejoin="round">
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <path stroke="none" d="M0 0h24v24H0z" fill="none"></path>
                    <path d="M8 5h-2a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h5.697"></path>
                    <path d="M18 14v4h4"></path>
                    <path d="M18 11v-4a2 2 0 0 0 -2 -2h-2"></path>
                    <path d="M8 3m0 2a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2z"></path>
                    <path d="M18 18m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"></path>
                    <path d="M8 11h4"></path>
                    <path d="M8 15h3"></path>
                  </svg>', 'style' => config('app.env') == 'demo' ? 'background-color: #4A90E2;color:white' : '', 'active' => request()->segment(1) == 'ageingreport'])->order(54);
                }
            );
        }



    }


}