<?php

return [
    // Module
    'advanced_reports_module' => 'Модуль расширенных отчетов',
    'advanced_reports' => 'Расширенные отчеты',
    'manage_advanced_reports' => 'Управление расширенными отчетами',
    'service_staff_not_enabled' => 'Модуль обслуживающего персонала не включен. Пожалуйста, включите модуль обслуживающего персонала в настройках бизнеса для использования отчетов по персоналу.',

    // Permissions
    'view_reports' => 'Просмотр отчетов',
    'export_reports' => 'Экспорт отчетов',

    // Stock Report
    'stock_report' => 'Отчет по запасам',
    'manage_stock_report' => 'Управление отчетом по запасам',
    'current_stock' => 'Текущий запас',
    'stock_value_purchase' => 'Стоимость запасов (закупка)',
    'stock_value_sale' => 'Стоимость запасов (продажа)',
    'potential_profit' => 'Потенциальная прибыль',
    'total_sold' => 'Всего продано',
    'selling_price' => 'Цена продажи',
    'total_products' => 'Всего товаров',
    'total_stock_quantity' => 'Общее количество запасов',
    'show_zero_stock' => 'Показать нулевой запас',
    'out_of_stock' => 'Нет в наличии',
    'low_stock' => 'Низкий запас',
    'total_stock_value' => 'Общая стоимость запасов',
    'product_info' => 'Информация о товаре',
    'active' => 'Активный',
    'inactive' => 'Неактивный',
    'lot_number' => 'Номер партии',

    // Sales Report
    'sales_report' => 'Отчет по продажам',
    'manage_sales_report' => 'Управление отчетом по продажам',
    'invoice_no' => 'Номер счета',
    'transaction_date' => 'Дата транзакции',
    'customer_name' => 'Имя клиента',
    'payment_status' => 'Статус оплаты',
    'total_before_tax' => 'Сумма до налога',
    'tax_amount' => 'Сумма налога',
    'final_total' => 'Итоговая сумма',
    'total_paid' => 'Всего оплачено',
    'balance_due' => 'Остаток к оплате',
    'total_sales' => 'Общие продажи',
    'average_sale' => 'Средняя продажа',
    'total_due' => 'Общий долг',

    // Product Report
    'product_report' => 'Отчет по продажам товаров',

    // Pricing Optimization
    'pricing_optimization' => 'Оптимизация цен',
    'pricing_analytics_dashboard' => 'Панель аналитики цен',
    'price_elasticity_analysis' => 'Анализ эластичности цен',
    'competitor_price_analysis' => 'Анализ цен конкурентов',
    'discount_impact_analysis' => 'Анализ влияния скидок',
    'dynamic_pricing_suggestions' => 'Динамические предложения по ценам',
    'revenue_optimization' => 'Оптимизация дохода',
    'average_margin' => 'Средняя маржа',
    'average_selling_price' => 'Средняя цена продажи',
    'current_price' => 'Текущая цена',
    'cost_price' => 'Себестоимость',
    'suggested_price' => 'Рекомендуемая цена',
    'quantity_sold' => 'Количество проданных',
    'velocity' => 'Скорость',
    'elasticity_type' => 'Тип эластичности',
    'recommendation' => 'Рекомендация',
    'our_price' => 'Наша цена',
    'market_average' => 'Рыночная средняя',
    'market_position' => 'Позиция на рынке',
    'price_difference' => 'Разница в цене',
    'competitiveness' => 'Конкурентоспособность',
    'discount_frequency' => 'Частота скидок',
    'avg_discount_percent' => 'Средний % скидки',
    'discounted_sales' => 'Продажи со скидкой',
    'regular_sales' => 'Обычные продажи',
    'effectiveness_score' => 'Показатель эффективности',
    'price_change' => 'Изменение цены',
    'confidence' => 'Уверенность',
    'reasoning' => 'Обоснование',
    'revenue_impact' => 'Влияние на доход',
    'products' => 'Товары',
    'optimization_score' => 'Показатель оптимизации',

    // ABC Analysis
    'abc_analysis' => 'ABC анализ',
    'abc_analysis_description' => 'Классификация товаров по стоимости и оптимизация распределения ресурсов',
    'abc_analysis_dashboard' => 'Панель ABC анализа',
    'analysis_type' => 'Тип анализа',
    'inventory_value' => 'Стоимость запасов',
    'sales_revenue' => 'Выручка от продаж',
    'hybrid_analysis' => 'Гибридный анализ',
    'analyze' => 'Анализировать',
    'a_grade_items' => 'Товары класса A',
    'b_grade_items' => 'Товары класса B',
    'c_grade_items' => 'Товары класса C',
    'total_analysis_value' => 'Общая стоимость анализа',
    'abc_distribution_chart' => 'Диаграмма распределения ABC',
    'pareto_analysis' => 'Анализ Парето',
    'revenue_contribution_analysis' => 'Анализ вклада в доход',
    'abc_grade' => 'Класс ABC',
    'item_count' => 'Количество элементов',
    'turnover_ratio' => 'Коэффициент оборачиваемости',
    'focus_strategy' => 'Стратегия фокуса',
    'management_approach' => 'Подход к управлению',
    'resource_allocation_recommendations' => 'Рекомендации по распределению ресурсов',
    'detailed_product_classification' => 'Детальная классификация товаров',
    'rank' => 'Ранг',
    'variant_title' => 'Название варианта',
    'variant_sku' => 'Артикул варианта',
    'ending_quantity' => 'Конечное количество',
    'total_cost_value' => 'Общая стоимость закупки',
    'total_selling_value' => 'Общая стоимость продажи',
    'cumulative_percent' => 'Накопительный %',
    'manage_product_report' => 'Управление отчетом по продажам товаров',
    'total_quantity_sold' => 'Общее количество проданных',
    'total_amount_sold' => 'Общая сумма продаж',
    'profit_margin' => 'Маржа прибыли',
    'top_selling_products' => 'Топ продаваемых товаров',
    'slow_moving_products' => 'Медленно продаваемые товары',

    // Price List
    'price_list' => 'Прайс-лист',
    'manage_price_list' => 'Управление прайс-листом',
    'purchase_price' => 'Цена закупки',
    'margin_percentage' => 'Маржа %',
    'update_price' => 'Обновить цену',
    'bulk_update_prices' => 'Массовое обновление цен',

    // Common
    'filters' => 'Фильтры',
    'date_range' => 'Диапазон дат',
    'location' => 'Местоположение',
    'category' => 'Категория',
    'customer' => 'Клиент',
    'from_date' => 'Дата начала',
    'to_date' => 'Дата окончания',
    'apply_filter' => 'Применить фильтр',
    'clear_filter' => 'Очистить фильтр',
    'export' => 'Экспорт',
    'export_to_excel' => 'Экспорт в Excel',
    'export_to_pdf' => 'Экспорт в PDF',
    'export_to_csv' => 'Экспорт в CSV',
    'print' => 'Печать',
    'refresh' => 'Обновить',
    'search' => 'Поиск',
    'no_data_found' => 'Данные не найдены',
    'loading' => 'Загрузка...',

    // Summary
    'summary' => 'Итого',
    'grand_total' => 'Общий итог',
    'totals' => 'Итоги',
    'count' => 'Количество',

    // Messages
    'report_generated_successfully' => 'Отчет успешно создан',
    'export_completed_successfully' => 'Экспорт успешно завершен',
    'no_records_found' => 'Записи не найдены для выбранных критериев',
    'please_select_date_range' => 'Пожалуйста, выберите диапазон дат',
    'invalid_date_range' => 'Выбран недопустимый диапазон дат',
    'export_in_progress' => 'Выполняется экспорт, пожалуйста, подождите...',
    'max_export_limit_exceeded' => 'Превышен максимальный лимит экспорта. Пожалуйста, уточните фильтры.',

    // Errors
    'error_generating_report' => 'Ошибка при создании отчета',
    'error_exporting_data' => 'Ошибка при экспорте данных',
    'permission_denied' => 'Доступ запрещен',
    'invalid_request' => 'Недопустимый запрос',

    // Installation
    'install_success' => 'Модуль расширенных отчетов успешно установлен',
    'update_success' => 'Модуль расширенных отчетов успешно обновлен',
    'uninstall_success' => 'Модуль расширенных отчетов успешно удален',

    // Charts
    'sales_trend' => 'Тренд продаж',
    'top_products' => 'Топ товаров',
    'sales_by_location' => 'Продажи по местоположению',
    'sales_by_category' => 'Продажи по категориям',
    'profit_analysis' => 'Анализ прибыли',

    // Advanced Features
    'schedule_report' => 'Запланировать отчет',
    'email_report' => 'Отправить отчет по email',
    'save_filter' => 'Сохранить фильтр',
    'load_saved_filter' => 'Загрузить сохраненный фильтр',
    'custom_columns' => 'Пользовательские столбцы',
    'group_by' => 'Группировать по',
    'sort_by' => 'Сортировать по',
    'chart_view' => 'Вид диаграммы',
    'table_view' => 'Табличный вид',

    // Time Periods
    'today' => 'Сегодня',
    'yesterday' => 'Вчера',
    'this_week' => 'Эта неделя',
    'last_week' => 'Прошлая неделя',
    'this_month' => 'Этот месяц',
    'last_month' => 'Прошлый месяц',
    'this_quarter' => 'Этот квартал',
    'last_quarter' => 'Прошлый квартал',
    'this_year' => 'Этот год',
    'last_year' => 'Прошлый год',
    'last_30_days' => 'Последние 30 дней',
    'custom_range' => 'Пользовательский диапазон',

    'applying' => 'Применение',
    'apply_filters' => 'Применить фильтры',

    // Dashboard
    'dashboard' => 'Панель',
    'key_metrics' => 'Ключевые метрики',
    'recent_reports' => 'Последние отчеты',
    'quick_actions' => 'Быстрые действия',
    'generate_report' => 'Создать отчет',
    'view_all_reports' => 'Просмотреть все отчеты',
    'report_center' => 'Центр отчетов',

    'all_categories' => 'Все категории',
    'filter' => 'Фильтр',

    // Sales Report entries
    'sales_details' => 'Детали продаж',
    'total_transactions' => 'Всего транзакций',
    'total_customers' => 'Всего клиентов',
    'customers' => 'Клиенты',
    'product' => 'Товар',
    'total_customers_count' => 'Общее количество клиентов',
    'total_products_count' => 'Общее количество товаров',
    'total_sales_amount' => 'Общая сумма продаж',
    'total_tax_amount' => 'Общая сумма налога',
    'total_discount' => 'Общая скидка',
    'paid_transactions' => 'Оплаченная сумма',
    'paid_transactions_count' => 'Количество оплаченных транзакций',
    'total_paid_amount' => 'Общая оплаченная сумма',
    'due_transactions' => 'Сумма задолженности',
    'due_transactions_count' => 'Количество задолженностей',
    'total_due_amount' => 'Общая сумма задолженности',
    'invoice' => 'Счет',
    'invoices' => 'Счета',
    'partial_transactions' => 'Частичные транзакции',
    'paid_amount' => 'Оплаченная сумма',
    'due_amount' => 'Сумма задолженности',
    'transaction_info' => 'Информация о транзакции',
    'created_by' => 'Создано',
    'view_full_invoice' => 'Просмотреть полный счет',

    // Additional entries that might be useful
    'sales_summary' => 'Сводка продаж',
    'payment_summary' => 'Сводка платежей',
    'customer_info' => 'Информация о клиенте',
    'sales_performance' => 'Показатели продаж',
    'daily_sales' => 'Ежедневные продажи',
    'monthly_sales' => 'Ежемесячные продажи',
    'yearly_sales' => 'Годовые продажи',
    'top_customers' => 'Топ клиентов',
    'sales_by_payment_method' => 'Продажи по способам оплаты',
    'average_transaction_value' => 'Средняя стоимость транзакции',
    'total_transactions_today' => 'Всего транзакций сегодня',
    'sales_growth' => 'Рост продаж',
    'revenue_analysis' => 'Анализ дохода',

    // Filter related
    'filter_by_date' => 'Фильтр по дате',
    'filter_by_customer' => 'Фильтр по клиенту',
    'filter_by_location' => 'Фильтр по местоположению',
    'filter_by_payment_status' => 'Фильтр по статусу оплаты',
    'filter_by_payment_method' => 'Фильтр по способу оплаты',
    'select_date_range' => 'Выберите диапазон дат',
    'all_customers' => 'Все клиенты',
    'all_locations' => 'Все местоположения',
    'all_payment_methods' => 'Все способы оплаты',
    'all_statuses' => 'Все статусы',

    // Export related
    'export_sales_report' => 'Экспорт отчета по продажам',
    'sales_report_exported' => 'Отчет по продажам успешно экспортирован',
    'export_failed' => 'Ошибка экспорта. Пожалуйста, попробуйте снова.',

    // Status messages
    'no_sales_found' => 'Продажи не найдены для выбранных критериев',
    'loading_sales_data' => 'Загрузка данных о продажах...',
    'sales_data_loaded' => 'Данные о продажах успешно загружены',
    'error_loading_sales' => 'Ошибка загрузки данных о продажах',

    // Validation messages
    'date_range_too_large' => 'Диапазон дат слишком большой. Пожалуйста, выберите меньший диапазон.',
    'no_data_available' => 'Нет данных для выбранных фильтров',

    // Performance metrics
    'growth_rate' => 'Темп роста',
    'conversion_rate' => 'Конверсия',
    'repeat_customers' => 'Повторные клиенты',
    'new_customers' => 'Новые клиенты',
    'average_order_value' => 'Средняя стоимость заказа',
    'total_orders' => 'Всего заказов',
    'orders_per_customer' => 'Заказов на клиента',

    // Additional useful phrases
    'view_details' => 'Просмотреть детали',
    'hide_details' => 'Скрыть детали',
    'expand_all' => 'Развернуть все',
    'collapse_all' => 'Свернуть все',
    'refresh_data' => 'Обновить данные',
    'last_updated' => 'Последнее обновление',
    'auto_refresh' => 'Автообновление',
    'manual_refresh' => 'Ручное обновление',
    'data_as_of' => 'Данные на',
    'real_time_data' => 'Данные в реальном времени',

    // Chart/Graph related
    'bar_chart' => 'Столбчатая диаграмма',
    'line_chart' => 'Линейная диаграмма',
    'pie_chart' => 'Круговая диаграмма',
    'show_chart' => 'Показать диаграмму',
    'hide_chart' => 'Скрыть диаграмму',

    // Comparison related
    'compare_periods' => 'Сравнить периоды',
    'previous_period' => 'Предыдущий период',
    'same_period_last_year' => 'Тот же период прошлого года',
    'percentage_change' => 'Процентное изменение',
    'absolute_change' => 'Абсолютное изменение',
    'trend_analysis' => 'Анализ тренда',

    // Due Collections Analysis
    'due_collections_analysis' => 'Анализ сбора задолженностей',
    'collected_today' => 'Собрано сегодня',
    'pending_due_today' => 'Ожидающие оплаты сегодня',
    'overdue_amounts' => 'Просроченные суммы',
    'due_payments_received' => 'Получено платежей по задолженности сегодня',
    'todays_unpaid_sales' => 'Неоплаченные продажи сегодня',
    'previous_days_unpaid' => 'Неоплаченные за предыдущие дни',
    'cash_collected_today' => 'Собрано наличных сегодня',
    'due_collection_cash' => 'Наличные по задолженности',
    'total_due_collected' => 'Всего собрано задолженности',
    'total_pending_due' => 'Всего ожидающих задолженностей',
    'total_overdue' => 'Всего просроченных',
    'due_collection_summary' => 'Сводка сбора задолженности',
    'payment_collection_status' => 'Статус сбора платежей',
    'outstanding_receivables' => 'Невыполненная дебиторская задолженность',
    'receivables_aging' => 'Старение дебиторской задолженности',
    'collection_efficiency' => 'Эффективность сбора',
    'overdue_analysis' => 'Анализ просрочек',
    'aging_report' => 'Отчет о старении',
    'collection_report' => 'Отчет о сборах',
    'cash_flow_analysis' => 'Анализ денежных потоков',
    'payment_trends' => 'Тренды платежей',
    'due_follow_up' => 'Отслеживание задолженностей',
    'collection_alerts' => 'Уведомления о сборах',
    'payment_reminders' => 'Напоминания о платежах',
    'credit_management' => 'Управление кредитами',
    'customer_payment_history' => 'История платежей клиента',
    'payment_performance' => 'Показатели платежей',

    // sales_detail_report
    'sales_detail_report' => 'Детальный отчет по продажам',
    'gst_sales_report' => 'Отчет по продажам GST',
    'gst_purchase_report' => 'Отчет по закупкам GST',
    'operations_summary_report' => 'Сводный отчет по операциям',
    'daily_summary_report' => 'Ежедневный сводный отчет',
    'daily_report' => 'Ежедневный отчет',
    'manage_gst_sales_report' => 'Управление отчетом по продажам GST',
    'total_tax' => 'Общий налог',
    'taxable_amount' => 'Налогооблагаемая сумма',
    'avg_tax_rate' => 'Средняя налоговая ставка',
    'taxable_value' => 'Налогооблагаемая стоимость',
    'today_sales' => 'Продажи сегодня',
    'today_purchases' => 'Закупки сегодня',
    'today_expenses' => 'Расходы сегодня',
    'net_profit' => 'Чистая прибыль',
    'cash_in_hand' => 'Наличные в кассе',
    'purchase_summary' => 'Сводка по закупкам',
    'expense_summary' => 'Сводка по расходам',
    'payment_methods_summary' => 'Сводка по способам оплаты',
    'payment_method' => 'Способ оплаты',
    'transaction_count' => 'Количество транзакций',
    'total_amount' => 'Общая сумма',
    'manage_daily_summary' => 'Управление ежедневной сводкой',
    'total_purchases' => 'Всего закупок',
    'total_expenses' => 'Всего расходов',
    'avg_daily_sales' => 'Средние ежедневные продажи',
    'profitable_days' => 'Прибыльные дни',
    'day' => 'День',
    'sales_count' => 'Количество продаж',
    'purchase_count' => 'Количество закупок',
    'expense_count' => 'Количество расходов',
    'cash_received' => 'Получено наличных',
    'card_received' => 'Получено картой',

    'comprehensive_daily_overview' => 'Комплексный ежедневный обзор',
    'today_profit' => 'Прибыль сегодня',
    'bank_balance' => 'Банковский баланс',
    'customer_due' => 'Задолженность клиентов',
    'supplier_due' => 'Задолженность поставщикам',
    'today_collections' => 'Сборы сегодня',
    'net_worth' => 'Чистые активы',
    'todays_activity' => 'Активность сегодня',
    'financial_snapshot' => 'Финансовая сводка',
    'avg_transaction_value' => 'Средняя стоимость транзакции',
    'gross_profit_margin' => 'Валовая маржа прибыли',
    'opening_balance' => 'Начальный баланс',
    'closing_balance' => 'Конечный баланс',
    'cash_flow' => 'Денежный поток',
    'liquidity_ratio' => 'Коэффициент ликвидности',
    'detailed_breakdown' => 'Детальная разбивка',
    'manage_operations_summary' => 'Управление сводкой операций',
    'report_date' => 'Дата отчета',

    'gst_sales_by_products' => 'GST продажи по товарам',
    'gst_sales_by_invoice' => 'GST продажи по счетам',

    // Stock report specific translations
    'total_stock_purchase_value' => 'Общая стоимость закупки запасов',
    'total_stock_sales_value' => 'Общая стоимость продажи запасов',

    // General UI translations for Advanced Reports module
    'stock_need_only' => 'Только необходимый запас',
    'stock_need' => 'Необходимый запас',
    'expected_stock' => 'Ожидаемый запас',
    'expired_stock' => 'Просроченный запас',
    'critical_items' => 'Критические элементы',
    'total_current_stock' => 'Общий текущий запас',
    'total_stock_needed' => 'Всего необходимого запаса',
    'coverage_ratio' => 'Коэффициент покрытия',
    'processing' => 'Обработка',
    'table_not_found' => 'Таблица не найдена',
    'no_data_available_print' => 'Нет данных для печати',
    'popup_blocked' => 'Всплывающее окно заблокировано браузером. Пожалуйста, разрешите всплывающие окна для этого сайта.',
    'generated_on' => 'Создано',
    'at' => 'в',
    'printed_on' => 'Напечатано',
    'generated_by' => 'Создано',
    'system_generated_report' => 'Это системный отчет',
    'select_date' => 'Выберите дату',
    'select_location' => 'Выберите местоположение',

    // Expiry report translations
    'expiry_report' => 'Отчет о сроках годности',
    'expiry_filters' => 'Фильтры срока годности',
    'expiry_status' => 'Статус срока годности',
    'all' => 'Все',
    'expired' => 'Просрочено',
    'expiring_in_7_days' => 'Истекает через 7 дней',
    'expiring_in_30_days' => 'Истекает через 30 дней',
    'expiring_in_90_days' => 'Истекает через 90 дней',
    'expired_products' => 'Просроченные товары',
    'total_expiry_value' => 'Общая стоимость просроченного',
    'stock_expiry_report' => 'Отчет о сроках годности запасов',
    'days_to_expire' => 'Дней до истечения',
    'stock_value' => 'Стоимость запаса',
    'days_expired' => 'дней просрочено',
    'days_left' => 'дней осталось',
    'critical' => 'Критично',
    'warning' => 'Предупреждение',
    'good' => 'Хорошо',
    'remove_from_stock' => 'Удалить из запаса',

    // Enhanced expiry alert translations
    'expiring_soon' => 'Скоро истечет',
    'total_items' => 'Всего элементов',
    'alert_value' => 'Стоимость предупреждения',
    'days_ahead' => 'Дней вперед',
    'next_7_days' => 'Следующие 7 дней',
    'next_15_days' => 'Следующие 15 дней',
    'next_30_days' => 'Следующие 30 дней',
    'next_60_days' => 'Следующие 60 дней',
    'next_90_days' => 'Следующие 90 дней',
    'days_overdue' => 'дней просрочки',
    'expires_today' => 'Истекает сегодня',
    'status' => 'Статус',
    'expiry_date' => 'Срок годности',

    'invoice_subtotal' => 'Промежуточный итог счета',
    'line_discount' => 'Скидка по строке',
    'invoice_discount' => 'Скидка по счету',

    // Customer Monthly Sales Report
    'customer_monthly_sales_report' => 'Ежемесячный отчет по продажам клиентам',
    'manage_customer_monthly_sales' => 'Управление ежемесячными продажами клиентам',
    'customer_monthly_analysis' => 'Ежемесячный анализ клиентов',
    'monthly_breakdown' => 'Ежемесячная разбивка',
    'gross_profit_amount' => 'Валовая прибыль ($)',
    'gross_profit_percentage' => 'Валовая прибыль (%)',
    'avg_per_customer' => 'Среднее на клиента',
    'customer_details' => 'Детали клиента',
    'customer_information' => 'Информация о клиенте',
    'recent_transactions' => 'Последние транзакции',
    'monthly_sales_analysis' => 'Ежемесячный анализ продаж',
    'year_summary' => 'Годовая сводка',
    'search_by_name' => 'Поиск по имени...',
    'staff' => 'Персонал',

    'gross_profit' => 'Валовая прибыль',

    // Months (if not already present)
    'january' => 'Январь',
    'february' => 'Февраль',
    'march' => 'Март',
    'april' => 'Апрель',
    'may' => 'Май',
    'june' => 'Июнь',
    'july' => 'Июль',
    'august' => 'Август',
    'september' => 'Сентябрь',
    'october' => 'Октябрь',
    'november' => 'Ноябрь',
    'december' => 'Декабрь',

    // Short months
    'jan' => 'Янв',
    'feb' => 'Фев',
    'mar' => 'Мар',
    'apr' => 'Апр',
    'jun' => 'Июн',
    'jul' => 'Июл',
    'aug' => 'Авг',
    'sep' => 'Сен',
    'oct' => 'Окт',
    'nov' => 'Ноя',
    'dec' => 'Дек',

    'product_performance_report' => 'Отчет о показателях товаров',
    'manage_product_performance' => 'Управление показателями товаров',
    'product_performance_analysis' => 'Анализ показателей товаров',
    'product_details' => 'Детали товара',

    // ======================================
    // ADDITIONAL KEYS FOR PRODUCT PERFORMANCE & SALES DETAIL REPORTS
    // Add these to your existing lang file
    // ======================================

    // Date & Time
    'start_date' => 'Дата начала',
    'end_date' => 'Дата окончания',
    'week' => 'Неделя',
    'week_number' => 'Номер недели',
    'day_number' => 'Номер дня',
    'sales_date' => 'Дата продажи',

    // Week Options
    'all_weeks' => 'Все недели',
    'week_1' => 'Неделя 1',
    'week_2' => 'Неделя 2',
    'week_3' => 'Неделя 3',
    'week_4' => 'Неделя 4',
    'week_5' => 'Неделя 5',
    'weekly_totals' => 'ИТОГИ ПО НЕДЕЛЯМ',

    // Filter Options (Additional)
    'all_groups' => 'Все группы',
    'all_brands' => 'Все бренды',
    'all_units' => 'Все единицы',
    'all_users' => 'Все пользователи',
    'all_staff' => 'Весь персонал',
    'all_methods' => 'Все методы',

    // Report Sections
    'top_performing_products' => 'Топ товаров по показателям',
    'weekly_sales_summary_report' => 'Еженедельный сводный отчет по продажам',
    'staff_performance_analysis' => 'Анализ показателей персонала',
    'stock_valuation' => 'Оценка запасов',

    // Sales Detail Columns
    'sales_unit' => 'Единица продажи',
    'qty_sold' => 'Продано шт.',
    'total_sales_amt' => 'Общая сумма продаж',
    'total_purchase_amt' => 'Общая сумма закупки',
    'profit_earned' => 'Полученная прибыль',
    'margin_percent' => '% маржа',
    'total_purchase' => 'Всего закупок',
    'total_profit' => 'Общая прибыль',

    // Messages & Status
    'no_sales_data_found' => 'Данные о продажах не найдены для выбранных критериев.',
    'error_loading_sales_data' => 'Ошибка загрузки данных о продажах. Пожалуйста, попробуйте снова.',
    'report_refreshed_successfully' => 'Отчет успешно обновлен',
    'sales_detail_report_loaded' => 'Детальный отчет по продажам успешно загружен',
    'auto_refresh_5_min' => 'Автообновление (5 мин)',
    'clearing' => 'Очистка...',
    'clear' => 'Очистить',
    'search_by_brand_name' => 'Поиск по названию бренда...',
    'brand_monthly_sales_report' => 'Ежемесячный отчет по продажам брендов',
    'view_brand_sales_by_months_with_profit_analysis' => 'Просмотр продаж брендов по месяцам с анализом прибыли',

    'total_qty' => 'Общее кол-во',
    'advanced_filters' => 'Расширенные фильтры',
    'min_amount' => 'Мин. сумма',
    'max_amount' => 'Макс. сумма',

    'itemwise_sales_report' => 'Отчет по продажам по товарам',
    'itemwise_sales_subtitle' => 'Детальный анализ продаж по товарам',
    'itemwise_sales_filters' => 'Фильтры отчета по продажам по товарам',
    'product_name_sku' => 'Название товара/Артикул',
    'customer_name_mobile' => 'Имя клиента/Телефон',
    'clear_all_filters' => 'Очистить все фильтры',
    'quick_date_filters' => 'Быстрые фильтры дат:',
    'clear_date' => 'Очистить дату',
    'unique_customers' => 'Уникальных клиентов',
    'products_sold' => 'Товаров продано',
    'total_qty_sold' => 'Общее проданное кол-во',
    'detailed_view' => 'Детальный вид',
    'applied_filters' => 'Примененные фильтры',
    'date_range_label' => 'Диапазон дат:',
    'location_label' => 'Местоположение:',
    'customer_label' => 'Клиент:',
    'category_label' => 'Категория:',
    'brand_label' => 'Бренд:',
    'report_summary' => 'Сводка отчета',
    'date' => 'Дата',
    'brand' => 'Бренд',
    'qty' => 'Кол-во',
    'unit_price' => 'Цена за единицу',
    'tax_percent' => 'Налог %',
    'subtotal' => 'Промежуточный итог',
    'total' => 'Итого',
    'report_details' => 'Детали отчета:',
    'total_records' => 'Всего записей:',
    'report_period' => 'Период отчета:',
    'business_information' => 'Информация о бизнесе:',
    'tax_number' => 'Налоговый номер:',
    'printed_by' => 'Напечатано:',
    'print_report' => 'Печать отчета',
    'close' => 'Закрыть',
    'all_dates' => 'Все даты',
    'purchase_cost' => 'Стоимость закупки',

    'weekly_monthly_yearly_customer_awards' => 'Еженедельные / Ежемесячные / Годовые награды клиентам',
    'customer_recognition_system' => 'Система признания клиентов',
    'recognition_filters_controls' => 'Фильтры и управление признанием',
    'period_type' => 'Тип периода',
    'winner_count' => 'Количество победителей',
    'finalize_period' => 'Завершить период',
    'record_engagement' => 'Записать взаимодействие',
    'current_period_winners' => 'Победители текущего периода',
    'weekly_winner' => 'Еженедельный победитель',
    'monthly_winner' => 'Ежемесячный победитель',
    'yearly_winner' => 'Годовой победитель',
    'total_participants' => 'Всего участников',
    'engagement_points' => 'Баллы взаимодействия',
    'average_score' => 'Средний балл',
    'top_score' => 'Лучший балл',
    'avg_transaction' => 'Средняя транзакция',
    'customer_rankings' => 'Рейтинг и признание клиентов',
    'sales_total' => 'Общие продажи',
    'transactions' => 'Транзакции',
    'final_score' =>  'Итоговый балл',
    'customer_recognition_details' => 'Детали признания клиента',
    'loading_customer_details' => 'Загрузка деталей клиента...',
    'award_customer' => 'Наградить клиента',
    'award_type' => 'Тип награды',
    'select_award_type' => 'Выберите тип награды',
    'manual_entry' => 'Ручной ввод',
    'from_catalog' => 'Из каталога',
    'gift_description' => 'Описание подарка',
    'select_gift_from_catalog' => 'Выберите подарок из каталога',
    'loading_catalog' => 'Загрузка каталога...',
    'additional_notes_about_award' => 'Дополнительные заметки о награде...',
    'record_customer_engagement' => 'Записать взаимодействие с клиентом',
    'engagement_type' => 'Тип взаимодействия',
    'select_type' => 'Выберите тип',
    'youtube_follow' => 'Подписка на YouTube',
    'facebook_follow' => 'Подписка на Facebook',
    'instagram_follow' => 'Подписка на Instagram',
    'twitter_follow' => 'Подписка на Twitter',
    'content_share' => 'Поделиться контентом',
    'review_testimonial' => 'Отзыв/Рекомендация',
    'google_review' => 'Отзыв в Google',
    'customer_referral' => 'Рекомендация клиента',
    'points' => 'Баллы',
    'platform' => 'Платформа',
    'reference_url' => 'Ссылка',
    'verification_notes' => 'Заметки о проверке',
    'describe_verification_notes' => 'Опишите, как было проверено это взаимодействие...',
    'finalize_period_rankings' => 'Завершить рейтинги периода',
    'message_warning_finalized1' => 'После завершения рейтинги этого периода не могут быть изменены.',
    'message_warning_finalized2' => 'Это зафиксирует текущих победителей и позволит вам наградить их.',
    'period' => 'Период',
    'winners_count' => 'Количество победителей',
    'quantity' => 'Количество',
    'customer_engagements' => 'Взаимодействия с клиентами',
    'recorded_by' => 'Записано',
    'recorded_date' => 'Дата записи',
    'no_customer_engagements_found' => 'Взаимодействия с клиентами не найдены',

    // Service Staff Recognition
    'service_staff_recognition_system' => 'Система признания обслуживающего персонала',
    'weekly_monthly_yearly_staff_awards' => 'Еженедельные / Ежемесячные / Годовые награды персоналу',
    'staff_rankings' => 'Рейтинг и признание персонала',
    'staff_name' => 'Имя персонала',
    'performance_points' => 'Баллы производительности',
    'performance_activities' => 'Произв. активности',
    'activity_type' => 'Тип активности',
    'description' => 'Описание',
    'total_staff' => 'Всего персонала',
    'top_performer' => 'Лучший исполнитель',
    'average_performance' => 'Средняя производительность',
    'total_activities' => 'Всего активностей',
    'award_staff' => 'Наградить персонал',
    'record_performance_activity' => 'Записать активность производительности',
    'record_activity' => 'Записать активность',
    'staff_member' => 'Член персонала',
    'punctuality' => 'Пунктуальность',
    'customer_service_excellence' => 'Отличное обслуживание клиентов',
    'upselling_success' => 'Успех в допродажах',
    'teamwork' => 'Командная работа',
    'training_completion' => 'Завершение обучения',
    'cleanliness_organization' => 'Чистота и организация',
    'other' => 'Другое',
    'no_performance_activities_found' => 'Активности производительности не найдены',

    'weekly' => 'Еженедельно',
    'monthly' => 'Ежемесячно',
    'yearly' => 'Ежегодно',

    'weekly_top_performer' => 'Еженедельный лучший исполнитель',
    'monthly_top_performer' => 'Ежемесячный лучший исполнитель',
    'yearly_top_performer' => 'Годовой лучший исполнитель',

    'current_period_top_performers' => 'Лучшие исполнители текущего периода',
    'current_period_top_performer' => 'Лучший исполнитель текущего периода',
    'top_performer_score' => 'Балл лучшего исполнителя',
    'demand_forecasting' => 'Прогнозирование спроса',
    'demand_forecasting_report' => 'Прогнозирование спроса',
    'historical_period' => 'Исторический период',
    'forecast_period' => 'Период прогноза',
    '3_months' => '3 месяца',
    '6_months' => '6 месяцев',
    '12_months' => '12 месяцев',
    'sales_prediction_subtitle' => 'Прогнозирование продаж, сезонные модели и предотвращение дефицита',
    'forecasted_demand' => 'Прогнозируемый спрос',
    'historical_demand' => 'Исторический спрос',
    'forecasted_period' => 'Прогнозируемый период',
    'generate_forecast' => 'Создать прогноз',
    'products_analyzed' => 'Товаров проанализировано',
    'stockout_alerts' => 'Предупреждения о дефиците',
    'reorder_required' => 'Требуется перезаказ',
    'all_alerts' => 'Все предупреждения',
    'high' => 'Высокий',
    'medium' => 'Средний',
    'low' => 'Низкий',
    'daily_demand' => 'Ежедневный спрос',
    'days_of_supply' => 'Дней запаса',
    'alert_level' => 'Уровень предупреждения',
    'estimated_stockout' => 'Предполагаемый дефицит',
    'recommended_action' => 'Рекомендуемое действие',
    'select_product' => 'Выберите товар',
    'historical' => 'Исторический',
    'forecast' => 'Прогноз',
    'combined' => 'Комбинированный',
    'all_products' => 'Все товары',
    'reorder_now' => 'Перезаказать сейчас',
    'monitor_closely' => 'Внимательно отслеживать',
    'overstocked' => 'Избыток',
    'optimal' => 'Оптимально',
    'reorder_point' => 'Точка перезаказа',
    'eoq' => 'EOQ',
    'priority' => 'Приоритет',
    'trend' => 'Тренд',
    'volatility' => 'Волатильность',

    // Section titles
    'critical_stockout_alerts' => 'Критические предупреждения о дефиците',
    'demand_forecast_visualization' => 'Визуализация прогноза спроса',
    'seasonal_patterns' => 'Сезонные модели',
    'forecasting_methods_comparison' => 'Сравнение методов прогнозирования',
    'demand_confidence_levels' => 'Уровни уверенности спроса',
    'reorder_point_optimization' => 'Оптимизация точки перезаказа',
    'highest_forecasted_demand' => 'Наибольший прогнозируемый спрос',
    'most_volatile_demand' => 'Наиболее волатильный спрос',

    // Table headers
    'forecasting_methods' => 'Методы прогнозирования',

    // Messages and labels
    'no_critical_alerts_found' => 'Критических предупреждений не найдено',
    'next_months' => 'Следующие',
    'months' => 'месяцев',
    'select_product_option' => 'Выберите товар',
    'forecasting_methods_labels' => 'Простое СС, Линейный тренд, Экспоненциальный, Сезонный, Комбинированный',
    'forecasting_methods_comparison_title' => 'Сравнение методов прогнозирования',
    'forecast_confidence_distribution_title' => 'Распределение уверенности прогноза',
    'export_image' => 'Экспорт как изображение',

    // Waste & Loss Analysis
    'waste_loss_analysis_report' => 'Анализ отходов и потерь',
    'waste_loss_subtitle' => 'Просроченные товары, поврежденные товары, кражи и предотвращение потерь',
    'analysis_period' => 'Период анализа',
    'analyze_waste_loss' => 'Анализировать отходы и потери',
    'damaged_goods' => 'Поврежденные товары',
    'theft_shrinkage' => 'Кражи и усушка',
    'total_loss' => 'Общие потери',
    'loss_trends' => 'Тренды потерь',
    'loss_breakdown' => 'Разбивка потерь',
    'expired_products_analysis' => 'Анализ просроченных товаров',
    'damaged_goods_analysis' => 'Анализ поврежденных товаров',
    'theft_shrinkage_analysis' => 'Анализ краж и усушки',
    'loss_prevention_insights' => 'Идеи по предотвращению потерь',
    'expiry_categories' => 'Категории истечения срока',
    'upcoming_expirations' => 'Предстоящие истечения срока',
    'expired_today' => 'Просрочено сегодня',
    'expired_this_week' => 'Просрочено на этой неделе',
    'expired_this_month' => 'Просрочено в этом месяце',
    'all_expired' => 'Все просроченные',
    'days_remaining' => 'Дней осталось',
    'loss_value' => 'Стоимость потери',
    'damage_date' => 'Дата повреждения',
    'reason' => 'Причина',
    'damage_summary' => 'Сводка по повреждениям',
    'physical_damage' => 'Физическое повреждение',
    'spoilage' => 'Порча',
    'shrinkage_rate' => 'Коэффициент усушки',
    'high_risk_products' => 'Товары высокого риска',
    'incidents' => 'Инциденты',
    'quantity_lost' => 'Потерянное количество',
    'value_lost' => 'Потерянная стоимость',
    'top_loss_categories' => 'Топ категорий потерь',
    'loss_by_location' => 'Потери по местоположению',
    'recommendations' => 'Рекомендации',
    'total_loss_value' => 'Общая стоимость потерь',
    'incident_count' => 'Количество инцидентов',
    'supplier' => 'Поставщик',
    'last_3_months' => 'Последние 3 месяца',
    'last_6_months' => 'Последние 6 месяцев',
    'no_expired_products' => 'Просроченные товары не найдены',
    'no_upcoming_expirations' => 'Предстоящих истечений срока нет',
    'no_damaged_goods' => 'Поврежденные товары не найдены',
    'no_high_risk_products' => 'Товары высокого риска не выявлены',
    'no_recommendations' => 'Рекомендации недоступны',
    'no_chart_available' => 'Диаграмма недоступна для экспорта',

    'value' => 'Стоимость',

    // Location Performance Report
    'location_performance_report' => 'Производительность магазинов/местоположений',
    'manage_location_performance' => 'Управление производительностью магазинов/местоположений',
    'location_performance_analytics' => 'Аналитика производительности местоположений',
    'multi_location_analysis' => 'Многолокационный анализ',
    'location_sales_comparison' => 'Сравнение продаж местоположений',
    'performance_benchmarks' => 'Эталоны производительности',
    'regional_sales_analysis' => 'Региональный анализ продаж',
    'location_profitability' => 'Прибыльность местоположения',
    'location_comparison' => 'Сравнение местоположений',
    'benchmarking_analysis' => 'Бенчмаркинг анализ',
    'profitability_analysis' => 'Анализ прибыльности',
    'performance_trends' => 'Тренды производительности',
    'staff_performance' => 'Производительность персонала',
    'performance_score' => 'Показатель производительности',
    'revenue_per_location' => 'Доход на местоположение',
    'transactions_per_location' => 'Транзакции на местоположение',
    'profit_per_location' => 'Прибыль на местоположение',
    'top_performing_locations' => 'Топ местоположений по показателям',
    'underperforming_locations' => 'Местоположения с низкими показателями',
    'location_efficiency' => 'Эффективность местоположения',
    'regional_market_share' => 'Региональная доля рынка',
    'location_roi' => 'ROI местоположения',
    'operating_expenses' => 'Операционные расходы',
    'net_profit_margin' => 'Чистая маржа прибыли',
    'performance_indicators' => 'Показатели производительности',
    'location_overview' => 'Обзор местоположения',
    'compare_period' => 'Сравнить период',
    'benchmark_metrics' => 'Эталонные метрики',
    'revenue_growth' => 'Рост дохода',
    'profit_growth' => 'Рост прибыли',
    'efficiency_score' => 'Показатель эффективности',
    'top_performers' => 'Лучшие исполнители',
    'bottom_performers' => 'Худшие исполнители',
    'location_ranking' => 'Рейтинг местоположений',
    'performance_rating' => 'Оценка производительности',
    'excellent' => 'Отлично',
    'average' => 'Средне',
    'poor' => 'Плохо',
    'staff_productivity' => 'Производительность персонала',
    'sales_per_staff' => 'Продажи на персонал',
    'avg_transaction_per_staff' => 'Средняя транзакция на персонал',
    'staff_efficiency' => 'Эффективность персонала',
    'location_insights' => 'Идеи по местоположениям',
    'performance_summary' => 'Сводка производительности',
    'kpi_dashboard' => 'Панель KPI',
    'operational_metrics' => 'Операционные метрики',

    'locations' => 'Местоположения',
    'compare_with' => 'Сравнить с',
    'compare' => 'Сравнить',

    // Additional Location Performance translations
    'transaction_growth' => 'Рост транзакций',
    'customer_growth' => 'Рост клиентов',
    'avg_transaction_growth' => 'Рост средней транзакции',
    'profit_margin_change' => 'Изменение маржи прибыли',
    'current_period' => 'Текущий период',
    'benchmark_period' => 'Эталонный период',
    'regional_summary' => 'Региональная сводка',
    'top_regions' => 'Топ регионов',
    'market_share' => 'Доля рынка',
    'regional_trends' => 'Региональные тренды',
    'location_count' => 'Количество местоположений',
    'regional_sales' => 'Региональные продажи',
    'regional_transactions' => 'Региональные транзакции',
    'regional_customers' => 'Региональные клиенты',
    'avg_per_location' => 'Среднее на местоположение',
    'region' => 'Регион',
    'profitability_ranking' => 'Рейтинг прибыльности',
    'average_metrics' => 'Средние метрики',
    'avg_gross_profit_margin' => 'Средняя валовая маржа',
    'avg_net_profit_margin' => 'Средняя чистая маржа',
    'avg_roi' => 'Средний ROI',
    'cogs' => 'Себестоимость',
    'expenses' => 'Расходы',
    'revenue' => 'Доход',
    'customers_served' => 'Обслужено клиентов',
    'avg_sale_value' => 'Средняя стоимость продажи',
    'staff_id' => 'ID персонала',
    'trends' => 'Тренды',
    'comparison_type' => 'Тип сравнения',
    'period_info' => 'Информация о периоде',
    'benchmarks' => 'Эталоны',
    'location_profitability_analysis' => 'Анализ прибыльности местоположения',
    'staff_performance_by_location' => 'Производительность персонала по местоположениям',
    'performance_trends_analysis' => 'Анализ трендов производительности',
    'regional_market_analysis' => 'Региональный анализ рынка',
    'benchmark_analysis' => 'Бенчмаркинг анализ',
    'select_locations' => 'Выберите местоположения',
    'date_range_required' => 'Требуется диапазон дат',
    'loading_analytics' => 'Загрузка аналитики...',
    'analytics_loaded' => 'Аналитика успешно загружена',
    'error_loading_analytics' => 'Ошибка загрузки аналитики',
    'no_data_available_for_period' => 'Нет данных для выбранного периода',
    'performance_data' => 'Данные производительности',
    'comparison_data' => 'Данные сравнения',
    'benchmark_data' => 'Эталонные данные',
    'trend_data' => 'Данные трендов',
    'profitability_data' => 'Данные прибыльности',
    'staff_data' => 'Данные персонала',
    'regional_data' => 'Региональные данные',

    'toggle_view' => 'Переключить вид',
    'benchmark_scores' => 'Эталонные баллы',
    'sales' => 'Продажи',
    'share' => 'Доля',
    'city' => 'Город',
    'amount' => 'Сумма',
    'detailed_location_performance' => 'Детальная производительность местоположений',
    'total_locations' => 'Всего местоположений',
    'avg_profit_margin' => 'Средняя маржа прибыли',

    // Hardcoded text translations for Location Performance Report
    'active_locations' => 'активных местоположений',
    'growth' => 'рост',
    'margin' => 'маржа',
    'chart_view_toggled_to' => 'Вид диаграммы переключен на',
    'chart' => 'диаграмма',
    'staff_view_switched_to_card_layout' => 'Вид персонала переключен на карточный',
    'staff_view_switched_to_table_layout' => 'Вид персонала переключен на табличный',
    'staff_performance_container_not_found' => 'Контейнер производительности персонала не найден',
    'regional_sales_analysis_report' => 'Региональный анализ продаж',
    'regional_analysis_data_not_available_for_printing' => 'Данные регионального анализа недоступны для печати',
    'location_performance_data_exported_successfully' => 'Данные производительности местоположений успешно экспортированы',
    'error_exporting_location_data' => 'Ошибка экспорта данных местоположений',
    'csv_header' => 'ID местоположения,Название,Город,Регион,Общие продажи,Транзакции,Средняя транзакция,Клиенты,Валовая прибыль,Маржа прибыли',
    'line' => 'линейная',
    'bar' => 'столбчатая',
    'card' => 'карточка',
    'table' => 'таблица',
    'exported_successfully' => 'успешно экспортировано',

    // Staff Productivity Report
    'staff_productivity_report' => 'Производительность персонала',
    'sales_performance_and_efficiency' => 'Анализ производительности и эффективности продаж',
    'staff_members' => 'Члены персонала',
    'active_staff' => 'активного персонала',
    'total_commissions' => 'Общие комиссии',
    'avg_per_staff' => 'среднее на персонал',
    'avg_commission' => 'средняя комиссия',
    'avg_efficiency' => 'Средняя эффективность',
    'efficiency_tracking' => 'Отслеживание эффективности',
    'staff_sales_performance' => 'Производительность продаж персонала',
    'working_hours_efficiency' => 'Эффективность рабочих часов',
    'productivity_trends' => 'Тренды производительности',
    'commission_tracking' => 'Отслеживание комиссий',
    'improvement_suggestions' => 'Предложения по улучшению производительности',
    'detailed_staff_performance' => 'Детальная производительность персонала',
    'staff_comparison_analysis' => 'Сравнительный анализ персонала',
    'commission' => 'Комиссия',
    'commission_amount' => 'Сумма комиссии',
    'current' => 'Текущий',
    'target' => 'Цель',
    'no_suggestions_available' => 'Нет доступных предложений по улучшению',
    'staff_csv_header' => 'Имя персонала,Местоположение,Продажи,Транзакции,Показатель эффективности,Комиссия,Оценка производительности',
    'staff_data_exported_successfully' => 'Данные производительности персонала успешно экспортированы',
    'error_exporting_staff_data' => 'Ошибка экспорта данных производительности персонала',
    'radar' => 'радар',
    'comparison_view_switched_to_card_layout' => 'Вид сравнения переключен на карточный',
    'comparison_view_switched_to_table_layout' => 'Вид сравнения переключен на табличный',
    'comparison_container_not_found' => 'Контейнер сравнения не найден',

    // Product Category Performance translations
    'product_category_performance' => 'Производительность категорий товаров',
    'category_contribution_and_growth' => 'Анализ вклада категорий и тренды роста',
    'category_contribution' => 'Вклад категории',
    'cross_selling_opportunities' => 'Возможности кросс-продаж',
    'margin_analysis' => 'Анализ маржи',
    'growth_trends' => 'Тренды роста',
    'inventory_turnover' => 'Оборачиваемость запасов',
    'detailed_category_performance' => 'Детальная производительность категорий',
    'profit' => 'Прибыль',
    'contribution' => 'Вклад',
    'avg_price' => 'Средняя цена',
    'units_sold' => 'Продано единиц',
    'total_categories' => 'Всего категорий',
    'sales_contribution' => 'Вклад в продажи',
    'profit_contribution' => 'Вклад в прибыль',
    'days_to_sell' => 'Дней на продажу',
    'stock_velocity' => 'Скорость запаса',
    'co_occurrences' => 'Совпадения',
    'avg_value' => 'Средняя стоимость',
    'sales_pattern' => 'Модель продаж',
    'view_toggled' => 'Вид успешно переключен',
    'unique_products' => 'Уникальных товаров',
    'units' => 'Единицы',

    // Additional translations for Product Category Report
    'error_loading_analytics_data' => 'Ошибка загрузки аналитических данных. Пожалуйста, попробуйте снова.',
    'growth_rate_percentage' => 'Темп роста %',
    'confidence_label' => 'Уверенность:',
    'transactions_label' => 'Транзакции:',
    'analytics_data_received' => 'Получены аналитические данные:',
    'loading_data' => 'Загрузка данных...',
    'filter_controls' => 'Управление фильтрами',
    'business_location' => 'Местоположение бизнеса',
    'brands' => 'Бренды',
    'export_data' => 'Экспорт данных',
    'last_7_days' => 'Последние 7 дней',
    'top_performing_categories' => 'Топ категорий по показателям',

    'categories' => 'Категории',
    'total_revenue' => 'Общий доход',

    // Seasonal Trends Report
    'seasonal_trends_report' => 'Сезонные тренды',
    'seasonal_trends_description' => 'Анализ сезонных моделей, производительности праздников и эффективности акций',

    // Audit Trail Report
    'audit_trail_report' => 'Журнал аудита',
    'audit_trail_description' => 'Комплексное отслеживание соответствия и управления рисками',
    'audit_activities' => 'Активности аудита',
    'transaction_modifications' => 'Модификации транзакций',
    'high_risk_activities' => 'Высокорисковые активности',
    'active_users' => 'Активные пользователи',
    'activities_by_type' => 'Активности по типам',
    'risk_level_distribution' => 'Распределение уровня риска',
    'daily_activity_trend' => 'Ежедневный тренд активности',
    'top_active_users' => 'Топ активных пользователей',
    'audit_trail_filters' => 'Фильтры журнала аудита',
    'detailed_audit_trail' => 'Детальный журнал аудита',
    'risk_level' => 'Уровень риска',
    'compliance_status' => 'Статус соответствия',
    'transaction_details' => 'Детали транзакции',
    'user_info' => 'Информация о пользователе',
    'high_risk' => 'Высокий риск',
    'medium_risk' => 'Средний риск',
    'low_risk' => 'Низкий риск',
    'compliant' => 'Соответствует',
    'requires_review' => 'Требует проверки',
    'non_compliant' => 'Не соответствует',
    'compliance_risk_management' => 'Управление соответствием и рисками',

    // Tax Compliance Report
    'tax_compliance_report' => 'Налоговое соответствие',
    'tax_compliance_description' => 'Поддержка нескольких налоговых юрисдикций и идеи по оптимизации',

    // Multi-Channel Sales Report
    'multi_channel_sales_report' => 'Многоканальные продажи',
    'multi_channel_description' => 'Аналитика производительности онлайн vs офлайн и оптимизация',
    'online_revenue' => 'Онлайн доход',
    'offline_revenue' => 'Офлайн доход',
    'cross_channel_customers' => 'Кросс-канальные клиенты',
    'channel_efficiency' => 'Эффективность канала',
    'channel_profitability' => 'Прибыльность канала',
    'customer_channel_preferences' => 'Предпочтения клиентов по каналам',
    'peak_hours_by_channel' => 'Пиковые часы по каналам',
    'channel_optimization_insights' => 'Идеи по оптимизации каналов',
    'total_tax_collected' => 'Всего собрано налогов',
    'net_tax_liability' => 'Чистые налоговые обязательства',
    'compliance_score' => 'Показатель соответствия',
    'potential_savings' => 'Потенциальная экономия',
    'monthly_tax_liability_trend' => 'Тренд ежемесячных налоговых обязательств',
    'tax_by_jurisdiction' => 'Налоги по юрисдикции',
    'tax_audit_risk_assessment' => 'Оценка риска налогового аудита',
    'risk_score' => 'Показатель риска',
    'tax_optimization_insights' => 'Идеи по налоговой оптимизации',
    'upcoming_filing_deadlines' => 'Предстоящие сроки подачи',
    'filing_deadline' => 'Срок подачи',
    'tax_liability_details' => 'Детали налоговых обязательств',
    'tax_name' => 'Название налога',
    'tax_rate' => 'Налоговая ставка (%)',
    'output_tax' => 'Выходной налог',
    'input_tax_credit' => 'Входной налоговый кредит',
    'net_liability' => 'Чистые обязательства',
    'sales_trans' => 'Транзакции продаж',
    'purchase_trans' => 'Транзакции закупок',
    'jurisdiction' => 'Юрисдикция',
    'filing_period' => 'Период подачи',
    'report_type' => 'Тип отчета',
    'export_report' => 'Экспорт отчета',
    'export_excel' => 'Экспорт Excel',
    'tax_liability' => 'Налоговые обязательства',
    'filing_assistance' => 'Помощь в подаче',
    'optimization' => 'Оптимизация',
    'quarterly' => 'Квартальный',
    'semi_annual' => 'Полугодовой',
    'annual' => 'Годовой',
    'pending' => 'Ожидает проверки',
    'overdue' => 'Просрочен',
    'exempted' => 'Освобожден',
    'urgent' => 'Срочно',
    'upcoming' => 'Предстоящий',
    'federal' => 'Федеральный',
    'state_local' => 'Региональный/Местный',
    'gross_sales' => 'Валовые продажи',
    'taxable_sales' => 'Налогооблагаемые продажи',
    'tax_collected' => 'Собрано налогов',
    'tax_paid_on_purchases' => 'Налоги, уплаченные при закупках',
    'filing_status' => 'Статус подачи',
    'tax_rate_efficiency_analysis' => 'Анализ эффективности налоговой ставки',
    'seasonal_tax_optimization' => 'Сезонная налоговая оптимизация',
    'input_tax_credit_opportunities' => 'Возможности входного налогового кредита',
    'multi_tax_jurisdiction_support' => 'Поддержка нескольких налоговых юрисдикций и оптимизация',
    'monthly_trends' => 'Ежемесячные тренды',
    'yearly_trends' => 'Годовые тренды',
    'holiday_season_performance' => 'Производительность праздничного сезона',
    'promotional_effectiveness' => 'Эффективность акций',
    'weather_impact_analysis' => 'Анализ влияния погоды',
    'peak_performance_analysis' => 'Анализ пиковой производительности',
    'current_year_performance' => 'Производительность текущего года',
    'year_over_year_growth' => 'Рост год к году',
    'best_performing_season' => 'Лучший сезон',
    'best_performing_month' => 'Лучший месяц',
    'best_performing_months' => 'Лучшие месяцы',
    'day_of_week_performance' => 'Производительность по дням недели',
    'last_1_year' => 'Последний 1 год',
    'last_2_years' => 'Последние 2 года',
    'last_3_years' => 'Последние 3 года',
    'last_5_years' => 'Последние 5 лет',
    'gross_revenue' => 'Валовый доход',
    'promotion_type' => 'Тип акции',
    'avg_discount' => 'Средняя скидка',
    'discount_percentage' => 'Процент скидки',
    'weather_analysis_coming_soon' => 'Анализ погоды скоро',
    'weather_analysis_description' => 'Интеграция с API погоды для анализа влияния погодных условий на показатели продаж',
    'holiday_performance' => 'Производительность праздников',
    'daily_average' => 'Ежедневное среднее',
    'duration_days' => 'Продолжительность (дней)',
    'growth_direction' => 'Направление роста',

    // Supplier Performance Report
    'supplier_performance_report' => 'Производительность поставщиков',
    'supplier_performance_description' => 'Производительность доставки, оценка качества, соответствие платежам и анализ рисков',
    'delivery_performance' => 'Производительность доставки',
    'quality_assessment' => 'Оценка качества',
    'payment_compliance' => 'Соответствие платежам',
    'supplier_risk_analysis' => 'Анализ рисков поставщиков',
    'on_time_delivery' => 'Доставка вовремя',
    'average_delivery_days' => 'Средние дни доставки',
    'supplier_reliability' => 'Надежность поставщика',
    'quality_rating' => 'Оценка качества',
    'defect_rate' => 'Коэффициент дефектов',
    'payment_terms_compliance' => 'Соответствие условиям оплаты',
    'supplier_rankings' => 'Рейтинг поставщиков',
    'underperformers' => 'С низкими показателями',
    'delivery_insights' => 'Идеи по доставке',
    'quality_insights' => 'Идеи по качеству',
    'payment_insights' => 'Идеи по платежам',
    'risk_insights' => 'Идеи по рискам',
    'total_suppliers' => 'Всего поставщиков',
    'total_spend' => 'Общие расходы',
    'avg_delivery_time' => 'Среднее время доставки',
    'overall_compliance' => 'Общее соответствие',
    'delivery_reliability' => 'Надежность доставки',
    'supplier_name' => 'Имя поставщика',
    'orders_count' => 'Количество заказов',
    'avg_delivery_days' => 'Средние дни доставки',
    'quality_score' => 'Показатель качества',
    'payment_score' => 'Показатель платежей',
    'overall_score' => 'Общий показатель',
    'supplier_details' => 'Детали поставщика',
    'performance_metrics' => 'Метрики производительности',

    // Warranty & Service Report
    'warranty_service_report' => 'Гарантия и обслуживание',
    'warranty_service_description' => 'Отслеживание гарантий, анализ запросов на обслуживание и метрики поддержки клиентов',
    'warranty_tracking' => 'Отслеживание гарантии',
    'service_requests_analysis' => 'Анализ запросов на обслуживание',
    'customer_support_metrics' => 'Метрики поддержки клиентов',
    'post_sale_service_performance' => 'Производительность послепродажного обслуживания',
    'warranty_claims_analysis' => 'Анализ гарантийных претензий',
    'product_warranty_tracking' => 'Отслеживание гарантии товаров',
    'service_request_analysis' => 'Анализ запросов на обслуживание',
    'warranty_status_distribution' => 'Распределение статуса гарантии',
    'service_request_trends' => 'Тренды запросов на обслуживание',
    'total_products_sold' => 'Всего товаров продано',
    'warranty_coverage' => 'Гарантийное покрытие',
    'service_requests' => 'Запросы на обслуживание',
    'resolution_rate' => 'Коэффициент решения',
    'warranty_status' => 'Статус гарантии',
    'warranty_end_date' => 'Дата окончания гарантии',
    'product_value' => 'Стоимость товара',
    'request_id' => 'ID запроса',
    'resolution_days' => 'Дней до решения',
    'warranties_expiring_soon' => 'Гарантии, истекающие скоро',
    'service_recommendations' => 'Рекомендации по обслуживанию',
    'performance_insights' => 'Идеи по производительности',
    'key_insights' => 'Ключевые идеи',
    'comprehensive_report' => 'Комплексный отчет',
    'warranty_claims' => 'Гарантийные претензии',
    'avg_response_time' => 'Среднее время ответа',
    'avg_resolution_time' => 'Среднее время решения',
    'customer_satisfaction' => 'Удовлетворенность клиентов',
    'first_response_sla' => 'SLA первого ответа',
    'resolution_sla' => 'SLA решения',
    'warranty_claim_rate' => 'Коэффициент гарантийных претензий',
    'service_cost_ratio' => 'Коэффициент стоимости обслуживания',
    'response_time_metrics' => 'Метрики времени ответа',
    'warranty_expiring_alert' => 'Гарантии, истекающие в следующие 30 дней',
    'high_priority_requests' => 'Высокоприоритетные запросы',
    'pending_resolutions' => 'Ожидающие решения',
    'warranty_type' => 'Тип гарантии',
    'claim_amount' => 'Сумма претензии',
    'claim_reason' => 'Причина претензии',
    'service_type' => 'Тип обслуживания',
    'assigned_staff' => 'Назначенный персонал',
    'request_priority' => 'Приоритет запроса',
    'service_cost' => 'Стоимость обслуживания',
    'resolution_time' => 'Время решения',
    'customer_feedback' => 'Отзывы клиентов',
    'satisfaction_rating' => 'Оценка удовлетворенности',
    'service_quality' => 'Качество обслуживания',
    'warranty_utilization' => 'Использование гарантии',
    'post_sale_performance' => 'Производительность послепродажного обслуживания',

    // Customer Group Report
    'customer_group_report' => 'Отчет по группам клиентов',
    'customer_group_analytics' => 'Аналитика групп клиентов',
    'customer_group_description' => 'Анализ производительности по группам клиентов с детализацией по продавцам',
    'group_leaderboard' => 'Рейтинг групп',
    'salesperson_performance' => 'Производительность продавцов',
    'customer_drill_down' => 'Детализация по клиентам',
    'invoice_drill_down' => 'Детализация по счетам',
    'aging_analysis' => 'Анализ старения',
    'net_sales' => 'Чистые продажи',
    'customer_count' => 'Клиентов',
    'invoice_count' => 'Счетов',
    'avg_invoice_value' => 'Средний счет',
    'top_performing_group' => 'Лучшая группа',
    'top_salesperson' => 'Лучший продавец',
    'outstanding_due' => 'Невыполненные задолженности',
    'aging_buckets' => 'Корзины старения',
    'risk_analysis' => 'Анализ рисков',
    'include_returns' => 'Включить возвраты',
    'include_drafts' => 'Включить черновики',
    'exclude_returns' => 'Исключить возвраты',
    'exclude_drafts' => 'Исключить черновики',
    'dynamic_grouping' => 'Динамическая группировка',
    'vip_customers' => 'VIP клиенты',
    'regular_customers' => 'Обычные клиенты',
    'unassigned_customers' => 'Неназначенные',
    'customer_group_performance' => 'Производительность групп клиентов',
    'drill_down_analysis' => 'Анализ детализации',

    // Menu Navigation Translations
    'sales_revenue_analysis' => 'Анализ продаж и дохода',
    'sales_analytics' => 'Аналитика продаж',
    'customer_performance' => 'Производительность клиентов',
    'product_sales_analysis' => 'Анализ продаж товаров',
    'daily_operations' => 'Ежедневные операции',
    'daily_dashboard' => 'Ежедневная панель',
    'inventory_product_management' => 'Управление запасами и товарами',
    'inventory_turnover_report' => 'Оборачиваемость запасов',
    'stock_management' => 'Управление запасами',
    'brand_analytics' => 'Аналитика брендов',
    'brand_comparison' => 'Сравнение брендов',
    'supplier_performance' => 'Производительность поставщиков',
    'supplier_analysis' => 'Анализ поставщиков',
    'supplier_profitability' => 'Прибыльность поставщиков',
    'financial_compliance' => 'Финансы и соответствие',
    'profit_loss_analysis' => 'Анализ прибылей и убытков',
    'purchase_analysis' => 'Анализ закупок',
    'customer_lifetime_value' => 'Пожизненная стоимость клиента',
    'customer_behavior_analytics' => 'Аналитика поведения клиентов',
    'customer_segmentation_report' => 'Сегментация клиентов',
    'gst_sales_compliance' => 'Соответствие GST продаж',
    'gst_purchase_compliance' => 'Соответствие GST закупок',
    'monthly_expenses' => 'Ежемесячные расходы',
    'business_operations_summary' => 'Сводка операций бизнеса',
    'customer_staff_engagement' => 'Клиенты и персонал',
    'customer_loyalty_program' => 'Программа лояльности клиентов',
    'staff_performance_management' => 'Управление производительностью персонала',
    'awarded' => 'Награжден',
    'not_awarded' => 'Не награжден',

    // Product search
    'type_to_search_product' => 'Введите для поиска товара',
    'searching' => 'Поиск...',
    'no_products_found' => 'Товары не найдены',

    // Module notifications
    'module_not_enabled' => 'Модуль не включен',
    'alert' => 'Предупреждение',
    'module_required' => 'Требуется модуль',
    'enable_module_instruction' => 'Пожалуйста, включите требуемый модуль в настройках бизнеса для использования этой функции.',
    'go_to_settings' => 'Перейти в настройки',
    'go_to_home' => 'Перейти на главную',

    // Reward Points Report
    'reward_points_report' => 'Баллы вознаграждения и обязательства',
    'reward_points_description' => 'Отслеживание баллов вознаграждения клиентов, история погашения и анализ финансовых обязательств',
    'outstanding_liability_points' => 'Невыполненные обязательства (баллы)',
    'liability_amount' => 'Сумма обязательств (BDT)',
    'active_customers_with_points' => 'Активные клиенты с баллами',
    'redemption_rate' => 'Коэффициент погашения',
    'total_points_issued' => 'Всего выдано баллов',
    'total_points_redeemed' => 'Всего погашено баллов',
    'points_redeemed_this_month' => 'Погашено баллов в этом месяце',
    'avg_points_per_customer' => 'Среднее баллов на клиента',
    'top_point_earners' => 'Топ получателей баллов',
    'top_point_redeemers' => 'Топ погасителей баллов',
    'customer_points_summary' => 'Сводка баллов клиентов',
    'export_table' => 'Экспорт таблицы',
    'points_earned' => 'Заработанные баллы',
    'points_redeemed' => 'Погашенные баллы',
    'current_balance' => 'Текущий баланс',
    'liability_bdt' => 'Обязательства (BDT)',
    'redemption_count' => 'Количество погашений',
    'last_activity' => 'Последняя активность',
    'invoice_amount' => 'Сумма счета',
    'points_value' => 'Стоимость баллов',
    'final_payable' => 'Итоговая к оплате',
    'customer_summary' => 'Сводка клиента',
    'view_type' => 'Тип вида',
    'select_customer' => 'Выберите клиента',
    'type_2_chars_to_search' => 'Введите 2 символа для поиска',
    'loading_reward_points_data' => 'Загрузка данных баллов вознаграждения...',
    'no_reward_points_data' => 'Нет данных о баллах вознаграждения',
    'loading_transaction_details' => 'Загрузка деталей транзакции...',
    'no_transaction_data' => 'Нет данных о транзакциях',
    'no_matching_transactions' => 'Совпадающие транзакции не найдены',
    'no_result' => 'Нет результата',
    'type_to_search' => 'Введите для поиска',
    'reward_points_not_enabled' => 'Модуль баллов вознаграждения не включен для вашего бизнеса.',
    'enable_reward_points_instruction' => 'Пожалуйста, включите функцию баллов вознаграждения в настройках бизнеса для использования этого отчета.',

    // Additional keys for hardcoded text fixes
    'advanced_reports_dashboard' => 'Расширенные отчеты - Панель бизнес-аналитики',
    'comprehensive_analytics_description' => 'Комплексная аналитика и отчетность для принятия решений на основе данных',
    'professional_reports_count' => '40+ профессиональных отчетов',
    'transform_data_insights' => 'Превратите данные вашего бизнеса в действенные идеи',
    'view_report' => 'Просмотреть отчет',
    'coming_soon' => 'Скоро',
    'quick_access_popular_reports' => 'Быстрый доступ - Самые популярные отчеты',
    'comprehensive_profit_loss_description' => 'Комплексная отчетность по прибылям и убыткам с расширенной аналитикой',
    'filters_controls' => 'Фильтры и управление',
    'custom_date_range' => 'Пользовательский диапазон дат',
    'select_custom_date_range' => 'Выберите пользовательский диапазон дат',
    'export_pdf' => 'Экспорт PDF',
    'expense_breakdown_description' => 'Просмотр разбивки расходов по категориям и месяцам',
    'year' => 'Год',
    'average_expense' => 'Средний расход',
    'exporting' => 'Экспорт...',
    'invoices_paid' => 'счетов оплачено',
    'per_transaction' => 'За транзакцию',
    'confirm_delete_transaction' => 'Вы уверены, что хотите удалить эту транзакцию?',
    'error_loading_data' => 'Ошибка загрузки данных',

    // Award Catalog translations
    'award_catalog_management' => 'Управление каталогом наград',
    'manage_gifts_awards_customer_recognition' => 'Управление подарками и наградами для признания клиентов',
    'award_catalog_controls' => 'Управление каталогом наград',
    'add_new_award' => 'Добавить новую награду',
    'award_catalog_items' => 'Элементы каталога наград',
    'delete_award' => 'Удалить награду',
    'edit_award' => 'Редактировать награду',

    // Business Analytics Dashboard
    'business_analytics_dashboard' => 'Панель бизнес-аналитики',
    'view_data_usage_across_businesses' => 'Просмотр использования данных по всем бизнесам',
    'total_businesses' => 'Всего бизнесов',
    'actual_db_size' => 'Фактический размер БД',
    'avg_business_size' => 'Средний размер бизнеса',
    'business_data_analytics' => 'Аналитика данных бизнеса',
    'business_name' => 'Название бизнеса',
    'created_at' => 'Создан',
    'contacts' => 'Контакты',
    'size_mb' => 'Размер (МБ)',
    'top_tables' => 'Топ таблиц',
    'data_populated_by_js' => 'Данные будут заполнены JavaScript',
    'loading_business_analytics' => 'Загрузка бизнес-аналитики...',
    'no_business_data_available' => 'Нет данных о бизнесе',
    'no_matching_businesses_found' => 'Совпадающие бизнесы не найдены',
    'failed_to_load_summary_data' => 'Не удалось загрузить сводные данные',
    'failed_to_load_table_data' => 'Не удалось загрузить табличные данные',
    'failed_to_load_business_analytics_data' => 'Не удалось загрузить данные бизнес-аналитики',

    // ABC Analysis
    'number_of_items' => 'Количество элементов',
    'value_percentage' => 'Процент стоимости',
    'abc_classification_distribution' => 'Распределение классификации ABC',
    'abc_value_distribution' => 'Распределение стоимости ABC',
    'analysis_value' => 'Стоимость анализа',
    'cumulative_percentage' => 'Накопительный процент',
    'pareto_analysis_top_contributing_products' => 'Анализ Парето - Топ товаров по вкладу',
    'no_classification_data_available_to_export' => 'Нет данных классификации для экспорта',
    'failed_to_load_abc_analysis_data' => 'Не удалось загрузить данные ABC анализа',
    'no_contribution_data_available' => 'Нет данных о вкладе',
    'no_classification_data_available' => 'Нет данных классификации',
    'no_contribution_analysis_data_available_to_export' => 'Нет данных анализа вклада для экспорта',
    'classification_data_exported_successfully' => 'Данные классификации успешно экспортированы!',
    'revenue_contribution_data_exported_successfully' => 'Данные вклада в доход успешно экспортированы!',

    // Customer Behavior Analytics (additional translations)
    'analyze_customer_purchase_patterns' => 'Анализ моделей покупок клиентов, предпочтений и удовлетворенности',
    'peak_hour' => 'Пиковый час',
    'busiest_time' => 'Самое загруженное время',
    'daily_purchase_patterns' => 'Ежедневные модели покупок',
    'hourly_purchase_distribution' => 'Почасовое распределение покупок',
    'seasonal_purchase_patterns' => 'Сезонные модели покупок',
    'category_preferences' => 'Предпочтения по категориям',
    'category_performance' => 'Производительность категорий',
    'revenue_percentage' => 'Доход %',
    'average_order_value_trends' => 'Тренды средней стоимости заказа',
    'customer_value_segments' => 'Сегменты стоимости клиентов',
    'customer_satisfaction_score' => 'Показатель удовлетворенности клиентов',
    'calculating' => 'Расчет...',
    'satisfaction_metrics' => 'Метрики удовлетворенности',
    'repeat_customer_rate' => 'Коэффициент повторных клиентов',
    'return_rate' => 'Коэффициент возвратов',
    'customer_retention' => 'Удержание клиентов',
    'avg_days_between' => 'Среднее дней между',
    'transaction_volume_by_hour' => 'Объем транзакций по часам',
    'failed_to_load_customer_behavior_analytics' => 'Не удалось загрузить аналитику поведения клиентов',

    // Customer Segmentation (additional translations)
    'rfm_analysis_geographic_distribution_vip_identification' => 'RFM анализ, географическое распределение и идентификация VIP клиентов',
    'repeat_rate' => 'коэффициент повторов',
    'geographic_reach' => 'Географический охват',
    'states' => 'регионов',
    'rfm_customer_segments' => 'Сегменты клиентов RFM',
    'vip_tier_distribution' => 'Распределение VIP уровней',
    'recency_distribution' => 'Распределение недавности',
    'frequency_distribution' => 'Распределение частоты',
    'monetary_distribution' => 'Денежное распределение',
    'state_wise_customer_distribution' => 'Распределение клиентов по регионам',
    'city_wise_revenue_distribution' => 'Распределение дохода по городам',
    'age_group_distribution' => 'Распределение по возрастным группам',
    'customer_type_distribution' => 'Распределение по типам клиентов',
    'purchase_behavior' => 'Поведение покупок',
    'top_vip_customers' => 'Топ VIP клиентов',
    'all_tiers' => 'Все уровни',
    'vip_tier' => 'VIP уровень',
    'vip_score' => 'VIP балл',
    'total_spent' => 'Всего потрачено',
    'last_purchase' => 'Последняя покупка',
    'vip_customers_populated_here' => 'VIP клиенты будут показаны здесь',

    // Inventory Turnover (additional translations)
    'stock_rotation_analysis_movement_classification' => 'Анализ ротации запасов, классификация движения и рекомендации по оптимальному запасу',
    'avg_turnover_ratio' => 'Средний коэффициент оборачиваемости',
    'units_per_day' => 'единиц/день',
    'dead_stock_items' => 'позиций мертвого запаса',
    'stock_movement_classification' => 'Классификация движения запасов',
    'inventory_aging' => 'Старение запасов',
    'category_movement_analysis' => 'Анализ движения категорий',
    'stock_level_recommendations' => 'Рекомендации по уровню запасов',
    'all_actions' => 'Все действия',
    'reduce_stock' => 'Уменьшить запас',
    'liquidate' => 'Ликвидировать',
    'maintain' => 'Поддерживать',
    'recommended_qty' => 'Рекомендуемое кол-во',
    'impact' => 'Влияние',
    'recommendations_populated_here' => 'Рекомендации будут показаны здесь',
    'top_performers_fast_moving' => 'Лучшие исполнители (быстро движущиеся)',
    'turnover' => 'Оборачиваемость',
    'top_performers_populated_here' => 'Лучшие исполнители будут показаны здесь',
    'worst_performers_dead_stock' => 'Худшие исполнители (мертвый запас)',
    'days_in_stock' => 'Дней в запасе',
    'last_sale' => 'Последняя продажа',
    'worst_performers_populated_here' => 'Худшие исполнители будут показаны здесь',
    'fast_moving_percentage' => 'Быстро движущиеся %',
    'no_fast_moving_products_found' => 'Быстро движущиеся товары не найдены',
    'no_dead_stock_found' => 'Мертвый запас не найден',

    // Recognition Settings
    'customer_recognition_settings' => 'Настройки признания клиентов',
    'configure_recognition_periods_scoring_preferences' => 'Настройка периодов признания, оценки и системных предпочтений',
    'general_settings' => 'Общие настройки',
    'module_start_date' => 'Дата начала модуля',
    'weekly_recognition' => 'Еженедельное признание',
    'monthly_recognition' => 'Ежемесячное признание',

    'export_catalog' => 'Экспорт каталога',
    'award_name' => 'Название награды',
    'product_link' => 'Ссылка на товар',
    'stock_status' => 'Статус запаса',
    'point_threshold' => 'Порог баллов',
    'actions' => 'Действия',
    'add_award_item' => 'Добавить элемент награды',

    // Additional Award Catalog translations
    'basic_information' => 'Основная информация',
    'monetary_value' => 'Денежная стоимость',
    'product_integration' => 'Интеграция товара',
    'link_to_product_optional' => 'Ссылка на товар (необязательно)',
    'requires_stock_management' => 'Требуется управление запасами',
    'current_image' => 'Текущее изображение',
    'confirm_deletion' => 'Подтвердите удаление',
    'are_you_sure_delete_award_item' => 'Вы уверены, что хотите удалить этот элемент награды?',
    'award_used_deactivated_instead_deleted' => 'Если эта награда использовалась в наградах клиентов, она будет деактивирована вместо удаления.',
    'eg_gift_voucher' => 'например, Подарочный сертификат на $50',
    'detailed_description_award' => 'Подробное описание награды...',
    'min_engagement_points_qualify' => 'Мин. баллов взаимодействия для квалификации',
    'stock_quantity' => 'Количество на складе',
    'award_image' => 'Изображение награды',

    'product_performance' => 'Производительность товаров',
    'expense_monthly_report' => 'Ежемесячный отчет по расходам',
    'sales_detail_filters' => 'Фильтры детальных продаж',
    'sales_detail_data' => 'Данные детальных продаж',
    'sales_detail_summary' => 'Сводка детальных продаж',

    // Daily Report Widget Labels
    'todays_sales' => 'Продажи сегодня',
    'todays_purchases' => 'Закупки сегодня',
    'todays_expenses' => 'Расходы сегодня',
    'todays_profit' => 'Прибыль сегодня',
    'todays_collections' => 'Сборы сегодня',

    // Daily Report Sections
    'sales_analysis' => 'Анализ продаж',
    'payment_methods_analysis' => 'Анализ способов оплаты',
    'expense_breakdown' => 'Разбивка расходов',
    'monthly_cash_flow_breakdown' => 'Ежемесячная разбивка денежного потока',

    // Common
    'date_format' => 'Формат: ДД/ММ/ГГГГ',
    'stock_health' => 'Здоровье запасов',
    'action' => 'Действие',
    'stock' => 'Запас',

    'purchases' => 'Закупки',
    'users' => 'Пользователи',
    'walk_in_customer' => 'Клиент без предварительной записи',
    'no_recommendations_available' => 'Рекомендации недоступны'



];
