<?php

return [
    // Module
    'advanced_reports_module' => 'Módulo de Informes Avanzados',
    'advanced_reports' => 'Informes Avanzados',
    'manage_advanced_reports' => 'Gestionar Informes Avanzados',
    'service_staff_not_enabled' => 'El módulo de Personal de Servicio no está habilitado. Por favor, habilite el módulo de Personal de Servicio en la Configuración del Negocio para usar los informes de Reconocimiento de Personal.',

    // Permissions
    'view_reports' => 'Ver Informes',
    'export_reports' => 'Exportar Informes',

    // Stock Report
    'stock_report' => 'Informe de Stock',
    'manage_stock_report' => 'Gestionar Informe de Stock',
    'current_stock' => 'Stock Actual',
    'stock_value_purchase' => 'Valor de Stock (Compra)',
    'stock_value_sale' => 'Valor de Stock (Venta)',
    'potential_profit' => 'Ganancia Potencial',
    'total_sold' => 'Total Vendido',
    'selling_price' => 'Precio de Venta',
    'total_products' => 'Total de Productos',
    'total_stock_quantity' => 'Cantidad Total de Stock',
    'show_zero_stock' => 'Mostrar Stock Cero',
    'out_of_stock' => 'Sin Stock',
    'low_stock' => 'Stock Bajo',
    'total_stock_value' => 'Valor Total de Stock',
    'product_info' => 'Información del Producto',
    'active' => 'Activo',
    'inactive' => 'Inactivo',
    'lot_number' => 'Número de Lote',

    // Sales Report
    'sales_report' => 'Informe de Ventas',
    'manage_sales_report' => 'Gestionar Informe de Ventas',
    'invoice_no' => 'N° de Factura',
    'transaction_date' => 'Fecha de Transacción',
    'customer_name' => 'Nombre del Cliente',
    'payment_status' => 'Estado de Pago',
    'total_before_tax' => 'Total Antes de Impuestos',
    'tax_amount' => 'Monto de Impuesto',
    'final_total' => 'Total Final',
    'total_paid' => 'Total Pagado',
    'balance_due' => 'Saldo Pendiente',
    'total_sales' => 'Ventas Totales',
    'average_sale' => 'Venta Promedio',
    'total_due' => 'Total Pendiente',

    // Product Report
    'product_report' => 'Informe de Ventas de Productos',

    // Pricing Optimization
    'pricing_optimization' => 'Optimización de Precios',
    'pricing_analytics_dashboard' => 'Panel de Análisis de Precios',
    'price_elasticity_analysis' => 'Análisis de Elasticidad de Precios',
    'competitor_price_analysis' => 'Análisis de Precios de Competencia',
    'discount_impact_analysis' => 'Análisis de Impacto de Descuentos',
    'dynamic_pricing_suggestions' => 'Sugerencias de Precios Dinámicos',
    'revenue_optimization' => 'Optimización de Ingresos',
    'average_margin' => 'Margen Promedio',
    'average_selling_price' => 'Precio de Venta Promedio',
    'current_price' => 'Precio Actual',
    'cost_price' => 'Precio de Costo',
    'suggested_price' => 'Precio Sugerido',
    'quantity_sold' => 'Cantidad Vendida',
    'velocity' => 'Velocidad',
    'elasticity_type' => 'Tipo de Elasticidad',
    'recommendation' => 'Recomendación',
    'our_price' => 'Nuestro Precio',
    'market_average' => 'Promedio del Mercado',
    'market_position' => 'Posición en el Mercado',
    'price_difference' => 'Diferencia de Precio',
    'competitiveness' => 'Competitividad',
    'discount_frequency' => 'Frecuencia de Descuento',
    'avg_discount_percent' => 'Descuento Promedio %',
    'discounted_sales' => 'Ventas con Descuento',
    'regular_sales' => 'Ventas Regulares',
    'effectiveness_score' => 'Puntuación de Efectividad',
    'price_change' => 'Cambio de Precio',
    'confidence' => 'Confianza',
    'reasoning' => 'Razonamiento',
    'revenue_impact' => 'Impacto en Ingresos',
    'products' => 'Productos',
    'optimization_score' => 'Puntuación de Optimización',

    // ABC Analysis
    'abc_analysis' => 'Análisis ABC',
    'abc_analysis_description' => 'Clasificar productos por valor y optimizar la asignación de recursos',
    'abc_analysis_dashboard' => 'Panel de Análisis ABC',
    'analysis_type' => 'Tipo de Análisis',
    'inventory_value' => 'Valor de Inventario',
    'sales_revenue' => 'Ingresos por Ventas',
    'hybrid_analysis' => 'Análisis Híbrido',
    'analyze' => 'Analizar',
    'a_grade_items' => 'Artículos Grado A',
    'b_grade_items' => 'Artículos Grado B',
    'c_grade_items' => 'Artículos Grado C',
    'total_analysis_value' => 'Valor Total de Análisis',
    'abc_distribution_chart' => 'Gráfico de Distribución ABC',
    'pareto_analysis' => 'Análisis de Pareto',
    'revenue_contribution_analysis' => 'Análisis de Contribución de Ingresos',
    'abc_grade' => 'Grado ABC',
    'item_count' => 'Cantidad de Artículos',
    'turnover_ratio' => 'Ratio de Rotación',
    'focus_strategy' => 'Estrategia de Enfoque',
    'management_approach' => 'Enfoque de Gestión',
    'resource_allocation_recommendations' => 'Recomendaciones de Asignación de Recursos',
    'detailed_product_classification' => 'Clasificación Detallada de Productos',
    'rank' => 'Rango',
    'variant_title' => 'Título de Variante',
    'variant_sku' => 'SKU de Variante',
    'ending_quantity' => 'Cantidad Final',
    'total_cost_value' => 'Valor Total de Costo',
    'total_selling_value' => 'Valor Total de Venta',
    'cumulative_percent' => '% Acumulativo',
    'manage_product_report' => 'Gestionar Informe de Ventas de Productos',
    'total_quantity_sold' => 'Cantidad Total Vendida',
    'total_amount_sold' => 'Monto Total Vendido',
    'profit_margin' => 'Margen de Ganancia',
    'top_selling_products' => 'Productos Más Vendidos',
    'slow_moving_products' => 'Productos de Movimiento Lento',

    // Price List
    'price_list' => 'Lista de Precios',
    'manage_price_list' => 'Gestionar Lista de Precios',
    'purchase_price' => 'Precio de Compra',
    'margin_percentage' => 'Margen %',
    'update_price' => 'Actualizar Precio',
    'bulk_update_prices' => 'Actualización Masiva de Precios',

    // Common
    'filters' => 'Filtros',
    'date_range' => 'Rango de Fechas',
    'location' => 'Ubicación',
    'category' => 'Categoría',
    'customer' => 'Cliente',
    'from_date' => 'Desde Fecha',
    'to_date' => 'Hasta Fecha',
    'apply_filter' => 'Aplicar Filtro',
    'clear_filter' => 'Limpiar Filtro',
    'export' => 'Exportar',
    'export_to_excel' => 'Exportar a Excel',
    'export_to_pdf' => 'Exportar a PDF',
    'export_to_csv' => 'Exportar a CSV',
    'print' => 'Imprimir',
    'refresh' => 'Actualizar',
    'search' => 'Buscar',
    'no_data_found' => 'No se encontraron datos',
    'loading' => 'Cargando...',

    // Summary
    'summary' => 'Resumen',
    'grand_total' => 'Total General',
    'totals' => 'Totales',
    'count' => 'Cantidad',

    // Messages
    'report_generated_successfully' => 'Informe generado exitosamente',
    'export_completed_successfully' => 'Exportación completada exitosamente',
    'no_records_found' => 'No se encontraron registros para los criterios seleccionados',
    'please_select_date_range' => 'Por favor seleccione un rango de fechas',
    'invalid_date_range' => 'Rango de fechas no válido seleccionado',
    'export_in_progress' => 'La exportación está en progreso, por favor espere...',
    'max_export_limit_exceeded' => 'Límite máximo de exportación excedido. Por favor refine sus filtros.',

    // Errors
    'error_generating_report' => 'Error al generar el informe',
    'error_exporting_data' => 'Error al exportar datos',
    'permission_denied' => 'Permiso denegado',
    'invalid_request' => 'Solicitud no válida',

    // Installation
    'install_success' => 'Módulo de Informes Avanzados instalado exitosamente',
    'update_success' => 'Módulo de Informes Avanzados actualizado exitosamente',
    'uninstall_success' => 'Módulo de Informes Avanzados desinstalado exitosamente',

    // Charts
    'sales_trend' => 'Tendencia de Ventas',
    'top_products' => 'Productos Principales',
    'sales_by_location' => 'Ventas por Ubicación',
    'sales_by_category' => 'Ventas por Categoría',
    'profit_analysis' => 'Análisis de Ganancias',

    // Advanced Features
    'schedule_report' => 'Programar Informe',
    'email_report' => 'Enviar Informe por Email',
    'save_filter' => 'Guardar Filtro',
    'load_saved_filter' => 'Cargar Filtro Guardado',
    'custom_columns' => 'Columnas Personalizadas',
    'group_by' => 'Agrupar Por',
    'sort_by' => 'Ordenar Por',
    'chart_view' => 'Vista de Gráfico',
    'table_view' => 'Vista de Tabla',

    // Time Periods
    'today' => 'Hoy',
    'yesterday' => 'Ayer',
    'this_week' => 'Esta Semana',
    'last_week' => 'Semana Pasada',
    'this_month' => 'Este Mes',
    'last_month' => 'Mes Pasado',
    'this_quarter' => 'Este Trimestre',
    'last_quarter' => 'Trimestre Pasado',
    'this_year' => 'Este Año',
    'last_year' => 'Año Pasado',
    'last_30_days' => 'Últimos 30 Días',
    'custom_range' => 'Rango Personalizado',

    'applying' => 'Aplicando',
    'apply_filters' => 'Aplicar Filtros',

    // Dashboard
    'dashboard' => 'Panel de Control',
    'key_metrics' => 'Métricas Clave',
    'recent_reports' => 'Informes Recientes',
    'quick_actions' => 'Acciones Rápidas',
    'generate_report' => 'Generar Informe',
    'view_all_reports' => 'Ver Todos los Informes',
    'report_center' => 'Centro de Informes',

    'all_categories' => 'Todas las Categorías',
    'filter' => 'Filtrar',

    // Sales Report entries
    'sales_details' => 'Detalles de Ventas',
    'total_transactions' => 'Total de Transacciones',
    'total_customers' => 'Total de Clientes',
    'customers' => 'Clientes',
    'product' => 'Producto',
    'total_customers_count' => 'Cantidad Total de Clientes',
    'total_products_count' => 'Cantidad Total de Productos',
    'total_sales_amount' => 'Monto Total de Ventas',
    'total_tax_amount' => 'Monto Total de Impuestos',
    'total_discount' => 'Descuento Total',
    'paid_transactions' => 'Monto Pagado',
    'paid_transactions_count' => 'Cantidad de Transacciones Pagadas',
    'total_paid_amount' => 'Monto Total Pagado',
    'due_transactions' => 'Monto Pendiente',
    'due_transactions_count' => 'Cantidad de Transacciones Pendientes',
    'total_due_amount' => 'Monto Total Pendiente',
    'invoice' => 'Factura',
    'invoices' => 'Facturas',
    'partial_transactions' => 'Transacciones Parciales',
    'paid_amount' => 'Monto Pagado',
    'due_amount' => 'Monto Pendiente',
    'transaction_info' => 'Información de Transacción',
    'created_by' => 'Creado Por',
    'view_full_invoice' => 'Ver Factura Completa',

    // Additional entries that might be useful
    'sales_summary' => 'Resumen de Ventas',
    'payment_summary' => 'Resumen de Pagos',
    'customer_info' => 'Información del Cliente',
    'sales_performance' => 'Rendimiento de Ventas',
    'daily_sales' => 'Ventas Diarias',
    'monthly_sales' => 'Ventas Mensuales',
    'yearly_sales' => 'Ventas Anuales',
    'top_customers' => 'Principales Clientes',
    'sales_by_payment_method' => 'Ventas por Método de Pago',
    'average_transaction_value' => 'Valor Promedio de Transacción',
    'total_transactions_today' => 'Total de Transacciones Hoy',
    'sales_growth' => 'Crecimiento de Ventas',
    'revenue_analysis' => 'Análisis de Ingresos',

    // Filter related
    'filter_by_date' => 'Filtrar por Fecha',
    'filter_by_customer' => 'Filtrar por Cliente',
    'filter_by_location' => 'Filtrar por Ubicación',
    'filter_by_payment_status' => 'Filtrar por Estado de Pago',
    'filter_by_payment_method' => 'Filtrar por Método de Pago',
    'select_date_range' => 'Seleccionar Rango de Fechas',
    'all_customers' => 'Todos los Clientes',
    'all_locations' => 'Todas las Ubicaciones',
    'all_payment_methods' => 'Todos los Métodos de Pago',
    'all_statuses' => 'Todos los Estados',

    // Export related
    'export_sales_report' => 'Exportar Informe de Ventas',
    'sales_report_exported' => 'El informe de ventas ha sido exportado exitosamente',
    'export_failed' => 'La exportación falló. Por favor, inténtelo de nuevo.',

    // Status messages
    'no_sales_found' => 'No se encontraron ventas para los criterios seleccionados',
    'loading_sales_data' => 'Cargando datos de ventas...',
    'sales_data_loaded' => 'Datos de ventas cargados exitosamente',
    'error_loading_sales' => 'Error al cargar datos de ventas',

    // Validation messages
    'date_range_too_large' => 'El rango de fechas es demasiado grande. Por favor seleccione un rango menor.',
    'no_data_available' => 'No hay datos disponibles para los filtros seleccionados',

    // Performance metrics
    'growth_rate' => 'Tasa de Crecimiento',
    'conversion_rate' => 'Tasa de Conversión',
    'repeat_customers' => 'Clientes Recurrentes',
    'new_customers' => 'Nuevos Clientes',
    'average_order_value' => 'Valor Promedio de Pedido',
    'total_orders' => 'Total de Pedidos',
    'orders_per_customer' => 'Pedidos por Cliente',

    // Additional useful phrases
    'view_details' => 'Ver Detalles',
    'hide_details' => 'Ocultar Detalles',
    'expand_all' => 'Expandir Todo',
    'collapse_all' => 'Contraer Todo',
    'refresh_data' => 'Actualizar Datos',
    'last_updated' => 'Última Actualización',
    'auto_refresh' => 'Actualización Automática',
    'manual_refresh' => 'Actualización Manual',
    'data_as_of' => 'Datos al',
    'real_time_data' => 'Datos en Tiempo Real',

    // Chart/Graph related
    'bar_chart' => 'Gráfico de Barras',
    'line_chart' => 'Gráfico de Líneas',
    'pie_chart' => 'Gráfico Circular',
    'show_chart' => 'Mostrar Gráfico',
    'hide_chart' => 'Ocultar Gráfico',

    // Comparison related
    'compare_periods' => 'Comparar Períodos',
    'previous_period' => 'Período Anterior',
    'same_period_last_year' => 'Mismo Período Año Pasado',
    'percentage_change' => 'Cambio Porcentual',
    'absolute_change' => 'Cambio Absoluto',
    'trend_analysis' => 'Análisis de Tendencias',

    // Due Collections Analysis
    'due_collections_analysis' => 'Análisis de Cobranzas Pendientes',
    'collected_today' => 'Cobrado Hoy',
    'pending_due_today' => 'Pendiente Hoy',
    'overdue_amounts' => 'Montos Vencidos',
    'due_payments_received' => 'Pagos pendientes recibidos hoy',
    'todays_unpaid_sales' => 'Ventas sin pagar de hoy',
    'previous_days_unpaid' => 'Días anteriores sin pagar',
    'cash_collected_today' => 'Efectivo Cobrado Hoy',
    'due_collection_cash' => 'Efectivo de Cobranza',
    'total_due_collected' => 'Total Pendiente Cobrado',
    'total_pending_due' => 'Total Pendiente',
    'total_overdue' => 'Total Vencido',
    'due_collection_summary' => 'Resumen de Cobranzas',
    'payment_collection_status' => 'Estado de Cobranza de Pagos',
    'outstanding_receivables' => 'Cuentas por Cobrar Pendientes',
    'receivables_aging' => 'Antigüedad de Cuentas por Cobrar',
    'collection_efficiency' => 'Eficiencia de Cobranza',
    'overdue_analysis' => 'Análisis de Vencidos',
    'aging_report' => 'Informe de Antigüedad',
    'collection_report' => 'Informe de Cobranza',
    'cash_flow_analysis' => 'Análisis de Flujo de Efectivo',
    'payment_trends' => 'Tendencias de Pago',
    'due_follow_up' => 'Seguimiento de Pendientes',
    'collection_alerts' => 'Alertas de Cobranza',
    'payment_reminders' => 'Recordatorios de Pago',
    'credit_management' => 'Gestión de Crédito',
    'customer_payment_history' => 'Historial de Pagos del Cliente',
    'payment_performance' => 'Rendimiento de Pagos',

    // sales_detail_report
    'sales_detail_report' => 'Informe Detallado de Ventas',
    'gst_sales_report' => 'Informe de Ventas GST',
    'gst_purchase_report' => 'Informe de Compras GST',
    'operations_summary_report' => 'Informe Resumen de Operaciones',
    'daily_summary_report' => 'Informe Resumen Diario',
    'daily_report' => 'Informe Diario',
    'manage_gst_sales_report' => 'Gestionar Informe de Ventas GST',
    'total_tax' => 'Impuesto Total',
    'taxable_amount' => 'Monto Imponible',
    'avg_tax_rate' => 'Tasa de Impuesto Promedio',
    'taxable_value' => 'Valor Imponible',
    'today_sales' => 'Ventas de Hoy',
    'today_purchases' => 'Compras de Hoy',
    'today_expenses' => 'Gastos de Hoy',
    'net_profit' => 'Ganancia Neta',
    'cash_in_hand' => 'Efectivo en Mano',
    'purchase_summary' => 'Resumen de Compras',
    'expense_summary' => 'Resumen de Gastos',
    'payment_methods_summary' => 'Resumen de Métodos de Pago',
    'payment_method' => 'Método de Pago',
    'transaction_count' => 'Cantidad de Transacciones',
    'total_amount' => 'Monto Total',
    'manage_daily_summary' => 'Gestionar Resumen Diario',
    'total_purchases' => 'Compras Totales',
    'total_expenses' => 'Gastos Totales',
    'avg_daily_sales' => 'Ventas Diarias Promedio',
    'profitable_days' => 'Días Rentables',
    'day' => 'Día',
    'sales_count' => 'Cantidad de Ventas',
    'purchase_count' => 'Cantidad de Compras',
    'expense_count' => 'Cantidad de Gastos',
    'cash_received' => 'Efectivo Recibido',
    'card_received' => 'Tarjeta Recibida',

    'comprehensive_daily_overview' => 'Resumen Diario Completo',
    'today_profit' => 'Ganancia de Hoy',
    'bank_balance' => 'Saldo Bancario',
    'customer_due' => 'Pendiente de Cliente',
    'supplier_due' => 'Pendiente de Proveedor',
    'today_collections' => 'Cobranzas de Hoy',
    'net_worth' => 'Patrimonio Neto',
    'todays_activity' => 'Actividad de Hoy',
    'financial_snapshot' => 'Fotografía Financiera',
    'avg_transaction_value' => 'Valor Promedio de Transacción',
    'gross_profit_margin' => 'Margen de Ganancia Bruta',
    'opening_balance' => 'Saldo de Apertura',
    'closing_balance' => 'Saldo de Cierre',
    'cash_flow' => 'Flujo de Efectivo',
    'liquidity_ratio' => 'Ratio de Liquidez',
    'detailed_breakdown' => 'Desglose Detallado',
    'manage_operations_summary' => 'Gestionar Resumen de Operaciones',
    'report_date' => 'Fecha del Informe',

    'gst_sales_by_products' => 'Ventas GST por Productos',
    'gst_sales_by_invoice' => 'Ventas GST por Factura',

    // Stock report specific translations
    'total_stock_purchase_value' => 'Valor Total de Compra de Stock',
    'total_stock_sales_value' => 'Valor Total de Venta de Stock',

    // General UI translations for Advanced Reports module
    'stock_need_only' => 'Solo Necesidad de Stock',
    'stock_need' => 'Necesidad de Stock',
    'expected_stock' => 'Stock Esperado',
    'expired_stock' => 'Stock Vencido',
    'critical_items' => 'Artículos Críticos',
    'total_current_stock' => 'Stock Actual Total',
    'total_stock_needed' => 'Stock Total Necesario',
    'coverage_ratio' => 'Ratio de Cobertura',
    'processing' => 'Procesando',
    'table_not_found' => 'Tabla no encontrada',
    'no_data_available_print' => 'No hay datos disponibles para imprimir',
    'popup_blocked' => 'Ventana emergente bloqueada por el navegador. Por favor permita ventanas emergentes para este sitio.',
    'generated_on' => 'Generado el',
    'at' => 'a las',
    'printed_on' => 'Impreso el',
    'generated_by' => 'Generado por',
    'system_generated_report' => 'Este es un informe generado por el sistema',
    'select_date' => 'Seleccionar Fecha',
    'select_location' => 'Seleccionar Ubicación',

    // Expiry report translations
    'expiry_report' => 'Informe de Vencimiento',
    'expiry_filters' => 'Filtros de Vencimiento',
    'expiry_status' => 'Estado de Vencimiento',
    'all' => 'Todos',
    'expired' => 'Vencido',
    'expiring_in_7_days' => 'Vence en 7 Días',
    'expiring_in_30_days' => 'Vence en 30 Días',
    'expiring_in_90_days' => 'Vence en 90 Días',
    'expired_products' => 'Productos Vencidos',
    'total_expiry_value' => 'Valor Total de Vencimiento',
    'stock_expiry_report' => 'Informe de Vencimiento de Stock',
    'days_to_expire' => 'Días para Vencer',
    'stock_value' => 'Valor de Stock',
    'days_expired' => 'días vencido',
    'days_left' => 'días restantes',
    'critical' => 'Crítico',
    'warning' => 'Advertencia',
    'good' => 'Bueno',
    'remove_from_stock' => 'Remover del Stock',

    // Enhanced expiry alert translations
    'expiring_soon' => 'Vence Pronto',
    'total_items' => 'Total de Artículos',
    'alert_value' => 'Valor de Alerta',
    'days_ahead' => 'Días por Delante',
    'next_7_days' => 'Próximos 7 Días',
    'next_15_days' => 'Próximos 15 Días',
    'next_30_days' => 'Próximos 30 Días',
    'next_60_days' => 'Próximos 60 Días',
    'next_90_days' => 'Próximos 90 Días',
    'days_overdue' => 'días de retraso',
    'expires_today' => 'Vence Hoy',
    'status' => 'Estado',
    'expiry_date' => 'Fecha de Vencimiento',

    'invoice_subtotal' => 'Subtotal de Factura',
    'line_discount' => 'Descuento de Línea',
    'invoice_discount' => 'Descuento de Factura',

    // Customer Monthly Sales Report
    'customer_monthly_sales_report' => 'Informe Mensual de Ventas por Cliente',
    'manage_customer_monthly_sales' => 'Gestionar Ventas Mensuales por Cliente',
    'customer_monthly_analysis' => 'Análisis Mensual de Clientes',
    'monthly_breakdown' => 'Desglose Mensual',
    'gross_profit_amount' => 'Ganancia Bruta ($)',
    'gross_profit_percentage' => 'Ganancia Bruta (%)',
    'avg_per_customer' => 'Promedio por Cliente',
    'customer_details' => 'Detalles del Cliente',
    'customer_information' => 'Información del Cliente',
    'recent_transactions' => 'Transacciones Recientes',
    'monthly_sales_analysis' => 'Análisis de Ventas Mensuales',
    'year_summary' => 'Resumen del Año',
    'search_by_name' => 'Buscar por nombre...',
    'staff' => 'Personal',

    'gross_profit' => 'Ganancia Bruta',

    // Months (if not already present)
    'january' => 'Enero',
    'february' => 'Febrero',
    'march' => 'Marzo',
    'april' => 'Abril',
    'may' => 'Mayo',
    'june' => 'Junio',
    'july' => 'Julio',
    'august' => 'Agosto',
    'september' => 'Septiembre',
    'october' => 'Octubre',
    'november' => 'Noviembre',
    'december' => 'Diciembre',

    // Short months
    'jan' => 'Ene',
    'feb' => 'Feb',
    'mar' => 'Mar',
    'apr' => 'Abr',
    'jun' => 'Jun',
    'jul' => 'Jul',
    'aug' => 'Ago',
    'sep' => 'Sep',
    'oct' => 'Oct',
    'nov' => 'Nov',
    'dec' => 'Dic',

    'product_performance_report' => 'Informe de Rendimiento de Productos',
    'manage_product_performance' => 'Gestionar Rendimiento de Productos',
    'product_performance_analysis' => 'Análisis de Rendimiento de Productos',
    'product_details' => 'Detalles del Producto',

    // ======================================
    // ADDITIONAL KEYS FOR PRODUCT PERFORMANCE & SALES DETAIL REPORTS
    // Add these to your existing lang file
    // ======================================

    // Date & Time
    'start_date' => 'Fecha de Inicio',
    'end_date' => 'Fecha de Fin',
    'week' => 'Semana',
    'week_number' => 'Número de Semana',
    'day_number' => 'Número de Día',
    'sales_date' => 'Fecha de Venta',

    // Week Options
    'all_weeks' => 'Todas las Semanas',
    'week_1' => 'Semana 1',
    'week_2' => 'Semana 2',
    'week_3' => 'Semana 3',
    'week_4' => 'Semana 4',
    'week_5' => 'Semana 5',
    'weekly_totals' => 'TOTALES SEMANALES',

    // Filter Options (Additional)
    'all_groups' => 'Todos los Grupos',
    'all_brands' => 'Todas las Marcas',
    'all_units' => 'Todas las Unidades',
    'all_users' => 'Todos los Usuarios',
    'all_staff' => 'Todo el Personal',
    'all_methods' => 'Todos los Métodos',

    // Report Sections
    'top_performing_products' => 'Productos de Mejor Rendimiento',
    'weekly_sales_summary_report' => 'Informe Resumen Semanal de Ventas',
    'staff_performance_analysis' => 'Análisis de Rendimiento del Personal',
    'stock_valuation' => 'Valoración de Stock',

    // Sales Detail Columns
    'sales_unit' => 'Unidad de Venta',
    'qty_sold' => 'Cantidad Vendida',
    'total_sales_amt' => 'Monto Total de Ventas',
    'total_purchase_amt' => 'Monto Total de Compras',
    'profit_earned' => 'Ganancia Obtenida',
    'margin_percent' => '% Margen',
    'total_purchase' => 'Compra Total',
    'total_profit' => 'Ganancia Total',

    // Messages & Status
    'no_sales_data_found' => 'No se encontraron datos de ventas para los criterios seleccionados.',
    'error_loading_sales_data' => 'Error al cargar datos de ventas. Por favor, inténtelo de nuevo.',
    'report_refreshed_successfully' => 'Informe actualizado exitosamente',
    'sales_detail_report_loaded' => 'Informe Detallado de Ventas cargado exitosamente',
    'auto_refresh_5_min' => 'Actualización automática (5 min)',
    'clearing' => 'Limpiando...',
    'clear' => 'Limpiar',
    'search_by_brand_name' => 'Buscar por nombre de marca...',
    'brand_monthly_sales_report' => 'Informe Mensual de Ventas por Marca',
    'view_brand_sales_by_months_with_profit_analysis' => 'Ver ventas de marca por meses con análisis de ganancias',

    'total_qty' => 'Cantidad Total',
    'advanced_filters' => 'Filtros Avanzados',
    'min_amount' => 'Monto Mínimo',
    'max_amount' => 'Monto Máximo',

    'itemwise_sales_report' => 'Informe de Ventas por Artículo',
    'itemwise_sales_subtitle' => 'Análisis detallado de ventas por artículos de producto',
    'itemwise_sales_filters' => 'Filtros de Informe de Ventas por Artículo',
    'product_name_sku' => 'Nombre de Producto/SKU',
    'customer_name_mobile' => 'Nombre de Cliente/Móvil',
    'clear_all_filters' => 'Limpiar Todos los Filtros',
    'quick_date_filters' => 'Filtros de Fecha Rápidos:',
    'clear_date' => 'Limpiar Fecha',
    'unique_customers' => 'Clientes Únicos',
    'products_sold' => 'Productos Vendidos',
    'total_qty_sold' => 'Cantidad Total Vendida',
    'detailed_view' => 'Vista Detallada',
    'applied_filters' => 'Filtros Aplicados',
    'date_range_label' => 'Rango de Fechas:',
    'location_label' => 'Ubicación:',
    'customer_label' => 'Cliente:',
    'category_label' => 'Categoría:',
    'brand_label' => 'Marca:',
    'report_summary' => 'Resumen del Informe',
    'date' => 'Fecha',
    'brand' => 'Marca',
    'qty' => 'Cant',
    'unit_price' => 'Precio Unitario',
    'tax_percent' => 'Impuesto %',
    'subtotal' => 'Subtotal',
    'total' => 'Total',
    'report_details' => 'Detalles del Informe:',
    'total_records' => 'Registros Totales:',
    'report_period' => 'Período del Informe:',
    'business_information' => 'Información del Negocio:',
    'tax_number' => 'Número de Impuesto:',
    'printed_by' => 'Impreso por:',
    'print_report' => 'Imprimir Informe',
    'close' => 'Cerrar',
    'all_dates' => 'Todas las Fechas',
    'purchase_cost' => 'Costo de Compra',

    'weekly_monthly_yearly_customer_awards' => 'Premios y Reconocimiento de Clientes Semanal / Mensual / Anual',
    'customer_recognition_system' => 'Sistema de Reconocimiento de Clientes',
    'recognition_filters_controls' => 'Filtros y Controles de Reconocimiento',
    'period_type' => 'Tipo de Período',
    'winner_count' => 'Cantidad de Ganadores',
    'finalize_period' => 'Finalizar Período',
    'record_engagement' => 'Registrar Compromiso',
    'current_period_winners' => 'Ganadores del Período Actual',
    'weekly_winner' => 'Ganador Semanal',
    'monthly_winner' => 'Ganador Mensual',
    'yearly_winner' => 'Ganador Anual',
    'total_participants' => 'Total de Participantes',
    'engagement_points' => 'Puntos de Compromiso',
    'average_score' => 'Puntuación Promedio',
    'top_score' => 'Puntuación Máxima',
    'avg_transaction' => 'Transacción Prom.',
    'customer_rankings' => 'Clasificaciones y Reconocimiento de Clientes',
    'sales_total' => 'Total de Ventas',
    'transactions' => 'Transacciones',
    'final_score' =>  'Puntuación Final',
    'customer_recognition_details' => 'Detalles de Reconocimiento del Cliente',
    'loading_customer_details' => 'Cargando detalles del cliente...',
    'award_customer' => 'Premiar Cliente',
    'award_type' => 'Tipo de Premio',
    'select_award_type' => 'Seleccionar Tipo de Premio',
    'manual_entry' => 'Entrada Manual',
    'from_catalog' => 'Del Catálogo',
    'gift_description' => 'Descripción del Regalo',
    'select_gift_from_catalog' => 'Seleccionar Regalo del Catálogo',
    'loading_catalog' => 'Cargando catálogo...',
    'additional_notes_about_award' => 'Notas adicionales sobre este premio...',
    'record_customer_engagement' => 'Registrar Compromiso del Cliente',
    'engagement_type' => 'Tipo de Compromiso',
    'select_type' => 'Seleccionar Tipo',
    'youtube_follow' => 'Seguir/Suscribirse en YouTube',
    'facebook_follow' => 'Seguir/Me Gusta en Facebook',
    'instagram_follow' => 'Seguir en Instagram',
    'twitter_follow' => 'Seguir en Twitter',
    'content_share' => 'Compartir Contenido',
    'review_testimonial' => 'Reseña/Testimonio',
    'google_review' => 'Reseña de Google',
    'customer_referral' => 'Referido de Cliente',
    'points' => 'Puntos',
    'platform' => 'Plataforma',
    'reference_url' => 'URL de Referencia',
    'verification_notes' => 'Notas de Verificación',
    'describe_verification_notes' => 'Describa cómo se verificó este compromiso...',
    'finalize_period_rankings' => 'Finalizar Clasificaciones del Período',
    'message_warning_finalized1' => 'Una vez finalizado, las clasificaciones de este período no se pueden cambiar.',
    'message_warning_finalized2' => 'Esto bloqueará los ganadores actuales y le permitirá premiarlos.',
    'period' => 'Período',
    'winners_count' => 'Cantidad de Ganadores',
    'quantity' => 'Cantidad',
    'customer_engagements' => 'Compromisos de Clientes',
    'recorded_by' => 'Registrado Por',
    'recorded_date' => 'Fecha de Registro',
    'no_customer_engagements_found' => 'No se encontraron compromisos de clientes',

    // Service Staff Recognition
    'service_staff_recognition_system' => 'Sistema de Reconocimiento del Personal de Servicio',
    'weekly_monthly_yearly_staff_awards' => 'Premios y Reconocimiento del Personal Semanal / Mensual / Anual',
    'staff_rankings' => 'Clasificaciones y Reconocimiento del Personal',
    'staff_name' => 'Nombre del Personal',
    'performance_points' => 'Puntos de Rendimiento',
    'performance_activities' => 'Actividades de Rend.',
    'activity_type' => 'Tipo de Actividad',
    'description' => 'Descripción',
    'total_staff' => 'Total de Personal',
    'top_performer' => 'Mejor Rendimiento',
    'average_performance' => 'Rendimiento Promedio',
    'total_activities' => 'Total de Actividades',
    'award_staff' => 'Premiar Personal',
    'record_performance_activity' => 'Registrar Actividad de Rendimiento',
    'record_activity' => 'Registrar Actividad',
    'staff_member' => 'Miembro del Personal',
    'punctuality' => 'Puntualidad',
    'customer_service_excellence' => 'Excelencia en Servicio al Cliente',
    'upselling_success' => 'Éxito en Ventas Adicionales',
    'teamwork' => 'Trabajo en Equipo',
    'training_completion' => 'Finalización de Capacitación',
    'cleanliness_organization' => 'Limpieza y Organización',
    'other' => 'Otro',
    'no_performance_activities_found' => 'No se encontraron actividades de rendimiento',

    'weekly' => 'Semanal',
    'monthly' => 'Mensual',
    'yearly' => 'Anual',

    'weekly_top_performer' => 'Mejor Rendimiento Semanal',
    'monthly_top_performer' => 'Mejor Rendimiento Mensual',
    'yearly_top_performer' => 'Mejor Rendimiento Anual',

    'current_period_top_performers' => 'Mejores Rendimientos del Período Actual',
    'current_period_top_performer' => 'Mejor Rendimiento del Período Actual',
    'top_performer_score' => 'Puntuación del Mejor Rendimiento',
    'demand_forecasting' => 'Pronóstico de Demanda',
    'demand_forecasting_report' => 'Pronóstico de Demanda',
    'historical_period' => 'Período Histórico',
    'forecast_period' => 'Período de Pronóstico',
    '3_months' => '3 Meses',
    '6_months' => '6 Meses',
    '12_months' => '12 Meses',
    'sales_prediction_subtitle' => 'Predicción de Ventas, Patrones Estacionales y Prevención de Agotamiento',
    'forecasted_demand' => 'Demanda Pronosticada',
    'historical_demand' => 'Demanda Histórica',
    'forecasted_period' => 'Período Pronosticado',
    'generate_forecast' => 'Generar Pronóstico',
    'products_analyzed' => 'Productos Analizados',
    'stockout_alerts' => 'Alertas de Agotamiento',
    'reorder_required' => 'Reorden Requerido',
    'all_alerts' => 'Todas las Alertas',
    'high' => 'Alto',
    'medium' => 'Medio',
    'low' => 'Bajo',
    'daily_demand' => 'Demanda Diaria',
    'days_of_supply' => 'Días de Suministro',
    'alert_level' => 'Nivel de Alerta',
    'estimated_stockout' => 'Agotamiento Estimado',
    'recommended_action' => 'Acción Recomendada',
    'select_product' => 'Seleccionar Producto',
    'historical' => 'Histórico',
    'forecast' => 'Pronóstico',
    'combined' => 'Combinado',
    'all_products' => 'Todos los Productos',
    'reorder_now' => 'Reordenar Ahora',
    'monitor_closely' => 'Monitorear de Cerca',
    'overstocked' => 'Sobreabastecido',
    'optimal' => 'Óptimo',
    'reorder_point' => 'Punto de Reorden',
    'eoq' => 'CEP',
    'priority' => 'Prioridad',
    'trend' => 'Tendencia',
    'volatility' => 'Volatilidad',

    // Section titles
    'critical_stockout_alerts' => 'Alertas Críticas de Agotamiento',
    'demand_forecast_visualization' => 'Visualización de Pronóstico de Demanda',
    'seasonal_patterns' => 'Patrones Estacionales',
    'forecasting_methods_comparison' => 'Comparación de Métodos de Pronóstico',
    'demand_confidence_levels' => 'Niveles de Confianza de Demanda',
    'reorder_point_optimization' => 'Optimización del Punto de Reorden',
    'highest_forecasted_demand' => 'Mayor Demanda Pronosticada',
    'most_volatile_demand' => 'Demanda Más Volátil',

    // Table headers
    'forecasting_methods' => 'Métodos de Pronóstico',

    // Messages and labels
    'no_critical_alerts_found' => 'No se encontraron alertas críticas',
    'next_months' => 'Próximos',
    'months' => 'meses',
    'select_product_option' => 'Seleccionar Producto',
    'forecasting_methods_labels' => 'MA Simple, Tendencia Lineal, Exponencial, Estacional, Combinado',
    'forecasting_methods_comparison_title' => 'Comparación de Métodos de Pronóstico',
    'forecast_confidence_distribution_title' => 'Distribución de Confianza del Pronóstico',
    'export_image' => 'Exportar como Imagen',

    // Waste & Loss Analysis
    'waste_loss_analysis_report' => 'Análisis de Desperdicio y Pérdida',
    'waste_loss_subtitle' => 'Productos Vencidos, Bienes Dañados, Robo y Prevención de Pérdidas',
    'analysis_period' => 'Período de Análisis',
    'analyze_waste_loss' => 'Analizar Desperdicio y Pérdida',
    'damaged_goods' => 'Bienes Dañados',
    'theft_shrinkage' => 'Robo y Merma',
    'total_loss' => 'Pérdida Total',
    'loss_trends' => 'Tendencias de Pérdida',
    'loss_breakdown' => 'Desglose de Pérdidas',
    'expired_products_analysis' => 'Análisis de Productos Vencidos',
    'damaged_goods_analysis' => 'Análisis de Bienes Dañados',
    'theft_shrinkage_analysis' => 'Análisis de Robo y Merma',
    'loss_prevention_insights' => 'Conocimientos de Prevención de Pérdidas',
    'expiry_categories' => 'Categorías de Vencimiento',
    'upcoming_expirations' => 'Próximos Vencimientos',
    'expired_today' => 'Vencido Hoy',
    'expired_this_week' => 'Vencido Esta Semana',
    'expired_this_month' => 'Vencido Este Mes',
    'all_expired' => 'Todos Vencidos',
    'days_remaining' => 'Días Restantes',
    'loss_value' => 'Valor de Pérdida',
    'damage_date' => 'Fecha de Daño',
    'reason' => 'Razón',
    'damage_summary' => 'Resumen de Daños',
    'physical_damage' => 'Daño Físico',
    'spoilage' => 'Deterioro',
    'shrinkage_rate' => 'Tasa de Merma',
    'high_risk_products' => 'Productos de Alto Riesgo',
    'incidents' => 'Incidentes',
    'quantity_lost' => 'Cantidad Perdida',
    'value_lost' => 'Valor Perdido',
    'top_loss_categories' => 'Principales Categorías de Pérdida',
    'loss_by_location' => 'Pérdida por Ubicación',
    'recommendations' => 'Recomendaciones',
    'total_loss_value' => 'Valor Total de Pérdida',
    'incident_count' => 'Cantidad de Incidentes',
    'supplier' => 'Proveedor',
    'last_3_months' => 'Últimos 3 Meses',
    'last_6_months' => 'Últimos 6 Meses',
    'no_expired_products' => 'No se encontraron productos vencidos',
    'no_upcoming_expirations' => 'No hay próximos vencimientos',
    'no_damaged_goods' => 'No se encontraron bienes dañados',
    'no_high_risk_products' => 'No se identificaron productos de alto riesgo',
    'no_recommendations' => 'No hay recomendaciones disponibles',
    'no_chart_available' => 'No hay gráfico disponible para exportar',

    'value' => 'Valor',

    // Location Performance Report
    'location_performance_report' => 'Rendimiento de Tienda/Ubicación',
    'manage_location_performance' => 'Gestionar Rendimiento de Tienda/Ubicación',
    'location_performance_analytics' => 'Análisis de Rendimiento de Ubicación',
    'multi_location_analysis' => 'Análisis de Múltiples Ubicaciones',
    'location_sales_comparison' => 'Comparación de Ventas por Ubicación',
    'performance_benchmarks' => 'Referencias de Rendimiento',
    'regional_sales_analysis' => 'Análisis de Ventas Regionales',
    'location_profitability' => 'Rentabilidad por Ubicación',
    'location_comparison' => 'Comparación de Ubicaciones',
    'benchmarking_analysis' => 'Análisis de Benchmarking',
    'profitability_analysis' => 'Análisis de Rentabilidad',
    'performance_trends' => 'Tendencias de Rendimiento',
    'staff_performance' => 'Rendimiento del Personal',
    'performance_score' => 'Puntuación de Rendimiento',
    'revenue_per_location' => 'Ingresos por Ubicación',
    'transactions_per_location' => 'Transacciones por Ubicación',
    'profit_per_location' => 'Ganancia por Ubicación',
    'top_performing_locations' => 'Ubicaciones de Mejor Rendimiento',
    'underperforming_locations' => 'Ubicaciones de Bajo Rendimiento',
    'location_efficiency' => 'Eficiencia de Ubicación',
    'regional_market_share' => 'Cuota de Mercado Regional',
    'location_roi' => 'ROI de Ubicación',
    'operating_expenses' => 'Gastos Operativos',
    'net_profit_margin' => 'Margen de Ganancia Neta',
    'performance_indicators' => 'Indicadores de Rendimiento',
    'location_overview' => 'Resumen de Ubicación',
    'compare_period' => 'Comparar Período',
    'benchmark_metrics' => 'Métricas de Referencia',
    'revenue_growth' => 'Crecimiento de Ingresos',
    'profit_growth' => 'Crecimiento de Ganancias',
    'efficiency_score' => 'Puntuación de Eficiencia',
    'top_performers' => 'Mejores Rendimientos',
    'bottom_performers' => 'Peores Rendimientos',
    'location_ranking' => 'Clasificación de Ubicación',
    'performance_rating' => 'Calificación de Rendimiento',
    'excellent' => 'Excelente',
    'average' => 'Promedio',
    'poor' => 'Pobre',
    'staff_productivity' => 'Productividad del Personal',
    'sales_per_staff' => 'Ventas por Personal',
    'avg_transaction_per_staff' => 'Transacción Prom. por Personal',
    'staff_efficiency' => 'Eficiencia del Personal',
    'location_insights' => 'Conocimientos de Ubicación',
    'performance_summary' => 'Resumen de Rendimiento',
    'kpi_dashboard' => 'Panel de KPI',
    'operational_metrics' => 'Métricas Operativas',

    'locations' => 'Ubicaciones',
    'compare_with' => 'Comparar Con',
    'compare' => 'Comparar',

    // Additional Location Performance translations
    'transaction_growth' => 'Crecimiento de Transacciones',
    'customer_growth' => 'Crecimiento de Clientes',
    'avg_transaction_growth' => 'Crecimiento de Transacción Prom.',
    'profit_margin_change' => 'Cambio de Margen de Ganancia',
    'current_period' => 'Período Actual',
    'benchmark_period' => 'Período de Referencia',
    'regional_summary' => 'Resumen Regional',
    'top_regions' => 'Principales Regiones',
    'market_share' => 'Cuota de Mercado',
    'regional_trends' => 'Tendencias Regionales',
    'location_count' => 'Cantidad de Ubicaciones',
    'regional_sales' => 'Ventas Regionales',
    'regional_transactions' => 'Transacciones Regionales',
    'regional_customers' => 'Clientes Regionales',
    'avg_per_location' => 'Promedio por Ubicación',
    'region' => 'Región',
    'profitability_ranking' => 'Clasificación de Rentabilidad',
    'average_metrics' => 'Métricas Promedio',
    'avg_gross_profit_margin' => 'Margen de Ganancia Bruta Prom.',
    'avg_net_profit_margin' => 'Margen de Ganancia Neta Prom.',
    'avg_roi' => 'ROI Promedio',
    'cogs' => 'COGS',
    'expenses' => 'Gastos',
    'revenue' => 'Ingresos',
    'customers_served' => 'Clientes Atendidos',
    'avg_sale_value' => 'Valor de Venta Prom.',
    'staff_id' => 'ID de Personal',
    'trends' => 'Tendencias',
    'comparison_type' => 'Tipo de Comparación',
    'period_info' => 'Información del Período',
    'benchmarks' => 'Referencias',
    'location_profitability_analysis' => 'Análisis de Rentabilidad por Ubicación',
    'staff_performance_by_location' => 'Rendimiento del Personal por Ubicación',
    'performance_trends_analysis' => 'Análisis de Tendencias de Rendimiento',
    'regional_market_analysis' => 'Análisis de Mercado Regional',
    'benchmark_analysis' => 'Análisis de Referencia',
    'select_locations' => 'Seleccionar Ubicaciones',
    'date_range_required' => 'Se requiere rango de fechas',
    'loading_analytics' => 'Cargando análisis...',
    'analytics_loaded' => 'Análisis cargado exitosamente',
    'error_loading_analytics' => 'Error al cargar análisis',
    'no_data_available_for_period' => 'No hay datos disponibles para el período seleccionado',
    'performance_data' => 'Datos de Rendimiento',
    'comparison_data' => 'Datos de Comparación',
    'benchmark_data' => 'Datos de Referencia',
    'trend_data' => 'Datos de Tendencia',
    'profitability_data' => 'Datos de Rentabilidad',
    'staff_data' => 'Datos de Personal',
    'regional_data' => 'Datos Regionales',

    'toggle_view' => 'Alternar Vista',
    'benchmark_scores' => 'Puntuaciones de Referencia',
    'sales' => 'Ventas',
    'share' => 'Compartir',
    'city' => 'Ciudad',
    'amount' => 'Monto',
    'detailed_location_performance' => 'Rendimiento Detallado de Ubicación',
    'total_locations' => 'Total de Ubicaciones',
    'avg_profit_margin' => 'Margen de Ganancia Prom.',

    // Hardcoded text translations for Location Performance Report
    'active_locations' => 'ubicaciones activas',
    'growth' => 'crecimiento',
    'margin' => 'margen',
    'chart_view_toggled_to' => 'Vista de gráfico cambiada a',
    'chart' => 'gráfico',
    'staff_view_switched_to_card_layout' => 'Vista de personal cambiada a diseño de tarjetas',
    'staff_view_switched_to_table_layout' => 'Vista de personal cambiada a diseño de tabla',
    'staff_performance_container_not_found' => 'Contenedor de rendimiento de personal no encontrado',
    'regional_sales_analysis_report' => 'Análisis de Ventas Regionales',
    'regional_analysis_data_not_available_for_printing' => 'Datos de análisis regional no disponibles para imprimir',
    'location_performance_data_exported_successfully' => 'Datos de rendimiento de ubicación exportados exitosamente',
    'error_exporting_location_data' => 'Error al exportar datos de ubicación',
    'csv_header' => 'ID de Ubicación,Nombre de Ubicación,Ciudad,Estado,Ventas Totales,Transacciones,Transacción Prom.,Clientes,Ganancia Bruta,Margen de Ganancia',
    'line' => 'línea',
    'bar' => 'barra',
    'card' => 'tarjeta',
    'table' => 'tabla',
    'exported_successfully' => 'exportado exitosamente',

    // Staff Productivity Report
    'staff_productivity_report' => 'Productividad del Personal',
    'sales_performance_and_efficiency' => 'Análisis de Rendimiento de Ventas y Eficiencia',
    'staff_members' => 'Miembros del Personal',
    'active_staff' => 'personal activo',
    'total_commissions' => 'Comisiones Totales',
    'avg_per_staff' => 'prom. por personal',
    'avg_commission' => 'comisión prom.',
    'avg_efficiency' => 'Eficiencia Prom.',
    'efficiency_tracking' => 'Seguimiento de Eficiencia',
    'staff_sales_performance' => 'Rendimiento de Ventas del Personal',
    'working_hours_efficiency' => 'Eficiencia de Horas de Trabajo',
    'productivity_trends' => 'Tendencias de Productividad',
    'commission_tracking' => 'Seguimiento de Comisiones',
    'improvement_suggestions' => 'Sugerencias de Mejora de Rendimiento',
    'detailed_staff_performance' => 'Rendimiento Detallado del Personal',
    'staff_comparison_analysis' => 'Análisis de Comparación del Personal',
    'commission' => 'Comisión',
    'commission_amount' => 'Monto de Comisión',
    'current' => 'Actual',
    'target' => 'Objetivo',
    'no_suggestions_available' => 'No hay sugerencias de mejora disponibles',
    'staff_csv_header' => 'Nombre de Personal,Ubicación,Ventas,Transacciones,Puntuación de Eficiencia,Comisión,Calificación de Rendimiento',
    'staff_data_exported_successfully' => 'Datos de productividad del personal exportados exitosamente',
    'error_exporting_staff_data' => 'Error al exportar datos de productividad del personal',
    'radar' => 'radar',
    'comparison_view_switched_to_card_layout' => 'Vista de comparación cambiada a diseño de tarjetas',
    'comparison_view_switched_to_table_layout' => 'Vista de comparación cambiada a diseño de tabla',
    'comparison_container_not_found' => 'Contenedor de comparación no encontrado',

    // Product Category Performance translations
    'product_category_performance' => 'Rendimiento de Categoría de Productos',
    'category_contribution_and_growth' => 'Análisis de Contribución de Categoría y Tendencias de Crecimiento',
    'category_contribution' => 'Contribución de Categoría',
    'cross_selling_opportunities' => 'Oportunidades de Venta Cruzada',
    'margin_analysis' => 'Análisis de Margen',
    'growth_trends' => 'Tendencias de Crecimiento',
    'inventory_turnover' => 'Rotación de Inventario',
    'detailed_category_performance' => 'Rendimiento Detallado de Categoría',
    'profit' => 'Ganancia',
    'contribution' => 'Contribución',
    'avg_price' => 'Precio Prom.',
    'units_sold' => 'Unidades Vendidas',
    'total_categories' => 'Categorías Totales',
    'sales_contribution' => 'Contribución de Ventas',
    'profit_contribution' => 'Contribución de Ganancias',
    'days_to_sell' => 'Días para Vender',
    'stock_velocity' => 'Velocidad de Stock',
    'co_occurrences' => 'Co-ocurrencias',
    'avg_value' => 'Valor Prom.',
    'sales_pattern' => 'Patrón de Ventas',
    'view_toggled' => 'Vista alternada exitosamente',
    'unique_products' => 'Productos Únicos',
    'units' => 'Unidades',

    // Additional translations for Product Category Report
    'error_loading_analytics_data' => 'Error al cargar datos de análisis. Por favor, inténtelo de nuevo.',
    'growth_rate_percentage' => 'Tasa de Crecimiento %',
    'confidence_label' => 'Confianza:',
    'transactions_label' => 'Transacciones:',
    'analytics_data_received' => 'Datos de análisis recibidos:',
    'loading_data' => 'Cargando datos...',
    'filter_controls' => 'Controles de Filtro',
    'business_location' => 'Ubicación del Negocio',
    'brands' => 'Marcas',
    'export_data' => 'Exportar Datos',
    'last_7_days' => 'Últimos 7 Días',
    'top_performing_categories' => 'Categorías de Mejor Rendimiento',

    'categories' => 'Categorías',
    'total_revenue' => 'Ingresos Totales',

    // Seasonal Trends Report
    'seasonal_trends_report' => 'Tendencias Estacionales',
    'seasonal_trends_description' => 'Analizar patrones estacionales, rendimiento de vacaciones y efectividad promocional',

    // Audit Trail Report
    'audit_trail_report' => 'Pista de Auditoría',
    'audit_trail_description' => 'Seguimiento integral de cumplimiento y gestión de riesgos',
    'audit_activities' => 'Actividades de Auditoría',
    'transaction_modifications' => 'Modificaciones de Transacciones',
    'high_risk_activities' => 'Actividades de Alto Riesgo',
    'active_users' => 'Usuarios Activos',
    'activities_by_type' => 'Actividades por Tipo',
    'risk_level_distribution' => 'Distribución de Nivel de Riesgo',
    'daily_activity_trend' => 'Tendencia de Actividad Diaria',
    'top_active_users' => 'Usuarios Más Activos',
    'audit_trail_filters' => 'Filtros de Pista de Auditoría',
    'detailed_audit_trail' => 'Pista de Auditoría Detallada',
    'risk_level' => 'Nivel de Riesgo',
    'compliance_status' => 'Estado de Cumplimiento',
    'transaction_details' => 'Detalles de Transacción',
    'user_info' => 'Información de Usuario',
    'high_risk' => 'Alto Riesgo',
    'medium_risk' => 'Riesgo Medio',
    'low_risk' => 'Bajo Riesgo',
    'compliant' => 'Cumple',
    'requires_review' => 'Requiere Revisión',
    'non_compliant' => 'No Cumple',
    'compliance_risk_management' => 'Gestión de Cumplimiento y Riesgo',

    // Tax Compliance Report
    'tax_compliance_report' => 'Cumplimiento Fiscal',
    'tax_compliance_description' => 'Soporte de múltiples jurisdicciones fiscales y conocimientos de optimización',

    // Multi-Channel Sales Report
    'multi_channel_sales_report' => 'Ventas Multicanal',
    'multi_channel_description' => 'Análisis y optimización de rendimiento en línea vs fuera de línea',
    'online_revenue' => 'Ingresos en Línea',
    'offline_revenue' => 'Ingresos Fuera de Línea',
    'cross_channel_customers' => 'Clientes Multicanal',
    'channel_efficiency' => 'Eficiencia de Canal',
    'channel_profitability' => 'Rentabilidad de Canal',
    'customer_channel_preferences' => 'Preferencias de Canal de Clientes',
    'peak_hours_by_channel' => 'Horas Pico por Canal',
    'channel_optimization_insights' => 'Conocimientos de Optimización de Canal',
    'total_tax_collected' => 'Impuesto Total Recaudado',
    'net_tax_liability' => 'Pasivo Fiscal Neto',
    'compliance_score' => 'Puntuación de Cumplimiento',
    'potential_savings' => 'Ahorros Potenciales',
    'monthly_tax_liability_trend' => 'Tendencia de Pasivo Fiscal Mensual',
    'tax_by_jurisdiction' => 'Impuesto por Jurisdicción',
    'tax_audit_risk_assessment' => 'Evaluación de Riesgo de Auditoría Fiscal',
    'risk_score' => 'Puntuación de Riesgo',
    'tax_optimization_insights' => 'Conocimientos de Optimización Fiscal',
    'upcoming_filing_deadlines' => 'Próximas Fechas Límite de Presentación',
    'filing_deadline' => 'Fecha Límite de Presentación',
    'tax_liability_details' => 'Detalles de Pasivo Fiscal',
    'tax_name' => 'Nombre del Impuesto',
    'tax_rate' => 'Tasa de Impuesto (%)',
    'output_tax' => 'Impuesto de Salida',
    'input_tax_credit' => 'Crédito Fiscal de Entrada',
    'net_liability' => 'Pasivo Neto',
    'sales_trans' => 'Transacciones de Ventas',
    'purchase_trans' => 'Transacciones de Compras',
    'jurisdiction' => 'Jurisdicción',
    'filing_period' => 'Período de Presentación',
    'report_type' => 'Tipo de Informe',
    'export_report' => 'Exportar Informe',
    'export_excel' => 'Exportar Excel',
    'tax_liability' => 'Pasivo Fiscal',
    'filing_assistance' => 'Asistencia de Presentación',
    'optimization' => 'Optimización',
    'quarterly' => 'Trimestral',
    'semi_annual' => 'Semestral',
    'annual' => 'Anual',
    'pending' => 'Pendiente de Revisión',
    'overdue' => 'Vencido',
    'exempted' => 'Exento',
    'urgent' => 'Urgente',
    'upcoming' => 'Próximo',
    'federal' => 'Federal',
    'state_local' => 'Estatal/Local',
    'gross_sales' => 'Ventas Brutas',
    'taxable_sales' => 'Ventas Imponibles',
    'tax_collected' => 'Impuesto Recaudado',
    'tax_paid_on_purchases' => 'Impuesto Pagado en Compras',
    'filing_status' => 'Estado de Presentación',
    'tax_rate_efficiency_analysis' => 'Análisis de Eficiencia de Tasa de Impuesto',
    'seasonal_tax_optimization' => 'Optimización Fiscal Estacional',
    'input_tax_credit_opportunities' => 'Oportunidades de Crédito Fiscal de Entrada',
    'multi_tax_jurisdiction_support' => 'Soporte de Múltiples Jurisdicciones Fiscales y Optimización',
    'monthly_trends' => 'Tendencias Mensuales',
    'yearly_trends' => 'Tendencias Anuales',
    'holiday_season_performance' => 'Rendimiento de Temporada de Vacaciones',
    'promotional_effectiveness' => 'Efectividad Promocional',
    'weather_impact_analysis' => 'Análisis de Impacto Climático',
    'peak_performance_analysis' => 'Análisis de Rendimiento Pico',
    'current_year_performance' => 'Rendimiento del Año Actual',
    'year_over_year_growth' => 'Crecimiento Interanual',
    'best_performing_season' => 'Mejor Temporada de Rendimiento',
    'best_performing_month' => 'Mejor Mes de Rendimiento',
    'best_performing_months' => 'Mejores Meses de Rendimiento',
    'day_of_week_performance' => 'Rendimiento por Día de la Semana',
    'last_1_year' => 'Último 1 Año',
    'last_2_years' => 'Últimos 2 Años',
    'last_3_years' => 'Últimos 3 Años',
    'last_5_years' => 'Últimos 5 Años',
    'gross_revenue' => 'Ingresos Brutos',
    'promotion_type' => 'Tipo de Promoción',
    'avg_discount' => 'Descuento Promedio',
    'discount_percentage' => 'Porcentaje de Descuento',
    'weather_analysis_coming_soon' => 'Análisis Climático Próximamente',
    'weather_analysis_description' => 'Integrar con APIs climáticas para analizar el impacto de las condiciones climáticas en el rendimiento de ventas',
    'holiday_performance' => 'Rendimiento de Vacaciones',
    'daily_average' => 'Promedio Diario',
    'duration_days' => 'Duración (Días)',
    'growth_direction' => 'Dirección de Crecimiento',

    // Supplier Performance Report
    'supplier_performance_report' => 'Rendimiento de Proveedores',
    'supplier_performance_description' => 'Rendimiento de entrega, evaluación de calidad, cumplimiento de pagos y análisis de riesgo',
    'delivery_performance' => 'Rendimiento de Entrega',
    'quality_assessment' => 'Evaluación de Calidad',
    'payment_compliance' => 'Cumplimiento de Pagos',
    'supplier_risk_analysis' => 'Análisis de Riesgo de Proveedores',
    'on_time_delivery' => 'Entrega a Tiempo',
    'average_delivery_days' => 'Días Promedio de Entrega',
    'supplier_reliability' => 'Confiabilidad del Proveedor',
    'quality_rating' => 'Calificación de Calidad',
    'defect_rate' => 'Tasa de Defectos',
    'payment_terms_compliance' => 'Cumplimiento de Términos de Pago',
    'supplier_rankings' => 'Clasificaciones de Proveedores',
    'underperformers' => 'Bajo Rendimiento',
    'delivery_insights' => 'Conocimientos de Entrega',
    'quality_insights' => 'Conocimientos de Calidad',
    'payment_insights' => 'Conocimientos de Pago',
    'risk_insights' => 'Conocimientos de Riesgo',
    'total_suppliers' => 'Total de Proveedores',
    'total_spend' => 'Gasto Total',
    'avg_delivery_time' => 'Tiempo de Entrega Promedio',
    'overall_compliance' => 'Cumplimiento General',
    'delivery_reliability' => 'Confiabilidad de Entrega',
    'supplier_name' => 'Nombre del Proveedor',
    'orders_count' => 'Cantidad de Pedidos',
    'avg_delivery_days' => 'Días de Entrega Prom.',
    'quality_score' => 'Puntuación de Calidad',
    'payment_score' => 'Puntuación de Pago',
    'overall_score' => 'Puntuación General',
    'supplier_details' => 'Detalles del Proveedor',
    'performance_metrics' => 'Métricas de Rendimiento',

    // Warranty & Service Report
    'warranty_service_report' => 'Garantía y Servicio',
    'warranty_service_description' => 'Seguimiento de garantía de productos, análisis de solicitudes de servicio y métricas de atención al cliente',
    'warranty_tracking' => 'Seguimiento de Garantía',
    'service_requests_analysis' => 'Análisis de Solicitudes de Servicio',
    'customer_support_metrics' => 'Métricas de Atención al Cliente',
    'post_sale_service_performance' => 'Rendimiento del Servicio Posventa',
    'warranty_claims_analysis' => 'Análisis de Reclamaciones de Garantía',
    'product_warranty_tracking' => 'Seguimiento de Garantía de Productos',
    'service_request_analysis' => 'Análisis de Solicitudes de Servicio',
    'warranty_status_distribution' => 'Distribución de Estado de Garantía',
    'service_request_trends' => 'Tendencias de Solicitudes de Servicio',
    'total_products_sold' => 'Total de Productos Vendidos',
    'warranty_coverage' => 'Cobertura de Garantía',
    'service_requests' => 'Solicitudes de Servicio',
    'resolution_rate' => 'Tasa de Resolución',
    'warranty_status' => 'Estado de Garantía',
    'warranty_end_date' => 'Fecha de Fin de Garantía',
    'product_value' => 'Valor del Producto',
    'request_id' => 'ID de Solicitud',
    'resolution_days' => 'Días de Resolución',
    'warranties_expiring_soon' => 'Garantías que Vencen Pronto',
    'service_recommendations' => 'Recomendaciones de Servicio',
    'performance_insights' => 'Conocimientos de Rendimiento',
    'key_insights' => 'Conocimientos Clave',
    'comprehensive_report' => 'Informe Integral',
    'warranty_claims' => 'Reclamaciones de Garantía',
    'avg_response_time' => 'Tiempo de Respuesta Promedio',
    'avg_resolution_time' => 'Tiempo de Resolución Promedio',
    'customer_satisfaction' => 'Satisfacción del Cliente',
    'first_response_sla' => 'SLA de Primera Respuesta',
    'resolution_sla' => 'SLA de Resolución',
    'warranty_claim_rate' => 'Tasa de Reclamación de Garantía',
    'service_cost_ratio' => 'Ratio de Costo de Servicio',
    'response_time_metrics' => 'Métricas de Tiempo de Respuesta',
    'warranty_expiring_alert' => 'Garantías que vencen en los próximos 30 días',
    'high_priority_requests' => 'Solicitudes de Alta Prioridad',
    'pending_resolutions' => 'Resoluciones Pendientes',
    'warranty_type' => 'Tipo de Garantía',
    'claim_amount' => 'Monto de Reclamación',
    'claim_reason' => 'Razón de Reclamación',
    'service_type' => 'Tipo de Servicio',
    'assigned_staff' => 'Personal Asignado',
    'request_priority' => 'Prioridad de Solicitud',
    'service_cost' => 'Costo de Servicio',
    'resolution_time' => 'Tiempo de Resolución',
    'customer_feedback' => 'Retroalimentación del Cliente',
    'satisfaction_rating' => 'Calificación de Satisfacción',
    'service_quality' => 'Calidad del Servicio',
    'warranty_utilization' => 'Utilización de Garantía',
    'post_sale_performance' => 'Rendimiento Posventa',

    // Customer Group Report
    'customer_group_report' => 'Informe de Grupo de Clientes',
    'customer_group_analytics' => 'Análisis de Grupo de Clientes',
    'customer_group_description' => 'Analizar rendimiento por grupos de clientes con desglose por vendedor',
    'group_leaderboard' => 'Tabla de Líderes de Grupo',
    'salesperson_performance' => 'Rendimiento de Vendedores',
    'customer_drill_down' => 'Desglose por Cliente',
    'invoice_drill_down' => 'Desglose por Factura',
    'aging_analysis' => 'Análisis de Antigüedad',
    'net_sales' => 'Ventas Netas',
    'customer_count' => 'Clientes',
    'invoice_count' => 'Facturas',
    'avg_invoice_value' => 'Factura Prom.',
    'top_performing_group' => 'Grupo de Mejor Rendimiento',
    'top_salesperson' => 'Mejor Vendedor',
    'outstanding_due' => 'Pendiente de Cobro',
    'aging_buckets' => 'Tramos de Antigüedad',
    'risk_analysis' => 'Análisis de Riesgo',
    'include_returns' => 'Incluir Devoluciones',
    'include_drafts' => 'Incluir Borradores',
    'exclude_returns' => 'Excluir Devoluciones',
    'exclude_drafts' => 'Excluir Borradores',
    'dynamic_grouping' => 'Agrupación Dinámica',
    'vip_customers' => 'Clientes VIP',
    'regular_customers' => 'Clientes Regulares',
    'unassigned_customers' => 'Sin Asignar',
    'customer_group_performance' => 'Rendimiento de Grupo de Clientes',
    'drill_down_analysis' => 'Análisis de Desglose',

    // Menu Navigation Translations
    'sales_revenue_analysis' => 'Análisis de Ventas e Ingresos',
    'sales_analytics' => 'Análisis de Ventas',
    'customer_performance' => 'Rendimiento de Clientes',
    'product_sales_analysis' => 'Análisis de Ventas de Productos',
    'daily_operations' => 'Operaciones Diarias',
    'daily_dashboard' => 'Panel Diario',
    'inventory_product_management' => 'Gestión de Inventario y Productos',
    'inventory_turnover_report' => 'Rotación de Inventario',
    'stock_management' => 'Gestión de Stock',
    'brand_analytics' => 'Análisis de Marcas',
    'brand_comparison' => 'Comparación de Marcas',
    'supplier_performance' => 'Rendimiento de Proveedores',
    'supplier_analysis' => 'Análisis de Proveedores',
    'supplier_profitability' => 'Rentabilidad de Proveedores',
    'financial_compliance' => 'Cumplimiento Financiero',
    'profit_loss_analysis' => 'Análisis de Ganancias y Pérdidas',
    'purchase_analysis' => 'Análisis de Compras',
    'customer_lifetime_value' => 'Valor del Ciclo de Vida del Cliente',
    'customer_behavior_analytics' => 'Análisis de Comportamiento del Cliente',
    'customer_segmentation_report' => 'Segmentación de Clientes',
    'gst_sales_compliance' => 'Cumplimiento de Ventas GST',
    'gst_purchase_compliance' => 'Cumplimiento de Compras GST',
    'monthly_expenses' => 'Gastos Mensuales',
    'business_operations_summary' => 'Resumen de Operaciones del Negocio',
    'customer_staff_engagement' => 'Compromiso de Clientes y Personal',
    'customer_loyalty_program' => 'Programa de Lealtad de Clientes',
    'staff_performance_management' => 'Rendimiento del Personal',
    'awarded' => 'Premiado',
    'not_awarded' => 'No Premiado',

    // Product search
    'type_to_search_product' => 'Escriba para buscar producto',
    'searching' => 'Buscando...',
    'no_products_found' => 'No se encontraron productos',

    // Module notifications
    'module_not_enabled' => 'Módulo No Habilitado',
    'alert' => 'Alerta',
    'module_required' => 'Módulo Requerido',
    'enable_module_instruction' => 'Por favor habilite el módulo requerido en la Configuración del Negocio para usar esta función.',
    'go_to_settings' => 'Ir a Configuración',
    'go_to_home' => 'Ir a Inicio',

    // Reward Points Report
    'reward_points_report' => 'Seguimiento de Puntos de Recompensa y Pasivo',
    'reward_points_description' => 'Rastrear puntos de recompensa de clientes, historial de canjes y análisis de pasivo financiero',
    'outstanding_liability_points' => 'Pasivo Pendiente (Puntos)',
    'liability_amount' => 'Monto de Pasivo',
    'active_customers_with_points' => 'Clientes Activos con Puntos',
    'redemption_rate' => 'Tasa de Canje',
    'total_points_issued' => 'Puntos Totales Emitidos',
    'total_points_redeemed' => 'Puntos Totales Canjeados',
    'points_redeemed_this_month' => 'Puntos Canjeados Este Mes',
    'avg_points_per_customer' => 'Puntos Prom. por Cliente',
    'top_point_earners' => 'Principales Ganadores de Puntos',
    'top_point_redeemers' => 'Principales Canjeadores de Puntos',
    'customer_points_summary' => 'Resumen de Puntos de Clientes',
    'export_table' => 'Exportar Tabla',
    'points_earned' => 'Puntos Ganados',
    'points_redeemed' => 'Puntos Canjeados',
    'current_balance' => 'Saldo Actual',
    'liability_bdt' => 'Pasivo',
    'redemption_count' => 'Cantidad de Canjes',
    'last_activity' => 'Última Actividad',
    'invoice_amount' => 'Monto de Factura',
    'points_value' => 'Valor de Puntos',
    'final_payable' => 'Pago Final',
    'customer_summary' => 'Resumen de Cliente',
    'view_type' => 'Tipo de Vista',
    'select_customer' => 'Seleccionar Cliente',
    'type_2_chars_to_search' => 'Escriba 2 caracteres para buscar',
    'loading_reward_points_data' => 'Cargando datos de puntos de recompensa...',
    'no_reward_points_data' => 'No hay datos de puntos de recompensa disponibles',
    'loading_transaction_details' => 'Cargando detalles de transacción...',
    'no_transaction_data' => 'No hay datos de transacción disponibles',
    'no_matching_transactions' => 'No se encontraron transacciones coincidentes',
    'no_result' => 'Sin resultado',
    'type_to_search' => 'Escriba para buscar',
    'reward_points_not_enabled' => 'El módulo de Puntos de Recompensa no está habilitado para su negocio.',
    'enable_reward_points_instruction' => 'Por favor habilite la función de Puntos de Recompensa en la Configuración del Negocio para usar este informe.',

    // Additional keys for hardcoded text fixes
    'advanced_reports_dashboard' => 'Informes Avanzados - Panel de Inteligencia de Negocios',
    'comprehensive_analytics_description' => 'Análisis integral e informes para decisiones basadas en datos',
    'professional_reports_count' => '40+ Informes Profesionales',
    'transform_data_insights' => 'Transforme los datos de su negocio en conocimientos accionables',
    'view_report' => 'Ver Informe',
    'coming_soon' => 'Próximamente',
    'quick_access_popular_reports' => 'Acceso Rápido - Informes Más Populares',
    'comprehensive_profit_loss_description' => 'Informes integrales de ganancias y pérdidas con análisis avanzados',
    'filters_controls' => 'Filtros y Controles',
    'custom_date_range' => 'Rango de Fechas Personalizado',
    'select_custom_date_range' => 'Seleccionar rango de fechas personalizado',
    'export_pdf' => 'Exportar PDF',
    'expense_breakdown_description' => 'Ver desglose de gastos por categorías y meses',
    'year' => 'Año',
    'average_expense' => 'Gasto Promedio',
    'exporting' => 'Exportando...',
    'invoices_paid' => 'facturas pagadas',
    'per_transaction' => 'Por transacción',
    'confirm_delete_transaction' => '¿Está seguro de que desea eliminar esta transacción?',
    'error_loading_data' => 'Error al cargar datos',

    // Award Catalog translations
    'award_catalog_management' => 'Gestión de Catálogo de Premios',
    'manage_gifts_awards_customer_recognition' => 'Gestionar regalos y premios para reconocimiento de clientes',
    'award_catalog_controls' => 'Controles de Catálogo de Premios',
    'add_new_award' => 'Agregar Nuevo Premio',
    'award_catalog_items' => 'Artículos del Catálogo de Premios',
    'delete_award' => 'Eliminar Premio',
    'edit_award' => 'Editar Premio',

    // Business Analytics Dashboard
    'business_analytics_dashboard' => 'Panel de Análisis de Negocios',
    'view_data_usage_across_businesses' => 'Ver uso de datos en todos los negocios',
    'total_businesses' => 'Total de Negocios',
    'actual_db_size' => 'Tamaño Real de BD',
    'avg_business_size' => 'Tamaño Prom. de Negocio',
    'business_data_analytics' => 'Análisis de Datos del Negocio',
    'business_name' => 'Nombre del Negocio',
    'created_at' => 'Creado el',
    'contacts' => 'Contactos',
    'size_mb' => 'Tamaño (MB)',
    'top_tables' => 'Principales Tablas',
    'data_populated_by_js' => 'Los datos serán poblados por JavaScript',
    'loading_business_analytics' => 'Cargando análisis de negocios...',
    'no_business_data_available' => 'No hay datos de negocios disponibles',
    'no_matching_businesses_found' => 'No se encontraron negocios coincidentes',
    'failed_to_load_summary_data' => 'Fallo al cargar datos de resumen',
    'failed_to_load_table_data' => 'Fallo al cargar datos de tabla',
    'failed_to_load_business_analytics_data' => 'Fallo al cargar datos de análisis de negocios',

    // ABC Analysis
    'number_of_items' => 'Número de Artículos',
    'value_percentage' => 'Porcentaje de Valor',
    'abc_classification_distribution' => 'Distribución de Clasificación ABC',
    'abc_value_distribution' => 'Distribución de Valor ABC',
    'analysis_value' => 'Valor de Análisis',
    'cumulative_percentage' => 'Porcentaje Acumulativo',
    'pareto_analysis_top_contributing_products' => 'Análisis de Pareto - Productos de Mayor Contribución',
    'no_classification_data_available_to_export' => 'No hay datos de clasificación disponibles para exportar',
    'failed_to_load_abc_analysis_data' => 'Fallo al cargar datos de análisis ABC',
    'no_contribution_data_available' => 'No hay datos de contribución disponibles',
    'no_classification_data_available' => 'No hay datos de clasificación disponibles',
    'no_contribution_analysis_data_available_to_export' => 'No hay datos de análisis de contribución disponibles para exportar',
    'classification_data_exported_successfully' => '¡Datos de clasificación exportados exitosamente!',
    'revenue_contribution_data_exported_successfully' => '¡Datos de contribución de ingresos exportados exitosamente!',

    // Customer Behavior Analytics (additional translations)
    'analyze_customer_purchase_patterns' => 'Analizar patrones de compra, preferencias y satisfacción del cliente',
    'peak_hour' => 'Hora Pico',
    'busiest_time' => 'Hora Más Ocupada',
    'daily_purchase_patterns' => 'Patrones de Compra Diarios',
    'hourly_purchase_distribution' => 'Distribución Horaria de Compras',
    'seasonal_purchase_patterns' => 'Patrones de Compra Estacionales',
    'category_preferences' => 'Preferencias de Categoría',
    'category_performance' => 'Rendimiento de Categoría',
    'revenue_percentage' => '% de Ingresos',
    'average_order_value_trends' => 'Tendencias de Valor Promedio de Pedido',
    'customer_value_segments' => 'Segmentos de Valor de Cliente',
    'customer_satisfaction_score' => 'Puntuación de Satisfacción del Cliente',
    'calculating' => 'Calculando...',
    'satisfaction_metrics' => 'Métricas de Satisfacción',
    'repeat_customer_rate' => 'Tasa de Cliente Recurrente',
    'return_rate' => 'Tasa de Devolución',
    'customer_retention' => 'Retención de Clientes',
    'avg_days_between' => 'Días Prom. Entre',
    'transaction_volume_by_hour' => 'Volumen de Transacciones por Hora',
    'failed_to_load_customer_behavior_analytics' => 'Fallo al cargar análisis de comportamiento del cliente',

    // Customer Segmentation (additional translations)
    'rfm_analysis_geographic_distribution_vip_identification' => 'Análisis RFM, Distribución Geográfica e Identificación de Clientes VIP',
    'repeat_rate' => 'tasa de recurrencia',
    'geographic_reach' => 'Alcance Geográfico',
    'states' => 'estados',
    'rfm_customer_segments' => 'Segmentos de Clientes RFM',
    'vip_tier_distribution' => 'Distribución de Nivel VIP',
    'recency_distribution' => 'Distribución de Recencia',
    'frequency_distribution' => 'Distribución de Frecuencia',
    'monetary_distribution' => 'Distribución Monetaria',
    'state_wise_customer_distribution' => 'Distribución de Clientes por Estado',
    'city_wise_revenue_distribution' => 'Distribución de Ingresos por Ciudad',
    'age_group_distribution' => 'Distribución por Grupo de Edad',
    'customer_type_distribution' => 'Distribución por Tipo de Cliente',
    'purchase_behavior' => 'Comportamiento de Compra',
    'top_vip_customers' => 'Principales Clientes VIP',
    'all_tiers' => 'Todos los Niveles',
    'vip_tier' => 'Nivel VIP',
    'vip_score' => 'Puntuación VIP',
    'total_spent' => 'Total Gastado',
    'last_purchase' => 'Última Compra',
    'vip_customers_populated_here' => 'Los clientes VIP se poblarán aquí',

    // Inventory Turnover (additional translations)
    'stock_rotation_analysis_movement_classification' => 'Análisis de Rotación de Stock, Clasificación de Movimiento y Recomendaciones de Stock Óptimo',
    'avg_turnover_ratio' => 'Ratio de Rotación Prom.',
    'units_per_day' => 'unidades/día',
    'dead_stock_items' => 'artículos de stock muerto',
    'stock_movement_classification' => 'Clasificación de Movimiento de Stock',
    'inventory_aging' => 'Antigüedad de Inventario',
    'category_movement_analysis' => 'Análisis de Movimiento por Categoría',
    'stock_level_recommendations' => 'Recomendaciones de Nivel de Stock',
    'all_actions' => 'Todas las Acciones',
    'reduce_stock' => 'Reducir Stock',
    'liquidate' => 'Liquidar',
    'maintain' => 'Mantener',
    'recommended_qty' => 'Cantidad Recomendada',
    'impact' => 'Impacto',
    'recommendations_populated_here' => 'Las recomendaciones se poblarán aquí',
    'top_performers_fast_moving' => 'Mejores Rendimientos (Movimiento Rápido)',
    'turnover' => 'Rotación',
    'top_performers_populated_here' => 'Los mejores rendimientos se poblarán aquí',
    'worst_performers_dead_stock' => 'Peores Rendimientos (Stock Muerto)',
    'days_in_stock' => 'Días en Stock',
    'last_sale' => 'Última Venta',
    'worst_performers_populated_here' => 'Los peores rendimientos se poblarán aquí',
    'fast_moving_percentage' => '% Movimiento Rápido',
    'no_fast_moving_products_found' => 'No se encontraron productos de movimiento rápido',
    'no_dead_stock_found' => 'No se encontró stock muerto',

    // Recognition Settings
    'customer_recognition_settings' => 'Configuración de Reconocimiento de Clientes',
    'configure_recognition_periods_scoring_preferences' => 'Configurar períodos de reconocimiento, puntuación y preferencias del sistema',
    'general_settings' => 'Configuración General',
    'module_start_date' => 'Fecha de Inicio del Módulo',
    'weekly_recognition' => 'Reconocimiento Semanal',
    'monthly_recognition' => 'Reconocimiento Mensual',

    'export_catalog' => 'Exportar Catálogo',
    'award_name' => 'Nombre del Premio',
    'product_link' => 'Enlace del Producto',
    'stock_status' => 'Estado de Stock',
    'point_threshold' => 'Umbral de Puntos',
    'actions' => 'Acciones',
    'add_award_item' => 'Agregar Artículo de Premio',

    // Additional Award Catalog translations
    'basic_information' => 'Información Básica',
    'monetary_value' => 'Valor Monetario',
    'product_integration' => 'Integración de Producto',
    'link_to_product_optional' => 'Enlace a Producto (Opcional)',
    'requires_stock_management' => 'Requiere Gestión de Stock',
    'current_image' => 'Imagen Actual',
    'confirm_deletion' => 'Confirmar Eliminación',
    'are_you_sure_delete_award_item' => '¿Está seguro de que desea eliminar este artículo de premio?',
    'award_used_deactivated_instead_deleted' => 'Si este premio ha sido utilizado en premios de clientes, será desactivado en lugar de eliminado.',
    'eg_gift_voucher' => 'ej., Cupón de Regalo de $50',
    'detailed_description_award' => 'Descripción detallada del premio...',
    'min_engagement_points_qualify' => 'Puntos mínimos de compromiso para calificar',
    'stock_quantity' => 'Cantidad de Stock',
    'award_image' => 'Imagen del Premio',

    'product_performance' => 'Rendimiento de Productos',
    'expense_monthly_report' => 'Informe Mensual de Gastos',
    'sales_detail_filters' => 'Filtros de Detalle de Ventas',
    'sales_detail_data' => 'Datos Detallados de Ventas',
    'sales_detail_summary' => 'Resumen Detallado de Ventas',

    // Daily Report Widget Labels
    'todays_sales' => 'Ventas de Hoy',
    'todays_purchases' => 'Compras de Hoy',
    'todays_expenses' => 'Gastos de Hoy',
    'todays_profit' => 'Ganancia de Hoy',
    'todays_collections' => 'Cobranzas de Hoy',

    // Daily Report Sections
    'sales_analysis' => 'Análisis de Ventas',
    'payment_methods_analysis' => 'Análisis de Métodos de Pago',
    'expense_breakdown' => 'Desglose de Gastos',
    'monthly_cash_flow_breakdown' => 'Desglose de Flujo de Efectivo Mensual',

    // Common
    'date_format' => 'Formato: DD/MM/AAAA',
    'stock_health' => 'Salud del Stock',
    'action' => 'Acción',
    'stock' => 'Stock',

    'purchases' => 'Compras',
    'users' => 'Usuarios',
    'walk_in_customer' => 'Cliente sin Cita',



];
