<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Module Installation Routes
|--------------------------------------------------------------------------
*/
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/accounting-reports/install', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'index'])->name('accounting-reports.install');
    Route::get('/accounting-reports/install/update', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'update'])->name('accounting-reports.install.update');
    Route::get('/accounting-reports/install/uninstall', [\Modules\AccountingReports\Http\Controllers\InstallController::class, 'uninstall'])->name('accounting-reports.install.uninstall');
});

/*
|--------------------------------------------------------------------------
| Main Accounting Reports Routes
|--------------------------------------------------------------------------
*/
Route::prefix('accounting-reports')->middleware(['auth', 'web', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'])->group(function() {
    
    // Main dashboard/index
    Route::get('/', 'AccountingReportsController@index')->name('accounting-reports.index');
    
    // Trial Balance
    Route::get('/trial-balance', 'TrialBalanceController@index')->name('accounting-reports.trial-balance.index');
    Route::get('/trial-balance/get-data', 'TrialBalanceController@getData')->name('accounting-reports.trial-balance.get-data');
    Route::get('/trial-balance/export', 'TrialBalanceController@export')->name('accounting-reports.trial-balance.export');
    
    // Balance Sheet
    Route::get('/balance-sheet', 'BalanceSheetController@index')->name('accounting-reports.balance-sheet.index');
    Route::get('/balance-sheet/get-data', 'BalanceSheetController@getData')->name('accounting-reports.balance-sheet.get-data');
    Route::get('/balance-sheet/export', 'BalanceSheetController@export')->name('accounting-reports.balance-sheet.export');
    
    // Profit & Loss
    Route::get('/profit-loss', 'ProfitLossController@index')->name('accounting-reports.profit-loss.index');
    Route::get('/profit-loss/get-data', 'ProfitLossController@getData')->name('accounting-reports.profit-loss.get-data');
    Route::get('/profit-loss/export', 'ProfitLossController@export')->name('accounting-reports.profit-loss.export');
    
    // Cash Flow
    Route::get('/cash-flow', 'CashFlowController@index')->name('accounting-reports.cash-flow.index');
    Route::get('/cash-flow/get-data', 'CashFlowController@getData')->name('accounting-reports.cash-flow.get-data');
    Route::get('/cash-flow/export', 'CashFlowController@export')->name('accounting-reports.cash-flow.export');
    
    // Funds Flow
    Route::get('/funds-flow', 'FundsFlowController@index')->name('accounting-reports.funds-flow.index');
    Route::get('/funds-flow/get-data', 'FundsFlowController@getData')->name('accounting-reports.funds-flow.get-data');
    Route::get('/funds-flow/export', 'FundsFlowController@export')->name('accounting-reports.funds-flow.export');
    
    // Receivables
    Route::get('/receivables', 'ReceivablesController@index')->name('accounting-reports.receivables.index');
    Route::get('/receivables/get-data', 'ReceivablesController@getData')->name('accounting-reports.receivables.get-data');
    Route::get('/receivables/aging', 'ReceivablesController@aging')->name('accounting-reports.receivables.aging');
    Route::get('/receivables/statement/{contact_id}', 'ReceivablesController@statement')->name('accounting-reports.receivables.statement');
    Route::get('/receivables/export', 'ReceivablesController@export')->name('accounting-reports.receivables.export');
    
    // Payables
    Route::get('/payables', 'PayablesController@index')->name('accounting-reports.payables.index');
    Route::get('/payables/get-data', 'PayablesController@getData')->name('accounting-reports.payables.get-data');
    Route::get('/payables/aging', 'PayablesController@aging')->name('accounting-reports.payables.aging');
    Route::get('/payables/statement/{contact_id}', 'PayablesController@statement')->name('accounting-reports.payables.statement');
    Route::get('/payables/export', 'PayablesController@export')->name('accounting-reports.payables.export');
    
    // Day Book
    Route::get('/day-book', 'DayBookController@index')->name('accounting-reports.day-book.index');
    Route::get('/day-book/get-data', 'DayBookController@getData')->name('accounting-reports.day-book.get-data');
    Route::get('/day-book/export/pdf', 'DayBookController@exportPdf')->name('accounting-reports.day-book.export-pdf');
    Route::get('/day-book/export/csv', 'DayBookController@exportCsv')->name('accounting-reports.day-book.export-csv');
    Route::get('/day-book/print', 'DayBookController@print')->name('accounting-reports.day-book.print');
    
    // Ratio Analysis
    Route::get('/ratio-analysis', 'RatioAnalysisController@index')->name('accounting-reports.ratio-analysis.index');
    Route::get('/ratio-analysis/get-data', 'RatioAnalysisController@getData')->name('accounting-reports.ratio-analysis.get-data');
    Route::get('/ratio-analysis/export', 'RatioAnalysisController@export')->name('accounting-reports.ratio-analysis.export');
    
    // Cash Book
    Route::get('/cash-book', 'CashBookController@index')->name('accounting-reports.cash-book.index');
    Route::get('/cash-book/get-data', 'CashBookController@getData')->name('accounting-reports.cash-book.get-data');
    Route::get('/cash-book/export', 'CashBookController@export')->name('accounting-reports.cash-book.export');
    
    
    // Cheque Books (Physical Cheque Books)
    Route::get('/cheque-books', 'ChequeBookController@index')->name('accounting-reports.cheque-books.index');
    Route::get('/cheque-books/get-data', 'ChequeBookController@getData')->name('accounting-reports.cheque-books.get-data');
    Route::get('/cheque-books/create', 'ChequeBookController@create')->name('accounting-reports.cheque-books.create');
    Route::post('/cheque-books', 'ChequeBookController@store')->name('accounting-reports.cheque-books.store');
    Route::get('/cheque-books/{id}', 'ChequeBookController@show')->name('accounting-reports.cheque-books.show');
    Route::get('/cheque-books/{id}/edit', 'ChequeBookController@edit')->name('accounting-reports.cheque-books.edit');
    Route::put('/cheque-books/{id}', 'ChequeBookController@update')->name('accounting-reports.cheque-books.update');
    Route::delete('/cheque-books/{id}', 'ChequeBookController@destroy')->name('accounting-reports.cheque-books.destroy');
    Route::post('/cheque-books/{id}/generate-entries', 'ChequeBookController@generateEntries')->name('accounting-reports.cheque-books.generate-entries');
    
    // Cheque Book Entries (Individual Cheques)
    Route::get('/cheque-book', 'ChequeBookEntryController@index')->name('accounting-reports.cheque-book.index');
    Route::get('/cheque-book/get-data', 'ChequeBookEntryController@getData')->name('accounting-reports.cheque-book.get-data');
    Route::get('/cheque-book/create', 'ChequeBookEntryController@create')->name('accounting-reports.cheque-book.create');
    Route::post('/cheque-book', 'ChequeBookEntryController@store')->name('accounting-reports.cheque-book.store');
    Route::get('/cheque-book/{id}/edit', 'ChequeBookEntryController@edit')->name('accounting-reports.cheque-book.edit');
    Route::put('/cheque-book/{id}', 'ChequeBookEntryController@update')->name('accounting-reports.cheque-book.update');
    Route::delete('/cheque-book/{id}', 'ChequeBookEntryController@destroy')->name('accounting-reports.cheque-book.destroy');
    Route::get('/cheque-book/get-available-cheques', 'ChequeBookEntryController@getAvailableCheques')->name('accounting-reports.cheque-book.get-available-cheques');
    Route::get('/cheque-book/history/get-data', 'ChequeBookEntryController@getHistory')->name('accounting-reports.cheque-book.history.get-data');
    
    // Statistics/Dashboard
    Route::get('/statistics', 'StatisticsController@index')->name('accounting-reports.statistics.index');
    Route::get('/statistics/get-data', 'StatisticsController@getData')->name('accounting-reports.statistics.get-data');
    
    // Batch Print Multi-Account Reports
    Route::get('/batch-print', 'BatchPrintController@index')->name('accounting-reports.batch-print.index');
    Route::post('/batch-print/process', 'BatchPrintController@process')->name('accounting-reports.batch-print.process');
    
    // Integrity & Rebuild Tools
    Route::get('/integrity', 'IntegrityController@index')->name('accounting-reports.integrity.index');
    Route::post('/integrity/validate', 'IntegrityController@runValidation')->name('accounting-reports.integrity.validate');
    Route::post('/integrity/rebuild', 'IntegrityController@rebuild')->name('accounting-reports.integrity.rebuild');
    Route::get('/integrity/reconcile-cogs', 'IntegrityController@reconcileCogs')->name('accounting-reports.integrity.reconcile-cogs');
    
    // Voucher drill-down
    Route::get('/voucher/{voucher_id}', 'AccountingReportsController@viewVoucher')->name('accounting-reports.voucher.view');
    Route::get('/voucher/{voucher_id}/source', 'AccountingReportsController@viewSourceDocument')->name('accounting-reports.voucher.source');
    
    // Direct Expenses Management
    Route::get('/direct-expenses', 'DirectExpenseController@index')->name('accounting-reports.direct-expenses.index');
    Route::get('/direct-expenses/get-data', 'DirectExpenseController@getData')->name('accounting-reports.direct-expenses.get-data');
    Route::get('/direct-expenses/create', 'DirectExpenseController@create')->name('accounting-reports.direct-expenses.create');
    Route::post('/direct-expenses', 'DirectExpenseController@store')->name('accounting-reports.direct-expenses.store');
    Route::get('/direct-expenses/{id}', 'DirectExpenseController@show')->name('accounting-reports.direct-expenses.show');
    Route::get('/direct-expenses/{id}/edit', 'DirectExpenseController@edit')->name('accounting-reports.direct-expenses.edit');
    Route::put('/direct-expenses/{id}', 'DirectExpenseController@update')->name('accounting-reports.direct-expenses.update');
    Route::delete('/direct-expenses/{id}', 'DirectExpenseController@destroy')->name('accounting-reports.direct-expenses.destroy');
    
    // Direct Expense Names Management
    Route::get('/direct-expense-names', 'DirectExpenseNameController@index')->name('accounting-reports.direct-expense-names.index');
    Route::get('/direct-expense-names/get-data', 'DirectExpenseNameController@getData')->name('accounting-reports.direct-expense-names.get-data');
    Route::get('/direct-expense-names/create', 'DirectExpenseNameController@create')->name('accounting-reports.direct-expense-names.create');
    Route::post('/direct-expense-names', 'DirectExpenseNameController@store')->name('accounting-reports.direct-expense-names.store');
    Route::get('/direct-expense-names/{id}', 'DirectExpenseNameController@show')->name('accounting-reports.direct-expense-names.show');
    Route::get('/direct-expense-names/{id}/edit', 'DirectExpenseNameController@edit')->name('accounting-reports.direct-expense-names.edit');
    Route::put('/direct-expense-names/{id}', 'DirectExpenseNameController@update')->name('accounting-reports.direct-expense-names.update');
    Route::delete('/direct-expense-names/{id}', 'DirectExpenseNameController@destroy')->name('accounting-reports.direct-expense-names.destroy');
    
    // Direct Income Names Management
    Route::get('/direct-income-names', 'DirectIncomeNameController@index')->name('accounting-reports.direct-income-names.index');
    Route::get('/direct-income-names/get-data', 'DirectIncomeNameController@getData')->name('accounting-reports.direct-income-names.get-data');
    Route::get('/direct-income-names/create', 'DirectIncomeNameController@create')->name('accounting-reports.direct-income-names.create');
    Route::post('/direct-income-names', 'DirectIncomeNameController@store')->name('accounting-reports.direct-income-names.store');
    Route::get('/direct-income-names/{id}', 'DirectIncomeNameController@show')->name('accounting-reports.direct-income-names.show');
    Route::get('/direct-income-names/{id}/edit', 'DirectIncomeNameController@edit')->name('accounting-reports.direct-income-names.edit');
    Route::put('/direct-income-names/{id}', 'DirectIncomeNameController@update')->name('accounting-reports.direct-income-names.update');
    Route::delete('/direct-income-names/{id}', 'DirectIncomeNameController@destroy')->name('accounting-reports.direct-income-names.destroy');
    
    // Direct Incomes Management
    Route::get('/direct-incomes', 'DirectIncomeController@index')->name('accounting-reports.direct-incomes.index');
    Route::get('/direct-incomes/get-data', 'DirectIncomeController@getData')->name('accounting-reports.direct-incomes.get-data');
    Route::get('/direct-incomes/create', 'DirectIncomeController@create')->name('accounting-reports.direct-incomes.create');
    Route::post('/direct-incomes', 'DirectIncomeController@store')->name('accounting-reports.direct-incomes.store');
    Route::get('/direct-incomes/{id}', 'DirectIncomeController@show')->name('accounting-reports.direct-incomes.show');
    Route::get('/direct-incomes/{id}/edit', 'DirectIncomeController@edit')->name('accounting-reports.direct-incomes.edit');
    Route::put('/direct-incomes/{id}', 'DirectIncomeController@update')->name('accounting-reports.direct-incomes.update');
    Route::delete('/direct-incomes/{id}', 'DirectIncomeController@destroy')->name('accounting-reports.direct-incomes.destroy');
    
    // Fixed Assets Management
    Route::get('/fixed-assets', 'FixedAssetController@index')->name('accounting-reports.fixed-assets.index');
    Route::get('/fixed-assets/get-data', 'FixedAssetController@getData')->name('accounting-reports.fixed-assets.get-data');
    Route::get('/fixed-assets/create', 'FixedAssetController@create')->name('accounting-reports.fixed-assets.create');
    Route::post('/fixed-assets', 'FixedAssetController@store')->name('accounting-reports.fixed-assets.store');
    Route::get('/fixed-assets/{id}', 'FixedAssetController@show')->name('accounting-reports.fixed-assets.show');
    Route::get('/fixed-assets/{id}/edit', 'FixedAssetController@edit')->name('accounting-reports.fixed-assets.edit');
    Route::put('/fixed-assets/{id}', 'FixedAssetController@update')->name('accounting-reports.fixed-assets.update');
    Route::delete('/fixed-assets/{id}', 'FixedAssetController@destroy')->name('accounting-reports.fixed-assets.destroy');
    
    // Capital Accounts Management
    Route::get('/capital-accounts', 'CapitalAccountController@index')->name('accounting-reports.capital-accounts.index');
    Route::get('/capital-accounts/get-data', 'CapitalAccountController@getData')->name('accounting-reports.capital-accounts.get-data');
    Route::get('/capital-accounts/create', 'CapitalAccountController@create')->name('accounting-reports.capital-accounts.create');
    Route::post('/capital-accounts', 'CapitalAccountController@store')->name('accounting-reports.capital-accounts.store');
    Route::get('/capital-accounts/{id}', 'CapitalAccountController@show')->name('accounting-reports.capital-accounts.show');
    Route::get('/capital-accounts/{id}/edit', 'CapitalAccountController@edit')->name('accounting-reports.capital-accounts.edit');
    Route::put('/capital-accounts/{id}', 'CapitalAccountController@update')->name('accounting-reports.capital-accounts.update');
    Route::delete('/capital-accounts/{id}', 'CapitalAccountController@destroy')->name('accounting-reports.capital-accounts.destroy');
    
    // Fixed Asset Revaluations
    Route::get('/fixed-asset-revaluations', 'FixedAssetRevaluationController@index')->name('accounting-reports.fixed-asset-revaluations.index');
    Route::get('/fixed-asset-revaluations/get-data', 'FixedAssetRevaluationController@getData')->name('accounting-reports.fixed-asset-revaluations.get-data');
    Route::get('/fixed-asset-revaluations/create', 'FixedAssetRevaluationController@create')->name('accounting-reports.fixed-asset-revaluations.create');
    Route::get('/fixed-asset-revaluations/get-asset-details/{id}', 'FixedAssetRevaluationController@getAssetDetails')->name('accounting-reports.fixed-asset-revaluations.get-asset-details');
    Route::post('/fixed-asset-revaluations', 'FixedAssetRevaluationController@store')->name('accounting-reports.fixed-asset-revaluations.store');
    Route::get('/fixed-asset-revaluations/{id}', 'FixedAssetRevaluationController@show')->name('accounting-reports.fixed-asset-revaluations.show');
    Route::delete('/fixed-asset-revaluations/{id}', 'FixedAssetRevaluationController@destroy')->name('accounting-reports.fixed-asset-revaluations.destroy');
    
    // Fixed Assets Report
    Route::get('/fixed-assets-report', 'FixedAssetsReportController@index')->name('accounting-reports.fixed-assets-report.index');
    Route::get('/fixed-assets-report/get-data', 'FixedAssetsReportController@getData')->name('accounting-reports.fixed-assets-report.get-data');
    Route::get('/fixed-assets-report/export', 'FixedAssetsReportController@export')->name('accounting-reports.fixed-assets-report.export');
    
    // Investments Management
    Route::get('/investments', 'InvestmentController@index')->name('accounting-reports.investments.index');
    Route::get('/investments/get-data', 'InvestmentController@getData')->name('accounting-reports.investments.get-data');
    Route::get('/investments/create', 'InvestmentController@create')->name('accounting-reports.investments.create');
    Route::post('/investments', 'InvestmentController@store')->name('accounting-reports.investments.store');
    Route::get('/investments/{id}', 'InvestmentController@show')->name('accounting-reports.investments.show');
    Route::get('/investments/{id}/edit', 'InvestmentController@edit')->name('accounting-reports.investments.edit');
    Route::put('/investments/{id}', 'InvestmentController@update')->name('accounting-reports.investments.update');
    Route::delete('/investments/{id}', 'InvestmentController@destroy')->name('accounting-reports.investments.destroy');
    
    // Bank Accounts Management (New System)
    Route::prefix('bank-management')->group(function() {
        // Bank Accounts CRUD
        Route::get('/', 'BankManagementController@index')->name('accounting-reports.bank-management.index');
        Route::get('/get-bank-accounts', 'BankManagementController@getBankAccounts')->name('accounting-reports.bank-management.get-bank-accounts');
        Route::get('/create', 'BankManagementController@create')->name('accounting-reports.bank-management.create');
        Route::post('/', 'BankManagementController@store')->name('accounting-reports.bank-management.store');
        Route::get('/{id}', 'BankManagementController@show')->name('accounting-reports.bank-management.show');
        Route::get('/{id}/edit', 'BankManagementController@edit')->name('accounting-reports.bank-management.edit');
        Route::put('/{id}', 'BankManagementController@update')->name('accounting-reports.bank-management.update');
        Route::delete('/{id}', 'BankManagementController@destroy')->name('accounting-reports.bank-management.destroy');
        Route::get('/{id}/statement', 'BankManagementController@statement')->name('accounting-reports.bank-management.statement');
        Route::get('/{id}/manage', 'BankManagementController@manage')->name('accounting-reports.bank-management.manage');
        Route::get('/summary', 'BankManagementController@getSummary')->name('accounting-reports.bank-management.summary');
        
        // Cheque Entries
        Route::get('/{bankAccountId}/cheque-entries', 'BankManagementController@getChequeEntries')->name('accounting-reports.bank-management.cheque-entries');
        Route::post('/cheque-entries', 'BankManagementController@storeChequeEntry')->name('accounting-reports.bank-management.cheque.store');
        Route::post('/cheque/{id}/mark-cleared', 'BankManagementController@markChequeCleared')->name('accounting-reports.bank-management.cheque.mark-cleared');
        Route::post('/cheque/{id}/mark-bounced', 'BankManagementController@markChequeBounced')->name('accounting-reports.bank-management.cheque.mark-bounced');
        
        // Bank Reconciliation
        Route::get('/{bankAccountId}/unreconciled-transactions', 'BankManagementController@getUnreconciledTransactions')->name('accounting-reports.bank-management.unreconciled');
        Route::post('/{bankAccountId}/reconcile', 'BankManagementController@reconcileTransactions')->name('accounting-reports.bank-management.reconcile');
        Route::get('/{bankAccountId}/reconciliation-statement', 'BankManagementController@getReconciliationStatement')->name('accounting-reports.bank-management.reconciliation-statement');
    });
    
    // Legacy Bank Accounts Routes (Keep for backward compatibility)
    Route::get('/bank-accounts', 'BankAccountController@index')->name('accounting-reports.bank-accounts.index');
    Route::get('/bank-accounts/get-data', 'BankAccountController@getData')->name('accounting-reports.bank-accounts.get-data');
    Route::get('/bank-accounts/create', 'BankAccountController@create')->name('accounting-reports.bank-accounts.create');
    Route::post('/bank-accounts', 'BankAccountController@store')->name('accounting-reports.bank-accounts.store');
    Route::get('/bank-accounts/{id}', 'BankAccountController@show')->name('accounting-reports.bank-accounts.show');
    Route::get('/bank-accounts/{id}/edit', 'BankAccountController@edit')->name('accounting-reports.bank-accounts.edit');
    Route::put('/bank-accounts/{id}', 'BankAccountController@update')->name('accounting-reports.bank-accounts.update');
    Route::delete('/bank-accounts/{id}', 'BankAccountController@destroy')->name('accounting-reports.bank-accounts.destroy');
    Route::get('/bank-accounts/{id}/ledger', 'BankAccountController@ledger')->name('accounting-reports.bank-accounts.ledger');
    Route::get('/bank-accounts/{id}/ledger/get-data', 'BankAccountController@getLedgerData')->name('accounting-reports.bank-accounts.ledger.get-data');
    Route::get('/bank-accounts/{id}/manage', 'BankAccountController@manage')->name('accounting-reports.bank-accounts.manage');
    Route::get('/bank-accounts/{id}/reconciliation/get-data', 'BankAccountController@getReconciliationData')->name('accounting-reports.bank-accounts.reconciliation.get-data');
    Route::post('/bank-accounts/reconciliation/mark', 'BankAccountController@markReconciled')->name('accounting-reports.bank-accounts.reconciliation.mark');
    Route::get('/bank-accounts/{id}/cheque-numbers/get-data', 'BankAccountController@getChequeNumbersData')->name('accounting-reports.bank-accounts.cheque-numbers.get-data');
    
    // Loan Management
    Route::get('/loans', 'LoanController@index')->name('accounting-reports.loans.index');
    Route::get('/loans/get-data', 'LoanController@getData')->name('accounting-reports.loans.get-data');
    Route::get('/loans/create', 'LoanController@create')->name('accounting-reports.loans.create');
    Route::post('/loans', 'LoanController@store')->name('accounting-reports.loans.store');
    Route::get('/loans/{id}', 'LoanController@show')->name('accounting-reports.loans.show');
    Route::get('/loans/{id}/edit', 'LoanController@edit')->name('accounting-reports.loans.edit');
    Route::put('/loans/{id}', 'LoanController@update')->name('accounting-reports.loans.update');
    Route::delete('/loans/{id}', 'LoanController@destroy')->name('accounting-reports.loans.destroy');
    Route::get('/loans/{id}/ledger', 'LoanController@ledger')->name('accounting-reports.loans.ledger');
    Route::get('/loans/transactions/{transaction_id}', 'LoanController@showTransaction')->name('accounting-reports.loans.transactions.show');
    Route::post('/loans/{id}/take-loan', 'LoanController@takeLoan')->name('accounting-reports.loans.take-loan');
    Route::post('/loans/{id}/repayment', 'LoanController@repayment')->name('accounting-reports.loans.repayment');
});


