<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.loan_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th width="40%">@lang('accounting-reports::lang.loan_number')</th>
                            <td>{{ $loan->loan_number }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.loan_name')</th>
                            <td><strong>{{ $loan->loan_name }}</strong></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.description')</th>
                            <td>{{ $loan->description ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.loan_amount')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $loan->loan_amount }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.loan_date')</th>
                            <td>{{ @format_date($loan->loan_date) }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.maturity_date')</th>
                            <td>{{ $loan->maturity_date ? @format_date($loan->maturity_date) : '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.interest_rate')</th>
                            <td>{{ $loan->interest_rate }}% ({{ ucfirst($loan->interest_type) }})</td>
                        </tr>
                        <tr>
                            <th>@lang('purchase.business_location')</th>
                            <td>{{ $loan->location ? $loan->location->name : __('lang_v1.all') }}</td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th width="40%">@lang('accounting-reports::lang.lender_name')</th>
                            <td>{{ $loan->lender_name }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.lender_contact')</th>
                            <td>{{ $loan->lender_contact ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.lender_address')</th>
                            <td>{{ $loan->lender_address ?? '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.liability_account')</th>
                            <td>{{ $loan->liabilityAccount ? $loan->liabilityAccount->name : '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.outstanding_principal')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $loan->outstanding_principal }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.principal_paid')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $loan->principal_paid }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.interest_paid')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $loan->interest_paid }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.status')</th>
                            <td>
                                @if($loan->status == 'active')
                                    <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                                @elseif($loan->status == 'closed')
                                    <span class="label label-default">@lang('lang_v1.closed')</span>
                                @else
                                    <span class="label label-danger">@lang('accounting-reports::lang.defaulted')</span>
                                @endif
                            </td>
                        </tr>
                        @if($loan->document)
                        <tr>
                            <th>@lang('purchase.attach_document')</th>
                            <td>
                                <a href="{{ asset('uploads/documents/' . $loan->document) }}" target="_blank">
                                    <i class="fa fa-file"></i> @lang('lang_v1.view_uploaded_document')
                                </a>
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <th>@lang('messages.created_by')</th>
                            <td>{{ $loan->creator ? $loan->creator->user_full_name : '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('messages.created_at')</th>
                            <td>{{ @format_datetime($loan->created_at) }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

