<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.loan_transaction_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th width="40%">@lang('accounting-reports::lang.transaction_number')</th>
                            <td><strong>{{ $transaction->transaction_number }}</strong></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.transaction_type')</th>
                            <td>
                                @php
                                    $types = [
                                        'loan_receipt' => __('accounting-reports::lang.loan_receipt'),
                                        'principal_repayment' => __('accounting-reports::lang.principal_repayment'),
                                        'interest_payment' => __('accounting-reports::lang.interest_payment'),
                                        'full_repayment' => __('accounting-reports::lang.full_repayment')
                                    ];
                                @endphp
                                {{ $types[$transaction->transaction_type] ?? $transaction->transaction_type }}
                            </td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.transaction_date')</th>
                            <td>{{ @format_date($transaction->transaction_date) }}</td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.loan_name')</th>
                            <td>
                                @if($transaction->loan)
                                    <a href="{{ action([\Modules\AccountingReports\Http\Controllers\LoanController::class, 'show'], [$transaction->loan->id]) }}" target="_blank">
                                        {{ $transaction->loan->loan_name }} ({{ $transaction->loan->loan_number }})
                                    </a>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.principal_amount')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $transaction->principal_amount }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.interest_amount')</th>
                            <td><span class="display_currency" data-currency_symbol="true">{{ $transaction->interest_amount }}</span></td>
                        </tr>
                        <tr>
                            <th>@lang('accounting-reports::lang.total_amount')</th>
                            <td><strong><span class="display_currency" data-currency_symbol="true">{{ $transaction->total_amount }}</span></strong></td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <table class="table table-bordered">
                        <tr>
                            <th width="40%">@lang('account.account')</th>
                            <td>
                                @if($transaction->paymentAccount)
                                    <a href="{{ action([\App\Http\Controllers\AccountController::class, 'show'], [$transaction->paymentAccount->id]) }}" target="_blank">
                                        {{ $transaction->paymentAccount->name }}
                                    </a>
                                @else
                                    -
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>@lang('lang_v1.payment_method')</th>
                            <td>{{ $transaction->payment_method ?? '-' }}</td>
                        </tr>
                        @if($transaction->cheque_number)
                        <tr>
                            <th>@lang('accounting-reports::lang.cheque_number')</th>
                            <td>{{ $transaction->cheque_number }}</td>
                        </tr>
                        @endif
                        @if($transaction->bank_name)
                        <tr>
                            <th>@lang('accounting-reports::lang.bank_name')</th>
                            <td>{{ $transaction->bank_name }}</td>
                        </tr>
                        @endif
                        <tr>
                            <th>@lang('accounting-reports::lang.reference_no')</th>
                            <td>{{ $transaction->reference_no ?? '-' }}</td>
                        </tr>
                        @if($transaction->notes)
                        <tr>
                            <th>@lang('lang_v1.note')</th>
                            <td>{{ $transaction->notes }}</td>
                        </tr>
                        @endif
                        @if($transaction->document)
                        <tr>
                            <th>@lang('purchase.attach_document')</th>
                            <td>
                                <a href="{{ asset('uploads/documents/' . $transaction->document) }}" target="_blank">
                                    <i class="fa fa-file"></i> @lang('lang_v1.view_uploaded_document')
                                </a>
                            </td>
                        </tr>
                        @endif
                        <tr>
                            <th>@lang('messages.created_by')</th>
                            <td>{{ $transaction->creator ? $transaction->creator->user_full_name : '-' }}</td>
                        </tr>
                        <tr>
                            <th>@lang('messages.created_at')</th>
                            <td>{{ @format_datetime($transaction->created_at) }}</td>
                        </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>





