@extends('layouts.app')

@section('title', __('accounting-reports::lang.loan_ledger'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.loan_ledger')</h1>
</section>

<!-- Main content -->
<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('accounting-reports::lang.loan_details')</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">@lang('accounting-reports::lang.loan_number')</th>
                                    <td>{{ $loan->loan_number }}</td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.loan_name')</th>
                                    <td><strong>{{ $loan->loan_name }}</strong></td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.lender_name')</th>
                                    <td>{{ $loan->lender_name }}</td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.loan_amount')</th>
                                    <td><span class="display_currency" data-currency_symbol="true">{{ $loan->loan_amount }}</span></td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th width="40%">@lang('accounting-reports::lang.outstanding_principal')</th>
                                    <td><span class="display_currency" data-currency_symbol="true">{{ $loan->outstanding_principal }}</span></td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.principal_paid')</th>
                                    <td><span class="display_currency" data-currency_symbol="true">{{ $loan->principal_paid }}</span></td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.interest_paid')</th>
                                    <td><span class="display_currency" data-currency_symbol="true">{{ $loan->interest_paid }}</span></td>
                                </tr>
                                <tr>
                                    <th>@lang('accounting-reports::lang.liability_account')</th>
                                    <td>
                                        @if($loan->liabilityAccount)
                                            <a href="{{ action([\App\Http\Controllers\AccountController::class, 'show'], [$loan->liabilityAccount->id]) }}" target="_blank">
                                                {{ $loan->liabilityAccount->name }}
                                            </a>
                                        @else
                                            -
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('accounting-reports::lang.transactions')</h3>
                    <div class="box-tools pull-right">
                        <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#take_loan_modal">
                            <i class="fa fa-plus"></i> @lang('accounting-reports::lang.take_loan')
                        </button>
                        <button type="button" class="btn btn-primary btn-sm" data-toggle="modal" data-target="#repayment_modal">
                            <i class="fa fa-money"></i> @lang('accounting-reports::lang.repayment')
                        </button>
                    </div>
                </div>
                <div class="box-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped table-hover" id="loan_transactions_table" style="width:100%;">
                            <thead>
                                <tr>
                                    <th>@lang('accounting-reports::lang.transaction_date')</th>
                                    <th>@lang('accounting-reports::lang.transaction_number')</th>
                                    <th>@lang('accounting-reports::lang.transaction_type')</th>
                                    <th>@lang('accounting-reports::lang.principal_amount')</th>
                                    <th>@lang('accounting-reports::lang.interest_amount')</th>
                                    <th>@lang('accounting-reports::lang.total_amount')</th>
                                    <th>@lang('account.account')</th>
                                    <th>@lang('accounting-reports::lang.reference_no')</th>
                                    <th>@lang('messages.action')</th>
                                </tr>
                            </thead>
                            <tfoot>
                                <tr>
                                    <th colspan="3" style="text-align:right">@lang('sale.total'):</th>
                                    <th></th>
                                    <th></th>
                                    <th></th>
                                    <th colspan="3"></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Transaction Details Modal -->
<div class="modal fade" id="transaction_details_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" id="transaction_details_content">
            <!-- Content will be loaded via AJAX -->
        </div>
    </div>
</div>

<!-- Take Loan Modal -->
<div class="modal fade" id="take_loan_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\LoanController::class, 'takeLoan'], [$loan->id]), 'method' => 'POST', 'id' => 'take_loan_form']) !!}
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">@lang('accounting-reports::lang.take_loan')</h4>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('transaction_date', __('accounting-reports::lang.transaction_date') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </span>
                                {!! Form::text('transaction_date', @format_date('now'), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('principal_amount', __('accounting-reports::lang.principal_amount') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-money"></i>
                                </span>
                                {!! Form::text('principal_amount', null, ['class' => 'form-control input_number', 'required']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('payment_account_id', __('account.account') . ':*') !!}
                            {!! Form::select('payment_account_id', $payment_accounts, null, ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('payment_method', __('lang_v1.payment_method') . ':') !!}
                            {!! Form::select('payment_method', $payment_types ?? [], null, ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                            {!! Form::text('reference_no', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group">
                            {!! Form::label('notes', __('lang_v1.note') . ':') !!}
                            {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => '2']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
                <button type="submit" class="btn btn-success">@lang('messages.save')</button>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>

<!-- Repayment Modal -->
<div class="modal fade" id="repayment_modal" tabindex="-1" role="dialog">
    <div class="modal-dialog">
        <div class="modal-content">
            {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\LoanController::class, 'repayment'], [$loan->id]), 'method' => 'POST', 'id' => 'repayment_form']) !!}
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title">@lang('accounting-reports::lang.repayment')</h4>
            </div>
            <div class="modal-body">
                <div class="alert alert-info">
                    <strong>@lang('accounting-reports::lang.outstanding_principal'):</strong> 
                    <span class="display_currency" data-currency_symbol="true">{{ $loan->outstanding_principal }}</span>
                </div>
                <div class="row">
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('transaction_date', __('accounting-reports::lang.transaction_date') . ':*') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </span>
                                {!! Form::text('transaction_date', @format_date('now'), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('payment_account_id', __('account.account') . ':*') !!}
                            {!! Form::select('payment_account_id', $payment_accounts, null, ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('principal_amount', __('accounting-reports::lang.principal_amount') . ':') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-money"></i>
                                </span>
                                {!! Form::text('principal_amount', null, ['class' => 'form-control input_number', 'placeholder' => '0.00']) !!}
                            </div>
                            <p class="help-block">@lang('accounting-reports::lang.principal_repayment_help')</p>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('interest_amount', __('accounting-reports::lang.interest_amount') . ':') !!}
                            <div class="input-group">
                                <span class="input-group-addon">
                                    <i class="fa fa-money"></i>
                                </span>
                                {!! Form::text('interest_amount', null, ['class' => 'form-control input_number', 'placeholder' => '0.00']) !!}
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('payment_method', __('lang_v1.payment_method') . ':') !!}
                            {!! Form::select('payment_method', $payment_types ?? [], null, ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('cheque_number', __('accounting-reports::lang.cheque_number') . ':') !!}
                            {!! Form::text('cheque_number', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.cheque_number')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('bank_name', __('accounting-reports::lang.bank_name') . ':') !!}
                            {!! Form::text('bank_name', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_name')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-6">
                        <div class="form-group">
                            {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                            {!! Form::text('reference_no', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                        </div>
                    </div>
                    <div class="col-sm-12">
                        <div class="form-group">
                            {!! Form::label('notes', __('lang_v1.note') . ':') !!}
                            {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => '2']) !!}
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
                <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
            </div>
            {!! Form::close() !!}
        </div>
    </div>
</div>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var loan_transactions_table = $('#loan_transactions_table').DataTable({
            processing: true,
            serverSide: false,
            data: @json($formattedTransactions ?? []),
            columns: [
                { 
                    data: 'transaction_date', 
                    name: 'transaction_date',
                    render: function(data) {
                        return moment(data).format('DD-MMM-YYYY');
                    }
                },
                { data: 'transaction_number', name: 'transaction_number' },
                { 
                    data: 'transaction_type', 
                    name: 'transaction_type',
                    render: function(data) {
                        var types = {
                            'loan_receipt': '@lang("accounting-reports::lang.loan_receipt")',
                            'principal_repayment': '@lang("accounting-reports::lang.principal_repayment")',
                            'interest_payment': '@lang("accounting-reports::lang.interest_payment")',
                            'full_repayment': '@lang("accounting-reports::lang.full_repayment")'
                        };
                        return types[data] || data;
                    }
                },
                { 
                    data: 'principal_amount', 
                    name: 'principal_amount',
                    render: function(data) {
                        return __currency_trans_from_en(data || 0, true);
                    }
                },
                { 
                    data: 'interest_amount', 
                    name: 'interest_amount',
                    render: function(data) {
                        return __currency_trans_from_en(data || 0, true);
                    }
                },
                { 
                    data: 'total_amount', 
                    name: 'total_amount',
                    render: function(data) {
                        return __currency_trans_from_en(data || 0, true);
                    }
                },
                { 
                    data: 'payment_account', 
                    name: 'payment_account_id',
                    render: function(data, type, row) {
                        return row.payment_account ? row.payment_account.name : '-';
                    }
                },
                { data: 'reference_no', name: 'reference_no' },
                { 
                    data: null, 
                    name: 'action', 
                    orderable: false, 
                    searchable: false,
                    render: function(data, type, row) {
                        return '<button type="button" class="btn btn-info btn-xs view_transaction" data-id="' + row.id + '"><i class="fa fa-eye"></i></button>';
                    }
                }
            ],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };
                
                var total_principal = api.column(3).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                var total_interest = api.column(4).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                var total_amount = api.column(5).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                $(api.column(3).footer()).html(__currency_trans_from_en(total_principal, true));
                $(api.column(4).footer()).html(__currency_trans_from_en(total_interest, true));
                $(api.column(5).footer()).html(__currency_trans_from_en(total_amount, true));
            },
            order: [[0, 'desc']]
        });

        // Initialize date pickers using UltimatePOS pattern
        $('.date-picker').datepicker({
            autoclose: true,
            format: datepicker_date_format
        });
        $('.select2').select2({width: '100%'});

        // Payment types already available in global scope

        $(document).on('submit', '#take_loan_form', function(e) {
            e.preventDefault();
            $.ajax({
                method: 'POST',
                url: $(this).attr('action'),
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#take_loan_modal').modal('hide');
                        toastr.success(response.msg);
                        location.reload();
                    } else {
                        toastr.error(response.msg);
                    }
                }
            });
        });

        $(document).on('submit', '#repayment_form', function(e) {
            e.preventDefault();
            $.ajax({
                method: 'POST',
                url: $(this).attr('action'),
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        $('#repayment_modal').modal('hide');
                        toastr.success(response.msg);
                        location.reload();
                    } else {
                        toastr.error(response.msg);
                    }
                }
            });
        });

        // View transaction details
        $(document).on('click', '.view_transaction', function(e) {
            e.preventDefault();
            var transaction_id = $(this).data('id');
            
            $('#transaction_details_modal').modal('show');
            $('#transaction_details_content').html('<div class="text-center" style="padding: 50px;"><i class="fa fa-spinner fa-spin fa-3x"></i><p>@lang("lang_v1.loading")</p></div>');
            
            $.ajax({
                url: '{{ route("accounting-reports.loans.transactions.show", ":id") }}'.replace(':id', transaction_id),
                type: 'GET',
                success: function(response) {
                    $('#transaction_details_content').html(response);
                },
                error: function(xhr) {
                    $('#transaction_details_content').html('<div class="alert alert-danger">@lang("messages.something_went_wrong")</div>');
                }
            });
        });
    });
</script>
@endsection

