@extends('layouts.app')

@section('title', __('accounting-reports::lang.loan_management'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.loan_management')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\LoanController::class, 'create']) }}" data-container=".loan_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_loan')
                    </button>
                </div>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_location_id', __('purchase.business_location') . ':') !!}
                    {!! Form::select('filter_location_id', $locations, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all')]) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_status', __('accounting-reports::lang.status') . ':') !!}
                    {!! Form::select('filter_status', ['active' => __('accounting-reports::lang.active'), 'closed' => __('lang_v1.closed'), 'defaulted' => __('accounting-reports::lang.defaulted')], null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all')]) !!}
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="loans_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.loan_number')</th>
                        <th>@lang('accounting-reports::lang.loan_name')</th>
                        <th>@lang('accounting-reports::lang.lender_name')</th>
                        <th>@lang('accounting-reports::lang.loan_amount')</th>
                        <th>@lang('accounting-reports::lang.outstanding_principal')</th>
                        <th>@lang('accounting-reports::lang.loan_date')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.liability_account')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="3" style="text-align:right">@lang('sale.total'):</th>
                        <th></th>
                        <th></th>
                        <th colspan="4"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade loan_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var loans_table = $('#loans_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\LoanController::class, "getData"]) }}',
                data: function(d) {
                    d.location_id = $('#filter_location_id').val();
                    d.status = $('#filter_status').val();
                }
            },
            columns: [
                { data: 'loan_number', name: 'loan_number' },
                { data: 'loan_name', name: 'loan_name' },
                { data: 'lender_name', name: 'lender_name' },
                { data: 'loan_amount', name: 'loan_amount' },
                { data: 'outstanding_principal', name: 'outstanding_principal' },
                { data: 'loan_date', name: 'loan_date' },
                { data: 'status', name: 'status' },
                { data: 'liability_account', name: 'liability_account_id' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };
                
                var total_loan = api.column(3).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                var total_outstanding = api.column(4).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                $(api.column(3).footer()).html(__currency_trans_from_en(total_loan, true));
                $(api.column(4).footer()).html(__currency_trans_from_en(total_outstanding, true));
            }
        });

        $('#filter_location_id, #filter_status').on('change', function() {
            loans_table.ajax.reload();
        });

        $(document).on('click', '.edit_loan', function(e) {
            e.preventDefault();
            var modal = $('div.loan_modal');
            modal.load($(this).data('href'), function() {
                modal.modal('show');
            });
            
            // Handle form submission
            modal.off('submit', 'form#loan_form').on('submit', 'form#loan_form', function(e) {
                e.preventDefault();
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            modal.modal('hide');
                            toastr.success(response.msg);
                            loans_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            });
        });

        $(document).on('click', '.view_loan', function(e) {
            e.preventDefault();
            $('div.loan_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.ledger_loan', function(e) {
            e.preventDefault();
            window.location.href = $(this).data('href');
        });

        $(document).on('click', '.delete_loan', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: LANG.confirm_delete_loan,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                loans_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_loan_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: new FormData(this),
                    processData: false,
                    contentType: false,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.loan_modal').modal('hide');
                            toastr.success(response.msg);
                            loans_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize date pickers when modal opens
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            var modal = $('div.loan_modal');
            modal.load($(this).data('href'), function() {
                modal.modal('show');
            });
        });
        
        // Re-initialize date pickers when modal is shown (UltimatePOS pattern)
        $('div.loan_modal').on('shown.bs.modal', function(e) {
            var modal = $(this);
            // Initialize date pickers within the modal
            modal.find('.date-picker').datepicker({
                autoclose: true,
                format: datepicker_date_format
            });
            // Initialize select2
            modal.find('.select2').select2({width: '100%'});
            // Initialize input number formatting
            if (typeof $.fn.inputmask !== 'undefined') {
                modal.find('.input_number').inputmask('decimal', {
                    radixPoint: ".",
                    groupSeparator: ",",
                    digits: 2,
                    autoGroup: true,
                    rightAlign: true,
                    oncleared: function () { this.value = ''; }
                });
            }
        });
    });
</script>
@endsection

