<div class="modal-dialog">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\LoanController::class, 'store']), 'method' => 'post', 'id' => 'add_loan_form', 'files' => true]) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.add_loan')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('loan_name', __('accounting-reports::lang.loan_name') . ':*') !!}
                        {!! Form::text('loan_name', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.loan_name')]) !!}
                        <p class="help-block">@lang('accounting-reports::lang.loan_name_help')</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('loan_amount', __('accounting-reports::lang.loan_amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('loan_amount', null, ['class' => 'form-control input_number', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('loan_date', __('accounting-reports::lang.loan_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('loan_date', @format_date('now'), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('interest_rate', __('accounting-reports::lang.interest_rate') . ':') !!}
                        <div class="input-group">
                            {!! Form::text('interest_rate', 0, ['class' => 'form-control input_number', 'placeholder' => '0.00']) !!}
                            <span class="input-group-addon">%</span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('interest_type', __('accounting-reports::lang.interest_type') . ':') !!}
                        {!! Form::select('interest_type', ['flat' => __('accounting-reports::lang.flat'), 'reducing' => __('accounting-reports::lang.reducing')], 'flat', ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('maturity_date', __('accounting-reports::lang.maturity_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('maturity_date', null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <hr>
                    <h4>@lang('accounting-reports::lang.lender_information')</h4>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('lender_name', __('accounting-reports::lang.lender_name') . ':*') !!}
                        {!! Form::text('lender_name', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.lender_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('lender_contact', __('accounting-reports::lang.lender_contact') . ':') !!}
                        {!! Form::text('lender_contact', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.lender_contact')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('lender_address', __('accounting-reports::lang.lender_address') . ':') !!}
                        {!! Form::textarea('lender_address', null, ['class' => 'form-control', 'rows' => '2', 'placeholder' => __('accounting-reports::lang.lender_address')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <hr>
                    <h4>@lang('accounting-reports::lang.account_information')</h4>
                </div>
                <div class="col-sm-12">
                    <div class="alert alert-info">
                        <i class="fa fa-info-circle"></i> @lang('accounting-reports::lang.liability_account_auto_created')
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payment_account_id', __('accounting-reports::lang.payment_account') . ':') !!}
                        {!! Form::select('payment_account_id', $payment_accounts, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                        <p class="help-block">@lang('accounting-reports::lang.payment_account_help')</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                        {!! Form::text('reference_no', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('document', __('purchase.attach_document') . ':') !!}
                        {!! Form::file('document', ['class' => 'form-control', 'accept' => 'image/*,.pdf,.doc,.docx,.xls,.xlsx']) !!}
                        <p class="help-block">@lang('lang_v1.max_file_size_10mb')</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date pickers using UltimatePOS pattern
        $('.date-picker').datepicker({
            autoclose: true,
            format: datepicker_date_format
        });
        
        // Initialize select2
        $('.select2').select2({width: '100%'});
        
        // Initialize input number formatting
        if (typeof $.fn.inputmask !== 'undefined') {
            $('.input_number').inputmask('decimal', {
                radixPoint: ".",
                groupSeparator: ",",
                digits: 2,
                autoGroup: true,
                rightAlign: true,
                oncleared: function () { this.value = ''; }
            });
        }
    });
</script>

