@extends('layouts.app')

@section('title', __('accounting-reports::lang.investments'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.investments')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\InvestmentController::class, 'create']) }}" data-container=".investment_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_investment')
                    </button>
                </div>
            </div>
        </div>
        <br>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="investments_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.name')</th>
                        <th>@lang('accounting-reports::lang.description')</th>
                        <th>@lang('accounting-reports::lang.investment_date')</th>
                        <th>@lang('accounting-reports::lang.amount')</th>
                        <th>@lang('accounting-reports::lang.current_value')</th>
                        <th>@lang('accounting-reports::lang.investment_type')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.created_at')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade investment_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('.date-picker').datepicker({
            autoclose: true,
            format: datepicker_date_format
        });
        
        var investments_table = $('#investments_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\InvestmentController::class, "getData"]) }}',
                data: function(d) {
                    d.is_active = $('#filter_is_active').val();
                }
            },
            columns: [
                { data: 'name', name: 'name' },
                { data: 'description', name: 'description' },
                { data: 'investment_date', name: 'investment_date' },
                { data: 'amount', name: 'amount' },
                { data: 'current_value', name: 'current_value' },
                { data: 'investment_type', name: 'investment_type' },
                { data: 'is_active', name: 'is_active' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        $(document).on('click', '.edit_investment', function(e) {
            e.preventDefault();
            $('div.investment_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('form#investment_form').submit(function(e) {
                    e.preventDefault();
                    $.ajax({
                        method: 'POST',
                        url: $(this).attr('action'),
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                $('div.investment_modal').modal('hide');
                                toastr.success(response.msg);
                                investments_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                });
            });
        });

        $(document).on('click', '.view_investment', function(e) {
            e.preventDefault();
            $('div.investment_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.delete_investment', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: '{{ __("accounting-reports::lang.confirm_delete_investment") }}',
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                investments_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_investment_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.investment_modal').modal('hide');
                            toastr.success(response.msg);
                            investments_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize modal
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            $('div.investment_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                // Initialize date picker and select2 in modal
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
                $('.select2').select2();
            });
        });
        
        // Initialize date picker and select2 when edit modal loads
        $(document).on('click', '.edit_investment', function(e) {
            setTimeout(function() {
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
                $('.select2').select2();
            }, 100);
        });
    });
</script>
@endsection

