<div class="modal-dialog">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\InvestmentController::class, 'update'], [$investment->id]), 'method' => 'put', 'id' => 'investment_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.edit_investment')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('name', __('accounting-reports::lang.investment_name') . ':*') !!}
                        {!! Form::text('name', $investment->name, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.investment_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', $investment->description, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('investment_date', __('accounting-reports::lang.investment_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('investment_date', !empty($investment->investment_date) ? @format_date($investment->investment_date) : null, ['class' => 'form-control date-picker', 'readonly', 'placeholder' => __('accounting-reports::lang.investment_date')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('investment_type', __('accounting-reports::lang.investment_type') . ':') !!}
                        {!! Form::select('investment_type', [
                            '' => __('messages.please_select'),
                            'stocks' => __('accounting-reports::lang.stocks'),
                            'bonds' => __('accounting-reports::lang.bonds'),
                            'mutual_funds' => __('accounting-reports::lang.mutual_funds'),
                            'commodities' => __('accounting-reports::lang.commodities'),
                            'real_estate' => __('accounting-reports::lang.real_estate'),
                            'other' => __('accounting-reports::lang.other')
                        ], $investment->investment_type, ['class' => 'form-control select2', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('accounting-reports::lang.amount') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('amount', $investment->amount, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.amount')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('current_value', __('accounting-reports::lang.current_value') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('current_value', $investment->current_value, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.current_value')]) !!}
                        </div>
                        <small class="help-block">@lang('accounting-reports::lang.current_value_help')</small>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('is_active', 1, $investment->is_active) !!}
                                @lang('accounting-reports::lang.active')
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

