<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.fixed_asset_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.asset_name'):</strong></label>
                        <p>{{ $fixed_asset->name }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.description'):</strong></label>
                        <p>{{ $fixed_asset->description ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.purchase_date'):</strong></label>
                        <p>{{ !empty($fixed_asset->purchase_date) ? @format_date($fixed_asset->purchase_date) : '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.amount'):</strong></label>
                        <p><span class="display_currency" data-currency_symbol="true">{{ $fixed_asset->amount }}</span></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.depreciation_percentage'):</strong></label>
                        <p>{{ !empty($fixed_asset->depreciation_percentage) ? number_format($fixed_asset->depreciation_percentage, 2) . '%' : '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.status'):</strong></label>
                        <p>
                            @if($fixed_asset->is_active)
                                <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                            @else
                                <span class="label label-danger">@lang('accounting-reports::lang.inactive')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.created_at'):</strong></label>
                        <p>{{ @format_date($fixed_asset->created_at) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

