@extends('layouts.app')

@section('title', __('accounting-reports::lang.fixed_assets'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.fixed_assets')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\FixedAssetController::class, 'create']) }}" data-container=".fixed_asset_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_fixed_asset')
                    </button>
                </div>
            </div>
        </div>
        <br>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="fixed_assets_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.name')</th>
                        <th>@lang('accounting-reports::lang.description')</th>
                        <th>@lang('accounting-reports::lang.purchase_date')</th>
                        <th>@lang('accounting-reports::lang.amount')</th>
                        <th>@lang('accounting-reports::lang.depreciation_percentage')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.created_at')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade fixed_asset_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        // Initialize date picker
        $('.date-picker').datepicker({
            autoclose: true,
            format: datepicker_date_format
        });
        
        var fixed_assets_table = $('#fixed_assets_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\FixedAssetController::class, "getData"]) }}',
                data: function(d) {
                    d.is_active = $('#filter_is_active').val();
                }
            },
            columns: [
                { data: 'name', name: 'name' },
                { data: 'description', name: 'description' },
                { data: 'purchase_date', name: 'purchase_date' },
                { data: 'amount', name: 'amount' },
                { data: 'depreciation_percentage', name: 'depreciation_percentage' },
                { data: 'is_active', name: 'is_active' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        $(document).on('click', '.edit_asset', function(e) {
            e.preventDefault();
            $('div.fixed_asset_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('form#fixed_asset_form').submit(function(e) {
                    e.preventDefault();
                    $.ajax({
                        method: 'POST',
                        url: $(this).attr('action'),
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                $('div.fixed_asset_modal').modal('hide');
                                toastr.success(response.msg);
                                fixed_assets_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                });
            });
        });

        $(document).on('click', '.view_asset', function(e) {
            e.preventDefault();
            $('div.fixed_asset_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.delete_asset', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: '{{ __("accounting-reports::lang.confirm_delete_asset") }}',
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                fixed_assets_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_fixed_asset_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.fixed_asset_modal').modal('hide');
                            toastr.success(response.msg);
                            fixed_assets_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize modal
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            $('div.fixed_asset_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                // Initialize date picker in modal
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
            });
        });
        
        // Initialize date picker when edit modal loads
        $(document).on('click', '.edit_asset', function(e) {
            setTimeout(function() {
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
            }, 100);
        });
    });
</script>
@endsection

