@extends('layouts.app')

@section('title', __('accounting-reports::lang.fixed_assets_report'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.fixed_assets_report')</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">Filters</h3>
                </div>
                <div class="box-body">
                    <form id="filter-form">
                        <div class="row">
                            <div class="col-sm-3 col-xs-6">
                                <div class="form-group">
                                    <label for="as_of_date">@lang('accounting-reports::lang.as_on_date'):</label>
                                    <div class="input-group">
                                        <span class="input-group-addon">
                                            <i class="fa fa-calendar"></i>
                                        </span>
                                        <input type="text" id="as_of_date" value="{{ @format_date('now') }}" class="form-control" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>&nbsp;</label><br>
                                    <button type="button" id="generate-btn" class="btn btn-primary">
                                        <i class="fa fa-refresh"></i> @lang('accounting-reports::lang.view')
                                    </button>
                                    <button type="button" id="export-btn" class="btn btn-success">
                                        <i class="fa fa-download"></i> @lang('accounting-reports::lang.export')
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">Fixed Assets Report</h3>
                </div>
                <div class="box-body">
                    <div id="loading" style="display:none; text-align:center; padding:20px;">
                        <i class="fa fa-spinner fa-spin fa-3x"></i>
                        <p>Loading report...</p>
                    </div>
                    <div id="report-content" style="display:none;">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 id="business-name" style="text-align:center; margin-bottom:10px;"></h4>
                                <p id="as-on-date" style="text-align:center; margin-bottom:20px;"></p>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped" id="report-table">
                                <thead>
                                    <tr style="background-color:#f0f0f0;">
                                        <th>@lang('accounting-reports::lang.asset_name')</th>
                                        <th>@lang('accounting-reports::lang.purchase_date')</th>
                                        <th>@lang('accounting-reports::lang.original_cost')</th>
                                        <th>@lang('accounting-reports::lang.revaluation_total')</th>
                                        <th>@lang('accounting-reports::lang.current_book_value')</th>
                                        <th>@lang('accounting-reports::lang.depreciation_percentage')</th>
                                        <th>@lang('accounting-reports::lang.annual_depreciation')</th>
                                        <th>@lang('accounting-reports::lang.accumulated_depreciation')</th>
                                        <th>@lang('accounting-reports::lang.net_book_value')</th>
                                    </tr>
                                </thead>
                                <tbody id="report-tbody"></tbody>
                                <tfoot id="report-tfoot" style="background-color:#f9f9f9; font-weight:bold;"></tfoot>
                            </table>
                        </div>
                    </div>
                    <div id="error-message" style="display:none;" class="alert alert-danger"></div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@section('javascript')
<script>
$(document).ready(function() {
    // Initialize date picker
    $('#as_of_date').datepicker({
        autoclose: true,
        format: datepicker_date_format
    });

    // Load on page load
    loadReport();

    $('#as_of_date').change(function() {
        loadReport();
    });

    $('#generate-btn').click(function() {
        loadReport();
    });

    $('#export-btn').click(function() {
        exportReport();
    });

    function loadReport() {
        var as_of_date = $('#as_of_date').val();

        if (!as_of_date) {
            toastr.error('Please select as on date');
            return;
        }

        $('#loading').show();
        $('#report-content').hide();
        $('#error-message').hide();

        $.ajax({
            url: "{{ action([\Modules\AccountingReports\Http\Controllers\FixedAssetsReportController::class, 'getData']) }}",
            data: {
                as_of_date: as_of_date
            },
            dataType: 'json',
            success: function(response) {
                $('#loading').hide();
                
                if (response.success === false) {
                    $('#error-message').text(response.error || 'Error loading report').show();
                    return;
                }

                if (response.data && response.data.length > 0) {
                    displayReport(response);
                    $('#report-content').show();
                } else {
                    $('#error-message').text('No data available for the selected date').show();
                }
            },
            error: function(xhr, status, error) {
                $('#loading').hide();
                var errorMsg = 'Error loading report';
                if (xhr.responseJSON && xhr.responseJSON.error) {
                    errorMsg = xhr.responseJSON.error;
                }
                $('#error-message').text(errorMsg).show();
            }
        });
    }

    function displayReport(data) {
        // Set business name and date
        $('#business-name').text(data.business_name || '');
        
        var asOnDate = data.as_of_date;
        var formattedDate = moment(asOnDate).format('DD-MMM-YYYY');
        $('#as-on-date').text('As on ' + formattedDate);

        // Clear existing content
        $('#report-tbody').empty();
        $('#report-tfoot').empty();

        // Render rows
        $.each(data.data, function(index, asset) {
            var row = $('<tr>');
            row.append($('<td>').text(asset.name));
            row.append($('<td>').text(asset.purchase_date));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.original_cost + '</span>'));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.revaluation_total + '</span>'));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.current_book_value + '</span>'));
            row.append($('<td>').text(asset.depreciation_percentage ? asset.depreciation_percentage + '%' : '-'));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.annual_depreciation + '</span>'));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.accumulated_depreciation + '</span>'));
            row.append($('<td>').html('<span class="display_currency" data-currency_symbol="true">' + asset.net_book_value + '</span>'));
            $('#report-tbody').append(row);
        });

        // Render totals
        var totals = data.totals;
        var footerRow = $('<tr>');
        footerRow.append($('<td>').html('<strong>Total</strong>').attr('colspan', 2));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.original_cost + '</span></strong>'));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.revaluation_total + '</span></strong>'));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.current_book_value + '</span></strong>'));
        footerRow.append($('<td>').html('<strong>-</strong>'));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.annual_depreciation + '</span></strong>'));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.accumulated_depreciation + '</span></strong>'));
        footerRow.append($('<td>').html('<strong><span class="display_currency" data-currency_symbol="true">' + totals.net_book_value + '</span></strong>'));
        $('#report-tfoot').append(footerRow);
    }

    function exportReport() {
        var as_of_date = $('#as_of_date').val();

        if (!as_of_date) {
            toastr.error('Please select as on date');
            return;
        }

        var url = "{{ action([\Modules\AccountingReports\Http\Controllers\FixedAssetsReportController::class, 'export']) }}";
        url += '?as_of_date=' + as_of_date;
        
        window.location.href = url;
    }
});
</script>
@endsection

