<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.revaluation_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.asset_name'):</strong></label>
                        <p>{{ $revaluation->fixedAsset->name ?? '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.revaluation_date'):</strong></label>
                        <p>{{ @format_date($revaluation->revaluation_date) }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.previous_value'):</strong></label>
                        <p><span class="display_currency" data-currency_symbol="true">{{ $revaluation->previous_value }}</span></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.revaluation_amount'):</strong></label>
                        <p><span class="display_currency" data-currency_symbol="true">{{ $revaluation->revaluation_amount }}</span></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.revaluation_difference'):</strong></label>
                        <p>
                            <span class="display_currency {{ $revaluation->revaluation_difference >= 0 ? 'text-success' : 'text-danger' }}" data-currency_symbol="true">
                                {{ $revaluation->revaluation_difference }}
                            </span>
                        </p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.reason'):</strong></label>
                        <p>{{ $revaluation->reason ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.notes'):</strong></label>
                        <p>{{ $revaluation->notes ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.created_at'):</strong></label>
                        <p>{{ @format_date($revaluation->created_at) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

