<div class="modal-dialog modal-lg">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\FixedAssetRevaluationController::class, 'store']), 'method' => 'post', 'id' => 'add_revaluation_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.add_revaluation')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('fixed_asset_id', __('accounting-reports::lang.asset_name') . ':*') !!}
                        {!! Form::select('fixed_asset_id', $assets->pluck('name', 'id'), null, ['class' => 'form-control select2', 'required', 'style' => 'width:100%', 'placeholder' => __('accounting-reports::lang.select_asset'), 'id' => 'fixed_asset_id']) !!}
                        <small class="help-block">@lang('accounting-reports::lang.select_asset_first')</small>
                    </div>
                </div>
                
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('revaluation_date', __('accounting-reports::lang.revaluation_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('revaluation_date', null, ['class' => 'form-control date-picker', 'readonly', 'required', 'placeholder' => __('accounting-reports::lang.revaluation_date'), 'id' => 'revaluation_date']) !!}
                        </div>
                        <small class="help-block">@lang('accounting-reports::lang.select_date_to_show_asset_info')</small>
                    </div>
                </div>
                
                <!-- Auto-displayed Asset Information -->
                <div id="asset_info_section" style="display:none;">
                    <div class="col-sm-12">
                        <div class="alert alert-info" style="margin-bottom: 15px;">
                            <strong>@lang('accounting-reports::lang.asset_information'):</strong>
                            <div class="row" style="margin-top: 10px;">
                                <div class="col-sm-6">
                                    <strong>@lang('accounting-reports::lang.original_cost'):</strong> 
                                    <span id="display_original_amount" class="display_currency" data-currency_symbol="true">0.00</span>
                                </div>
                                <div class="col-sm-6">
                                    <strong>@lang('accounting-reports::lang.current_book_value'):</strong> 
                                    <span id="display_current_book_value" class="display_currency text-primary" data-currency_symbol="true" style="font-size: 16px; font-weight: bold;">0.00</span>
                                </div>
                                <div class="col-sm-6" style="margin-top: 5px;">
                                    <strong>@lang('accounting-reports::lang.net_book_value'):</strong> 
                                    <span id="display_net_book_value" class="display_currency" data-currency_symbol="true">0.00</span>
                                </div>
                                <div class="col-sm-6" style="margin-top: 5px;">
                                    <strong>@lang('accounting-reports::lang.depreciation_percentage'):</strong> 
                                    <span id="display_depreciation_percentage">0%</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('revaluation_amount', __('accounting-reports::lang.revaluation_amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('revaluation_amount', null, ['class' => 'form-control input_number', 'required', 'placeholder' => __('accounting-reports::lang.revaluation_amount'), 'id' => 'revaluation_amount']) !!}
                        </div>
                        <small class="help-block">@lang('accounting-reports::lang.new_book_value_after_revaluation')</small>
                        <div id="revaluation_difference_display" style="margin-top: 5px; display:none;">
                            <strong>@lang('accounting-reports::lang.revaluation_difference'):</strong> 
                            <span id="revaluation_difference_value" class="display_currency" data-currency_symbol="true" style="font-weight: bold;">0.00</span>
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('reason', __('accounting-reports::lang.reason') . ':') !!}
                        {!! Form::text('reason', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reason_for_revaluation')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('accounting-reports::lang.notes') . ':') !!}
                        {!! Form::textarea('notes', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.additional_notes')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

