<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.direct_income_details')</h4>
        </div>
        <div class="modal-body">
            <table class="table table-bordered">
                
                    <th>@lang('accounting-reports::lang.description')</th>
                    <td>{{ $direct_income->description ?? '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.amount')</th>
                    <td><span class="display_currency" data-currency_symbol="true">{{ $direct_income->amount }}</span></td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.income_date')</th>
                    <td>{{ @format_date($direct_income->income_date) }}</td>
                </tr>
                <tr>
                    <th>@lang('purchase.business_location')</th>
                    <td>{{ $direct_income->location ? $direct_income->location->name : __('lang_v1.all') }}</td>
                </tr>
                <tr>
                    <th>@lang('account.account')</th>
                    <td>{{ $direct_income->account ? $direct_income->account->name : '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('accounting-reports::lang.reference_no')</th>
                    <td>{{ $direct_income->reference_no ?? '-' }}</td>
                </tr>
                @if($direct_income->document)
                <tr>
                    <th>@lang('purchase.attach_document')</th>
                    <td>
                        <a href="{{ asset('uploads/documents/' . $direct_income->document) }}" target="_blank">
                            <i class="fa fa-file"></i> @lang('lang_v1.view_uploaded_document')
                        </a>
                    </td>
                </tr>
                @endif
                <tr>
                    <th>@lang('messages.created_by')</th>
                    <td>{{ $direct_income->creator ? $direct_income->creator->user_full_name : '-' }}</td>
                </tr>
                <tr>
                    <th>@lang('messages.created_at')</th>
                    <td>{{ @format_datetime($direct_income->created_at) }}</td>
                </tr>
            </table>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>


