<div class="modal-dialog">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.direct_income_name_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.income_name'):</strong></label>
                        <p>{{ $income_name->name }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.description'):</strong></label>
                        <p>{{ $income_name->description ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.status'):</strong></label>
                        <p>
                            @if($income_name->is_active)
                                <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                            @else
                                <span class="label label-danger">@lang('accounting-reports::lang.inactive')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.created_at'):</strong></label>
                        <p>{{ @format_date($income_name->created_at) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>


