@extends('layouts.app')

@section('title', __('accounting-reports::lang.direct_income_names'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.direct_income_names')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\DirectIncomeNameController::class, 'create']) }}" data-container=".income_name_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_direct_income_name')
                    </button>
                </div>
            </div>
        </div>
        <br>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="income_names_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.name')</th>
                        <th>@lang('accounting-reports::lang.description')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.created_at')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade income_name_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var income_names_table = $('#income_names_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\DirectIncomeNameController::class, "getData"]) }}',
                data: function(d) {
                    d.is_active = $('#filter_is_active').val();
                }
            },
            columns: [
                { data: 'name', name: 'name' },
                { data: 'description', name: 'description' },
                { data: 'is_active', name: 'is_active' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        $(document).on('click', '.edit_name', function(e) {
            e.preventDefault();
            $('div.income_name_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('form#income_name_form').submit(function(e) {
                    e.preventDefault();
                    $.ajax({
                        method: 'POST',
                        url: $(this).attr('action'),
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                $('div.income_name_modal').modal('hide');
                                toastr.success(response.msg);
                                income_names_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                });
            });
        });

        $(document).on('click', '.view_name', function(e) {
            e.preventDefault();
            $('div.income_name_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.delete_name', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: LANG.confirm_delete_income,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                income_names_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_income_name_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.income_name_modal').modal('hide');
                            toastr.success(response.msg);
                            income_names_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize modal
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            $('div.income_name_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });
    });
</script>
@endsection


