@extends('layouts.app')

@section('title', __('accounting-reports::lang.cheque_book_details'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.cheque_book_details') - {{ $chequeBook->book_name }}</h1>
</section>

<section class="content">
    <div class="row">
        <div class="col-md-4">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('accounting-reports::lang.cheque_book_details')</h3>
                </div>
                <div class="box-body">
                    <table class="table">
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.book_name'):</strong></td>
                            <td>{{ $chequeBook->book_name }}</td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.bank_account'):</strong></td>
                            <td>{{ $chequeBook->account->name ?? '-' }}</td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.cheque_range'):</strong></td>
                            <td>{{ $chequeBook->start_cheque_no }} - {{ $chequeBook->end_cheque_no }}</td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.total_cheques'):</strong></td>
                            <td>{{ $chequeBook->total_cheques }}</td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.used_cheques'):</strong></td>
                            <td><span class="label label-warning">{{ $chequeBook->used_cheques }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.remaining_cheques'):</strong></td>
                            <td><span class="label label-success">{{ $chequeBook->remaining_cheques }}</span></td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.status'):</strong></td>
                            <td>
                                @if($chequeBook->status == 'active')
                                    <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                                @elseif($chequeBook->status == 'completed')
                                    <span class="label label-info">Completed</span>
                                @else
                                    <span class="label label-default">@lang('accounting-reports::lang.cancelled')</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <td><strong>@lang('accounting-reports::lang.issue_date'):</strong></td>
                            <td>{{ $chequeBook->issue_date ? @format_date($chequeBook->issue_date) : '-' }}</td>
                        </tr>
                    </table>
                    
                    <div class="btn-group" style="width: 100%;">
                        <a href="{{ route('accounting-reports.cheque-books.edit', $chequeBook->id) }}" class="btn btn-primary">
                            <i class="fa fa-edit"></i> @lang('messages.edit')
                        </a>
                        <button type="button" class="btn btn-success generate-entries" data-href="{{ route('accounting-reports.cheque-books.generate-entries', $chequeBook->id) }}">
                            <i class="fa fa-plus"></i> @lang('accounting-reports::lang.generate_entries')
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-8">
            <div class="box box-solid">
                <div class="box-header with-border">
                    <h3 class="box-title">@lang('accounting-reports::lang.cheque_range')</h3>
                </div>
                <div class="box-body">
                    <div class="row">
                        @foreach($chequeSequence as $chequeNo)
                            @php
                                $chequeNoStr = (string) $chequeNo; // Ensure string type for comparison
                                $isUsed = in_array($chequeNoStr, $usedCheques, true); // Use strict comparison
                                $entry = $chequeBook->chequeEntries->firstWhere('cheque_no', $chequeNoStr);
                            @endphp
                            <div class="col-md-2" style="margin-bottom: 10px;">
                                <div class="cheque-box" style="border: 2px solid {{ $isUsed ? '#d9534f' : '#5cb85c' }}; padding: 10px; text-align: center; border-radius: 4px; background-color: {{ $isUsed ? '#f2dede' : '#dff0d8' }};">
                                    <strong>{{ $chequeNo }}</strong>
                                    @if($isUsed && $entry)
                                        <br><small style="color: #d9534f;">
                                            @if($entry->status == 'cleared')
                                                <span class="label label-success">Cleared</span>
                                            @elseif($entry->status == 'bounced')
                                                <span class="label label-danger">Bounced</span>
                                            @elseif($entry->status == 'pending')
                                                <span class="label label-warning">Pending</span>
                                            @else
                                                <span class="label label-default">{{ ucfirst($entry->status) }}</span>
                                            @endif
                                        </small>
                                        @if($entry->payee_name)
                                            <br><small>{{ $entry->payee_name }}</small>
                                        @endif
                                    @else
                                        <br><small style="color: #5cb85c;">@lang('accounting-reports::lang.available')</small>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection

@section('javascript')
<script>
$(document).ready(function() {
    $(document).on('click', '.generate-entries', function() {
        var url = $(this).data('href');
        
        swal({
            title: LANG.sure,
            text: '@lang("accounting-reports::lang.generate_all_entries_confirm")',
            icon: "info",
            buttons: true,
        }).then((confirmed) => {
            if (confirmed) {
                $.ajax({
                    method: 'POST',
                    url: url,
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            // Reload page after a short delay to ensure data is saved
                            setTimeout(function() {
                                location.reload();
                            }, 500);
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        var errorMsg = '@lang("messages.something_went_wrong")';
                        if (xhr.responseJSON && xhr.responseJSON.msg) {
                            errorMsg = xhr.responseJSON.msg;
                        }
                        toastr.error(errorMsg);
                    }
                });
            }
        });
    });
});
</script>
@endsection










