@extends('layouts.app')

@section('title', __('accounting-reports::lang.edit_cheque_book'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.edit_cheque_book')</h1>
</section>

<section class="content">
    {!! Form::open(['url' => route('accounting-reports.cheque-books.update', $chequeBook->id), 'method' => 'PUT', 'id' => 'edit_cheque_book_form']) !!}
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.cheque_book_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('accounting-reports::lang.bank_account') . ':*') !!}
                        {!! Form::select('account_id', $accounts, $chequeBook->account_id, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('book_name', __('accounting-reports::lang.book_name') . ':*') !!}
                        {!! Form::text('book_name', $chequeBook->book_name, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.book_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('book_number', __('accounting-reports::lang.book_number') . ':') !!}
                        {!! Form::text('book_number', $chequeBook->book_number, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.book_number')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $chequeBook->location_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('start_cheque_no', __('accounting-reports::lang.start_cheque_no') . ':*') !!}
                        {!! Form::text('start_cheque_no', $chequeBook->start_cheque_no, ['class' => 'form-control', 'required', 'readonly' => $chequeBook->chequeEntries()->count() > 0, 'id' => 'start_cheque_no']) !!}
                        @if($chequeBook->chequeEntries()->count() > 0)
                            <p class="help-block text-warning">@lang('accounting-reports::lang.cannot_change_cheque_range_if_entries_exist')</p>
                        @endif
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('end_cheque_no', __('accounting-reports::lang.end_cheque_no') . ':*') !!}
                        {!! Form::text('end_cheque_no', $chequeBook->end_cheque_no, ['class' => 'form-control', 'required', 'readonly' => $chequeBook->chequeEntries()->count() > 0, 'id' => 'end_cheque_no']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __('accounting-reports::lang.status') . ':*') !!}
                        {!! Form::select('status', ['active' => __('accounting-reports::lang.active'), 'completed' => 'Completed', 'cancelled' => __('accounting-reports::lang.cancelled')], $chequeBook->status, ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('issue_date', __('accounting-reports::lang.issue_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('issue_date', $chequeBook->issue_date ? @format_date($chequeBook->issue_date) : null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('expiry_date', __('accounting-reports::lang.expiry_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('expiry_date', $chequeBook->expiry_date ? @format_date($chequeBook->expiry_date) : null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('notes', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('notes', $chequeBook->notes, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> @lang('messages.update')
            </button>
            <a href="{{ route('accounting-reports.cheque-books.show', $chequeBook->id) }}" class="btn btn-default">
                <i class="fa fa-times"></i> @lang('messages.cancel')
            </a>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2({width: '100%'});
        $('.date-picker').datepicker(datepicker_params);
        
        // Form validation and submission
        $('#edit_cheque_book_form').validate({
            submitHandler: function(form) {
                $.ajax({
                    method: 'POST',
                    url: $(form).attr('action'),
                    data: $(form).serialize() + '&_method=PUT',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            window.location.href = '{{ route("accounting-reports.cheque-books.show", $chequeBook->id) }}';
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                toastr.error(value[0]);
                            });
                        } else {
                            toastr.error('@lang("messages.something_went_wrong")');
                        }
                    }
                });
                return false;
            }
        });
    });
</script>
@endsection










