@extends('layouts.app')

@section('title', __('accounting-reports::lang.cheque_book'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.cheque_book')</h1>
</section>

<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <a href="{{ route('accounting-reports.cheque-book.create') }}" class="btn btn-success">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_cheque_entry')
                    </a>
                    <a href="{{ route('accounting-reports.cheque-books.index') }}" class="btn btn-warning">
                        <i class="fa fa-book"></i> @lang('accounting-reports::lang.cheque_books')
                    </a>
                </div>
            </div>
        </div>
        <br>
        <div class="row">
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_account_id', __('accounting-reports::lang.bank_account') . ':') !!}
                    {!! Form::select('filter_account_id', $accounts, null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'id' => 'filter_account_id']) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_type', __('accounting-reports::lang.cheque_type') . ':') !!}
                    {!! Form::select('filter_type', ['issued' => __('accounting-reports::lang.issued'), 'received' => __('accounting-reports::lang.received')], null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'id' => 'filter_type']) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_status', __('accounting-reports::lang.cheque_status') . ':') !!}
                    {!! Form::select('filter_status', ['pending' => __('accounting-reports::lang.pending'), 'cleared' => __('accounting-reports::lang.cleared'), 'bounced' => __('accounting-reports::lang.bounced'), 'cancelled' => __('accounting-reports::lang.cancelled'), 'deposited' => __('accounting-reports::lang.deposited')], null, ['class' => 'form-control select2', 'placeholder' => __('lang_v1.all'), 'id' => 'filter_status']) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_start_date', __('report.start_date') . ':') !!}
                    {!! Form::text('filter_start_date', null, ['class' => 'form-control date-picker', 'readonly', 'id' => 'filter_start_date']) !!}
                </div>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    {!! Form::label('filter_end_date', __('report.end_date') . ':') !!}
                    {!! Form::text('filter_end_date', null, ['class' => 'form-control date-picker', 'readonly', 'id' => 'filter_end_date']) !!}
                </div>
            </div>
        </div>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="cheque_book_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.cheque_date')</th>
                        <th>@lang('accounting-reports::lang.cheque_no')</th>
                        <th>@lang('accounting-reports::lang.bank_account')</th>
                        <th>@lang('accounting-reports::lang.cheque_type')</th>
                        <th>@lang('accounting-reports::lang.amount')</th>
                        <th>@lang('accounting-reports::lang.payee_name')</th>
                        <th>@lang('accounting-reports::lang.cheque_status')</th>
                        <th>@lang('accounting-reports::lang.cleared_date')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
                <tfoot>
                    <tr>
                        <th colspan="4" style="text-align:right">@lang('sale.total'):</th>
                        <th></th>
                        <th colspan="4"></th>
                    </tr>
                </tfoot>
            </table>
        </div>
    @endcomponent
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var cheque_book_table = $('#cheque_book_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("accounting-reports.cheque-book.get-data") }}',
                data: function(d) {
                    d.account_id = $('#filter_account_id').val();
                    d.type = $('#filter_type').val();
                    d.status = $('#filter_status').val();
                    d.start_date = $('#filter_start_date').val();
                    d.end_date = $('#filter_end_date').val();
                }
            },
            columns: [
                { data: 'cheque_date', name: 'cheque_date' },
                { data: 'cheque_no', name: 'cheque_no' },
                { data: 'account_name', name: 'account_id' },
                { data: 'type', name: 'type' },
                { data: 'amount', name: 'amount' },
                { data: 'payee_name', name: 'payee_name' },
                { data: 'status', name: 'status' },
                { data: 'cleared_date', name: 'cleared_date' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
            footerCallback: function (row, data, start, end, display) {
                var api = this.api();
                var intVal = function (i) {
                    return typeof i === 'string' ? i.replace(/[\$,]/g, '') * 1 : typeof i === 'number' ? i : 0;
                };
                
                var total = api.column(4).data().reduce(function (a, b) {
                    return intVal(a) + intVal($(b).text());
                }, 0);
                
                $(api.column(4).footer()).html(__currency_trans_from_en(total, true));
            }
        });

        $('#filter_account_id, #filter_type, #filter_status, #filter_start_date, #filter_end_date').on('change', function() {
            cheque_book_table.ajax.reload();
        });

        $(document).on('click', '.delete_cheque_entry', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                cheque_book_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });
        
        // Issue Cheque Button - Opens modal with pre-filled data
        $(document).on('click', '.issue_cheque_btn', function() {
            var chequeId = $(this).data('cheque-id');
            var accountId = $(this).data('account-id');
            
            // Build URL with pre-filled parameters
            var url = '{{ route("accounting-reports.cheque-book.create") }}?cheque_id=' + chequeId;
            if (accountId) {
                url += '&account_id=' + accountId;
            }
            
            // Create modal container if it doesn't exist
            if ($('.issue_cheque_modal').length === 0) {
                $('body').append('<div class="modal fade issue_cheque_modal" tabindex="-1" role="dialog"></div>');
            }
            
            var modal = $('.issue_cheque_modal');
            
            // Load modal content using the standard btn-modal approach
            $.ajax({
                url: url,
                dataType: 'html',
                success: function(result) {
                    modal.html(result).modal('show');
                },
                error: function() {
                    toastr.error('@lang("messages.something_went_wrong")');
                }
            });
        });
    });
</script>
@endsection

