@extends('layouts.app')

@section('title', __('accounting-reports::lang.edit_cheque_entry'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.edit_cheque_entry')</h1>
</section>

<section class="content">
    {!! Form::open(['url' => route('accounting-reports.cheque-book.update', $cheque->id), 'method' => 'PUT', 'id' => 'edit_cheque_entry_form']) !!}
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.cheque_entry_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('accounting-reports::lang.bank_account') . ':*') !!}
                        {!! Form::select('account_id', $accounts, $cheque->account_id, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_no', __('accounting-reports::lang.cheque_no') . ':*') !!}
                        {!! Form::text('cheque_no', $cheque->cheque_no, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.cheque_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_date', __('accounting-reports::lang.cheque_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cheque_date', @format_date($cheque->cheque_date), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('accounting-reports::lang.amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('amount', @num_format($cheque->amount), ['class' => 'form-control input_number', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('type', __('accounting-reports::lang.cheque_type') . ':*') !!}
                        {!! Form::select('type', ['issued' => __('accounting-reports::lang.issued'), 'received' => __('accounting-reports::lang.received')], $cheque->type, ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __('accounting-reports::lang.cheque_status') . ':*') !!}
                        {!! Form::select('status', ['pending' => __('accounting-reports::lang.pending'), 'cleared' => __('accounting-reports::lang.cleared'), 'bounced' => __('accounting-reports::lang.bounced'), 'cancelled' => __('accounting-reports::lang.cancelled'), 'deposited' => __('accounting-reports::lang.deposited')], $cheque->status, ['class' => 'form-control select2', 'required', 'style' => 'width:100%', 'id' => 'status']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payee_name', __('accounting-reports::lang.payee_name') . ':') !!}
                        {!! Form::text('payee_name', $cheque->payee_name, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.payee_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, $cheque->location_id, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                        {!! Form::text('reference_no', $cheque->reference_no, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6" id="cleared_date_group" style="{{ $cheque->status === 'cleared' ? '' : 'display: none;' }}">
                    <div class="form-group">
                        {!! Form::label('cleared_date', __('accounting-reports::lang.cleared_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cleared_date', $cheque->cleared_date ? @format_date($cheque->cleared_date) : null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6" id="bounced_date_group" style="{{ $cheque->status === 'bounced' ? '' : 'display: none;' }}">
                    <div class="form-group">
                        {!! Form::label('bounced_date', __('accounting-reports::lang.bounced_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('bounced_date', $cheque->bounced_date ? @format_date($cheque->bounced_date) : null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_statement_ref', __('accounting-reports::lang.bank_statement_ref') . ':') !!}
                        {!! Form::text('bank_statement_ref', $cheque->bank_statement_ref, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_statement_ref')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_statement_date', __('accounting-reports::lang.bank_statement_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('bank_statement_date', $cheque->bank_statement_date ? @format_date($cheque->bank_statement_date) : null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-12" id="bounce_reason_group" style="{{ $cheque->status === 'bounced' ? '' : 'display: none;' }}">
                    <div class="form-group">
                        {!! Form::label('bounce_reason', __('accounting-reports::lang.bounce_reason') . ':') !!}
                        {!! Form::textarea('bounce_reason', $cheque->bounce_reason, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.bounce_reason')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('narration', __('daybook::lang.narration') . ':') !!}
                        {!! Form::textarea('narration', $cheque->narration, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('daybook::lang.narration')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> @lang('messages.update')
            </button>
            <a href="{{ route('accounting-reports.cheque-book.index') }}" class="btn btn-default">
                <i class="fa fa-times"></i> @lang('messages.cancel')
            </a>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        $('.select2').select2({width: '100%'});
        $('.date-picker').datepicker(datepicker_params);
        
        // Show/hide fields based on status
        $('#status').on('change', function() {
            var status = $(this).val();
            
            if (status === 'cleared') {
                $('#cleared_date_group').show();
                $('#bounced_date_group').hide();
                $('#bounce_reason_group').hide();
            } else if (status === 'bounced') {
                $('#cleared_date_group').hide();
                $('#bounced_date_group').show();
                $('#bounce_reason_group').show();
            } else {
                $('#cleared_date_group').hide();
                $('#bounced_date_group').hide();
                $('#bounce_reason_group').hide();
            }
        });
        
        // Form validation and submission
        $('#edit_cheque_entry_form').validate({
            submitHandler: function(form) {
                $.ajax({
                    method: 'POST',
                    url: $(form).attr('action'),
                    data: $(form).serialize() + '&_method=PUT',
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            window.location.href = '{{ route("accounting-reports.cheque-book.index") }}';
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                toastr.error(value[0]);
                            });
                        } else {
                            toastr.error('@lang("messages.something_went_wrong")');
                        }
                    }
                });
            }
        });
    });
</script>
@endsection










