@extends('layouts.app')

@section('title', __('accounting-reports::lang.add_cheque_entry'))

@section('content')
<section class="content-header">
    <h1>@lang('accounting-reports::lang.add_cheque_entry')</h1>
</section>

<section class="content">
    {!! Form::open(['url' => route('accounting-reports.cheque-book.store'), 'method' => 'post', 'id' => 'add_cheque_entry_form']) !!}
    <div class="box box-solid">
        <div class="box-header with-border">
            <h3 class="box-title">@lang('accounting-reports::lang.cheque_entry_details')</h3>
        </div>
        <div class="box-body">
            <div class="row">
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_id', __('accounting-reports::lang.bank_account') . ':*') !!}
                        {!! Form::select('account_id', $accounts, null, ['class' => 'form-control select2', 'required', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_no', __('accounting-reports::lang.cheque_no') . ':*') !!}
                        @php
                            $preSelectedChequeNo = $selectedChequeNo ?? null;
                        @endphp
                        @if($preSelectedChequeNo)
                            {!! Form::text('cheque_no', $preSelectedChequeNo, [
                                'class' => 'form-control', 
                                'required', 
                                'id' => 'cheque_no',
                                'readonly' => true
                            ]) !!}
                            <small class="help-block">@lang('accounting-reports::lang.cheque_number_pre_filled')</small>
                        @else
                            {!! Form::select('cheque_no', [], null, [
                                'class' => 'form-control select2', 
                                'required', 
                                'id' => 'cheque_no',
                                'placeholder' => __('accounting-reports::lang.select_pending_cheque'),
                                'style' => 'width:100%'
                            ]) !!}
                            <small class="help-block">@lang('accounting-reports::lang.only_pending_cheques_shown')</small>
                        @endif
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('cheque_date', __('accounting-reports::lang.cheque_date') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cheque_date', @format_date('now'), ['class' => 'form-control date-picker', 'required', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('amount', __('accounting-reports::lang.amount') . ':*') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('amount', null, ['class' => 'form-control input_number', 'required']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('type', __('accounting-reports::lang.cheque_type') . ':*') !!}
                        {!! Form::select('type', ['issued' => __('accounting-reports::lang.issued'), 'received' => __('accounting-reports::lang.received')], 'issued', ['class' => 'form-control select2', 'required', 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('status', __('accounting-reports::lang.cheque_status') . ':*') !!}
                        {!! Form::select('status', ['pending' => __('accounting-reports::lang.pending'), 'cleared' => __('accounting-reports::lang.cleared'), 'bounced' => __('accounting-reports::lang.bounced'), 'cancelled' => __('accounting-reports::lang.cancelled'), 'deposited' => __('accounting-reports::lang.deposited')], 'pending', ['class' => 'form-control select2', 'required', 'style' => 'width:100%', 'id' => 'status']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('payee_name', __('accounting-reports::lang.payee_name') . ':') !!}
                        {!! Form::text('payee_name', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.payee_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('location_id', __('purchase.business_location') . ':') !!}
                        {!! Form::select('location_id', $locations, null, ['class' => 'form-control select2', 'placeholder' => __('messages.please_select'), 'style' => 'width:100%']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('reference_no', __('accounting-reports::lang.reference_no') . ':') !!}
                        {!! Form::text('reference_no', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.reference_no')]) !!}
                    </div>
                </div>
                <div class="col-sm-6" id="cleared_date_group" style="display: none;">
                    <div class="form-group">
                        {!! Form::label('cleared_date', __('accounting-reports::lang.cleared_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('cleared_date', null, ['class' => 'form-control date-picker', 'readonly']) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('bank_statement_ref', __('accounting-reports::lang.bank_statement_ref') . ':') !!}
                        {!! Form::text('bank_statement_ref', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.bank_statement_ref')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('narration', __('daybook::lang.narration') . ':') !!}
                        {!! Form::textarea('narration', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('daybook::lang.narration')]) !!}
                    </div>
                </div>
            </div>
        </div>
        <div class="box-footer">
            <button type="submit" class="btn btn-primary">
                <i class="fa fa-save"></i> @lang('messages.save')
            </button>
            <a href="{{ route('accounting-reports.cheque-book.index') }}" class="btn btn-default">
                <i class="fa fa-times"></i> @lang('messages.cancel')
            </a>
        </div>
    </div>
    {!! Form::close() !!}
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    (function() {
        // Prevent duplicate execution
        if (window.chequeFormInitialized) {
            return;
        }
        window.chequeFormInitialized = true;
        
    // Function to load available cheques
    function loadAvailableCheques(accountId) {
        var chequeNoSelect = $('#cheque_no');
        
        if (!accountId) {
            chequeNoSelect.empty().append('<option value="">@lang("accounting-reports::lang.select_account_first")</option>');
            chequeNoSelect.prop('disabled', true);
            if (chequeNoSelect.hasClass('select2-hidden-accessible')) {
                chequeNoSelect.select2('destroy').select2({width: '100%'});
            }
            return;
        }
        
        chequeNoSelect.empty().append('<option value="">@lang("accounting-reports::lang.loading")...</option>');
        chequeNoSelect.prop('disabled', true);
        if (chequeNoSelect.hasClass('select2-hidden-accessible')) {
            chequeNoSelect.select2('destroy').select2({width: '100%'});
        }
        
        $.ajax({
            url: '{{ route("accounting-reports.cheque-book.get-available-cheques") }}',
            method: 'GET',
            data: { account_id: accountId },
            dataType: 'json',
            success: function(response) {
                chequeNoSelect.empty();
                if (response.available_cheques && response.available_cheques.length > 0) {
                    chequeNoSelect.append('<option value="">@lang("messages.please_select")</option>');
                    $.each(response.available_cheques, function(index, cheque) {
                        chequeNoSelect.append('<option value="' + cheque.cheque_no + '">' + cheque.display + '</option>');
                    });
                    chequeNoSelect.prop('disabled', false);
                    // Reinitialize select2 to show options
                    chequeNoSelect.select2('destroy').select2({width: '100%'});
                } else {
                    chequeNoSelect.append('<option value="">@lang("accounting-reports::lang.no_pending_cheques")</option>');
                    chequeNoSelect.prop('disabled', true);
                    if (response.message) {
                        toastr.warning(response.message);
                    } else {
                        toastr.warning('@lang("accounting-reports::lang.no_pending_cheques_available")');
                    }
                    chequeNoSelect.select2('destroy').select2({width: '100%'});
                }
            },
            error: function(xhr, status, error) {
                console.error('Error loading cheques:', error);
                console.error('Response:', xhr.responseText);
                chequeNoSelect.empty().append('<option value="">@lang("messages.something_went_wrong")</option>');
                chequeNoSelect.prop('disabled', true);
                toastr.error('@lang("messages.something_went_wrong")');
                chequeNoSelect.select2('destroy').select2({width: '100%'});
            }
        });
    }
    
    // Initialize when document is ready (for direct page load)
    $(document).ready(function() {
        initializeChequeForm();
    });
    
    // Also initialize when modal is shown (for modal load)
    $(document).on('shown.bs.modal', '.cheque_entry_modal', function() {
        initializeChequeForm();
    });
    
    function initializeChequeForm() {
        // Check if we're in a modal
        var isModal = $('.cheque_entry_modal').length > 0 || $('#add_cheque_entry_form').closest('.modal').length > 0;
        var container = isModal ? $('#add_cheque_entry_form').closest('.modal') : $('body');
        
        // Initialize select2 with proper dropdown parent for modals
        if (isModal && container.length) {
            $('.select2', container).select2({
                width: '100%',
                dropdownParent: container
            });
        } else {
            $('.select2').select2({width: '100%'});
        }
        
        // Initialize date picker
        if (typeof datepicker_params !== 'undefined') {
            $('.date-picker', container.length ? container : 'body').datepicker(datepicker_params);
        } else if (typeof datepicker_date_format !== 'undefined') {
            $('.date-picker', container.length ? container : 'body').datepicker({
                autoclose: true,
                format: datepicker_date_format
            });
        }
        
        var selectedAccountId = @json($selectedAccountId ?? null);
        var selectedChequeNo = @json($selectedChequeNo ?? null);
        var selectedChequeBookId = @json($selectedChequeBookId ?? null);
        var accountSelect = $('#account_id');
        var chequeNoSelect = $('#cheque_no');
        
        if (selectedAccountId && accountSelect.length) {
            accountSelect.val(selectedAccountId);
            
            // If cheque number is pre-selected (from Issue button), don't load dropdown
            if (selectedChequeNo && chequeNoSelect.is('input[readonly]')) {
                // Cheque number is already pre-filled, just trigger change for account
                accountSelect.trigger('change');
            } else {
                // Load cheques immediately if account is pre-selected
                setTimeout(function() {
                    loadAvailableCheques(selectedAccountId);
                }, 300);
            }
        }
        
        // Load available cheques when account is selected
        accountSelect.off('change.cheque-load').on('change.cheque-load', function() {
            var accountId = $(this).val();
            loadAvailableCheques(accountId);
        });
        
        // Show/hide cleared_date based on status
        $('#status').off('change.cleared-date').on('change.cleared-date', function() {
            if ($(this).val() === 'cleared') {
                $('#cleared_date_group').show();
            } else {
                $('#cleared_date_group').hide();
            }
        });
        
        // Form validation and submission
        $('#add_cheque_entry_form').off('submit').on('submit', function(e) {
            e.preventDefault();
            
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            toastr.success(response.msg);
                            // Close modal if opened in modal
                            $('.cheque_entry_modal').modal('hide');
                            // Reload parent page or redirect
                            setTimeout(function() {
                                if (window.parent && window.parent !== window) {
                                    window.parent.location.reload();
                                } else {
                                    window.location.href = '{{ route("accounting-reports.cheque-book.index") }}';
                                }
                            }, 500);
                        } else {
                            toastr.error(response.msg);
                        }
                    },
                    error: function(xhr) {
                        if (xhr.status === 422) {
                            var errors = xhr.responseJSON.errors;
                            $.each(errors, function(key, value) {
                                toastr.error(value[0]);
                            });
                        } else {
                            toastr.error('@lang("messages.something_went_wrong")');
                        }
                    }
                });
            }
        });
    })();
</script>
@endsection










