<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.capital_account_details')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.account_name'):</strong></label>
                        <p>{{ $capital_account->account_name }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.account_type'):</strong></label>
                        <p>{{ $capital_account->account_type_label }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.opening_date'):</strong></label>
                        <p>{{ !empty($capital_account->opening_date) ? @format_date($capital_account->opening_date) : '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.opening_balance'):</strong></label>
                        <p><span class="display_currency" data-currency_symbol="true">{{ $capital_account->opening_balance }}</span></p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.current_balance'):</strong></label>
                        <p>
                            <span class="display_currency {{ $capital_account->current_balance >= 0 ? 'text-success' : 'text-danger' }}" data-currency_symbol="true" style="font-weight: bold; font-size: 16px;">
                                {{ $capital_account->current_balance }}
                            </span>
                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.contact_person'):</strong></label>
                        <p>{{ $capital_account->contact_person ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.contact_email'):</strong></label>
                        <p>{{ $capital_account->contact_email ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.contact_phone'):</strong></label>
                        <p>{{ $capital_account->contact_phone ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.address'):</strong></label>
                        <p>{{ $capital_account->address ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.description'):</strong></label>
                        <p>{{ $capital_account->description ?: '-' }}</p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.status'):</strong></label>
                        <p>
                            @if($capital_account->is_active)
                                <span class="label label-success">@lang('accounting-reports::lang.active')</span>
                            @else
                                <span class="label label-danger">@lang('accounting-reports::lang.inactive')</span>
                            @endif
                        </p>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        <label><strong>@lang('accounting-reports::lang.created_at'):</strong></label>
                        <p>{{ @format_date($capital_account->created_at) }}</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
        </div>
    </div>
</div>

