@extends('layouts.app')

@section('title', __('accounting-reports::lang.capital_accounts'))

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header">
    <h1>@lang('accounting-reports::lang.capital_accounts')</h1>
</section>

<!-- Main content -->
<section class="content">
    @component('components.widget', ['class' => 'box-primary'])
        <div class="row">
            <div class="col-md-12">
                <div class="btn-group">
                    <button type="button" class="btn btn-success btn-modal" data-href="{{ action([\Modules\AccountingReports\Http\Controllers\CapitalAccountController::class, 'create']) }}" data-container=".capital_account_modal">
                        <i class="fa fa-plus"></i> @lang('accounting-reports::lang.add_capital_account')
                    </button>
                </div>
            </div>
        </div>
        <br>
        
        <div class="table-responsive">
            <table class="table table-bordered table-striped table-hover" id="capital_accounts_table" style="width:100%;">
                <thead>
                    <tr>
                        <th>@lang('accounting-reports::lang.account_name')</th>
                        <th>@lang('accounting-reports::lang.account_type')</th>
                        <th>@lang('accounting-reports::lang.opening_balance')</th>
                        <th>@lang('accounting-reports::lang.current_balance')</th>
                        <th>@lang('accounting-reports::lang.opening_date')</th>
                        <th>@lang('accounting-reports::lang.contact_person')</th>
                        <th>@lang('accounting-reports::lang.status')</th>
                        <th>@lang('accounting-reports::lang.created_at')</th>
                        <th>@lang('messages.action')</th>
                    </tr>
                </thead>
            </table>
        </div>
    @endcomponent
    
    <div class="modal fade capital_account_modal" tabindex="-1" role="dialog"></div>
</section>

@endsection

@section('javascript')
<script type="text/javascript">
    $(document).ready(function() {
        var capital_accounts_table = $('#capital_accounts_table').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ action([\Modules\AccountingReports\Http\Controllers\CapitalAccountController::class, "getData"]) }}',
                data: function(d) {
                    d.is_active = $('#filter_is_active').val();
                    d.account_type = $('#filter_account_type').val();
                }
            },
            columns: [
                { data: 'account_name', name: 'account_name' },
                { data: 'account_type', name: 'account_type' },
                { data: 'opening_balance', name: 'opening_balance' },
                { data: 'current_balance', name: 'current_balance' },
                { data: 'opening_date', name: 'opening_date' },
                { data: 'contact_person', name: 'contact_person' },
                { data: 'is_active', name: 'is_active' },
                { data: 'created_at', name: 'created_at' },
                { data: 'action', name: 'action', orderable: false, searchable: false }
            ],
        });

        $(document).on('click', '.edit_account', function(e) {
            e.preventDefault();
            $('div.capital_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('form#capital_account_form').submit(function(e) {
                    e.preventDefault();
                    $.ajax({
                        method: 'POST',
                        url: $(this).attr('action'),
                        data: $(this).serialize(),
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                $('div.capital_account_modal').modal('hide');
                                toastr.success(response.msg);
                                capital_accounts_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                });
            });
        });

        $(document).on('click', '.view_account', function(e) {
            e.preventDefault();
            $('div.capital_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
            });
        });

        $(document).on('click', '.delete_account', function() {
            var url = $(this).data('href');
            swal({
                title: LANG.sure,
                text: '{{ __("accounting-reports::lang.confirm_delete_capital_account") }}',
                icon: "warning",
                buttons: true,
                dangerMode: true,
            }).then((confirmed) => {
                if (confirmed) {
                    $.ajax({
                        method: 'DELETE',
                        url: url,
                        dataType: 'json',
                        success: function(response) {
                            if (response.success) {
                                toastr.success(response.msg);
                                capital_accounts_table.ajax.reload();
                            } else {
                                toastr.error(response.msg);
                            }
                        }
                    });
                }
            });
        });

        $(document).on('submit', 'form#add_capital_account_form', function(e) {
            e.preventDefault();
            $(this).validate();
            if ($(this).valid()) {
                $.ajax({
                    method: 'POST',
                    url: $(this).attr('action'),
                    data: $(this).serialize(),
                    dataType: 'json',
                    success: function(response) {
                        if (response.success) {
                            $('div.capital_account_modal').modal('hide');
                            toastr.success(response.msg);
                            capital_accounts_table.ajax.reload();
                        } else {
                            toastr.error(response.msg);
                        }
                    }
                });
            }
        });
        
        // Initialize modal
        $(document).on('click', '.btn-modal', function(e) {
            e.preventDefault();
            $('div.capital_account_modal').load($(this).data('href'), function() {
                $(this).modal('show');
                $('.date-picker').datepicker({
                    autoclose: true,
                    format: datepicker_date_format
                });
            });
        });
    });
</script>
@endsection

