<div class="modal-dialog modal-lg">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\CapitalAccountController::class, 'update'], [$capital_account->id]), 'method' => 'put', 'id' => 'capital_account_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.edit_capital_account')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('account_name', __('accounting-reports::lang.account_name') . ':*') !!}
                        {!! Form::text('account_name', $capital_account->account_name, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.account_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_type', __('accounting-reports::lang.account_type') . ':*') !!}
                        {!! Form::select('account_type', $accountTypes, $capital_account->account_type, ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_date', __('accounting-reports::lang.opening_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('opening_date', !empty($capital_account->opening_date) ? @format_date($capital_account->opening_date) : null, ['class' => 'form-control date-picker', 'readonly', 'placeholder' => __('accounting-reports::lang.opening_date')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_balance', __('accounting-reports::lang.opening_balance') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('opening_balance', $capital_account->opening_balance, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.opening_balance')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_person', __('accounting-reports::lang.contact_person') . ':') !!}
                        {!! Form::text('contact_person', $capital_account->contact_person, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_person')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_email', __('accounting-reports::lang.contact_email') . ':') !!}
                        {!! Form::email('contact_email', $capital_account->contact_email, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_email')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_phone', __('accounting-reports::lang.contact_phone') . ':') !!}
                        {!! Form::text('contact_phone', $capital_account->contact_phone, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_phone')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __('accounting-reports::lang.address') . ':') !!}
                        {!! Form::textarea('address', $capital_account->address, ['class' => 'form-control', 'rows' => '2', 'placeholder' => __('accounting-reports::lang.address')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', $capital_account->description, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('is_active', 1, $capital_account->is_active) !!}
                                @lang('accounting-reports::lang.active')
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.update')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

