<div class="modal-dialog modal-lg">
    <div class="modal-content">
        {!! Form::open(['url' => action([\Modules\AccountingReports\Http\Controllers\CapitalAccountController::class, 'store']), 'method' => 'post', 'id' => 'add_capital_account_form']) !!}
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
            <h4 class="modal-title">@lang('accounting-reports::lang.add_capital_account')</h4>
        </div>
        <div class="modal-body">
            <div class="row">
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('account_name', __('accounting-reports::lang.account_name') . ':*') !!}
                        {!! Form::text('account_name', null, ['class' => 'form-control', 'required', 'placeholder' => __('accounting-reports::lang.account_name')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('account_type', __('accounting-reports::lang.account_type') . ':*') !!}
                        {!! Form::select('account_type', $accountTypes, 'owner', ['class' => 'form-control', 'required']) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_date', __('accounting-reports::lang.opening_date') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </span>
                            {!! Form::text('opening_date', null, ['class' => 'form-control date-picker', 'readonly', 'placeholder' => __('accounting-reports::lang.opening_date')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('opening_balance', __('accounting-reports::lang.opening_balance') . ':') !!}
                        <div class="input-group">
                            <span class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </span>
                            {!! Form::text('opening_balance', 0, ['class' => 'form-control input_number', 'placeholder' => __('accounting-reports::lang.opening_balance')]) !!}
                        </div>
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_person', __('accounting-reports::lang.contact_person') . ':') !!}
                        {!! Form::text('contact_person', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_person')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_email', __('accounting-reports::lang.contact_email') . ':') !!}
                        {!! Form::email('contact_email', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_email')]) !!}
                    </div>
                </div>
                <div class="col-sm-6">
                    <div class="form-group">
                        {!! Form::label('contact_phone', __('accounting-reports::lang.contact_phone') . ':') !!}
                        {!! Form::text('contact_phone', null, ['class' => 'form-control', 'placeholder' => __('accounting-reports::lang.contact_phone')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('address', __('accounting-reports::lang.address') . ':') !!}
                        {!! Form::textarea('address', null, ['class' => 'form-control', 'rows' => '2', 'placeholder' => __('accounting-reports::lang.address')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        {!! Form::label('description', __('accounting-reports::lang.description') . ':') !!}
                        {!! Form::textarea('description', null, ['class' => 'form-control', 'rows' => '3', 'placeholder' => __('accounting-reports::lang.description')]) !!}
                    </div>
                </div>
                <div class="col-sm-12">
                    <div class="form-group">
                        <div class="checkbox">
                            <label>
                                {!! Form::checkbox('is_active', 1, true) !!}
                                @lang('accounting-reports::lang.active')
                            </label>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-default pull-left" data-dismiss="modal">@lang('messages.close')</button>
            <button type="submit" class="btn btn-primary">@lang('messages.save')</button>
        </div>
        {!! Form::close() !!}
    </div>
</div>

